/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.helpers;

public class ColorHelper {
    public static final int DEFAULT_TEXT_COLOR = 0x404040;

    public static float[] toNormalizedRGB(int color) {
        return ColorHelper.toNormalizedRGBA(color | 0xFF000000);
    }

    public static float[] toNormalizedRGBA(int color) {
        int[] rgba = ColorHelper.toRGBA(color);
        return new float[]{(float)rgba[0] / 255.0f, (float)rgba[1] / 255.0f, (float)rgba[2] / 255.0f, (float)rgba[3] / 255.0f};
    }

    public static int[] toRGBA(int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new int[]{red, green, blue, alpha};
    }

    public static int fromRGBA(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int fromRGB(int r, int g, int b) {
        return ColorHelper.fromRGBA(r, g, b, 255);
    }

    public static int fromNormalizedRGBA(float r, float g, float b, float a) {
        return ColorHelper.fromRGBA((int)r * 255, (int)g * 255, (int)b * 255, (int)a * 255);
    }

    public static int fromNormalizedRGB(float r, float g, float b) {
        return ColorHelper.fromNormalizedRGBA(r, g, b, 1.0f);
    }

    public static int blendBetweenColors(double val, int minColor, int maxColor) {
        return ColorHelper.blendBetweenColors(val, minColor, maxColor, 0.0, 1.0);
    }

    public static int blendBetweenColors(double val, int minColor, int maxColor, double min, double max) {
        if (min == max) {
            return maxColor;
        }
        double range = max - min;
        double ratioOfMax = (max - val) / range;
        double ratioOfMin = (val - min) / range;
        int[] minColorRGBA = ColorHelper.toRGBA(minColor);
        int[] maxColorRGBA = ColorHelper.toRGBA(maxColor);
        int[] color = new int[]{(int)((double)maxColorRGBA[0] * ratioOfMin + (double)minColorRGBA[0] * ratioOfMax), (int)((double)maxColorRGBA[1] * ratioOfMin + (double)minColorRGBA[1] * ratioOfMax), (int)((double)maxColorRGBA[2] * ratioOfMin + (double)minColorRGBA[2] * ratioOfMax), (int)((double)maxColorRGBA[3] * ratioOfMin + (double)minColorRGBA[3] * ratioOfMax)};
        return ColorHelper.fromRGBA(color[0], color[1], color[2], color[3]);
    }
}

