/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import squeek.veganoption.helpers.FluidHelper;

public class BlockHelper {
    public static final float BLOCK_HARDNESS_UNBREAKABLE = -1.0f;

    public static BlockPos blockPos(World world, int x, int y, int z) {
        return new BlockPos(world, x, y, z);
    }

    public static boolean isMaterial(BlockPos blockPos, Material material) {
        return blockPos.getBlock().func_149688_o() == material;
    }

    public static boolean isAdjacentToMaterial(BlockPos blockPos, Material material) {
        for (BlockPos blockToCheck : BlockHelper.getBlocksAdjacentTo(blockPos)) {
            if (!BlockHelper.isMaterial(blockToCheck, material)) continue;
            return true;
        }
        return false;
    }

    public static BlockPos[] getBlocksAdjacentTo(BlockPos blockPos) {
        return new BlockPos[]{blockPos.getOffset(-1, 0, 0), blockPos.getOffset(1, 0, 0), blockPos.getOffset(0, 0, -1), blockPos.getOffset(0, 0, 1)};
    }

    public static boolean isWater(BlockPos blockPos) {
        return BlockHelper.isMaterial(blockPos, Material.field_151586_h);
    }

    public static boolean isAdjacentToOrCoveredInWater(BlockPos blockPos) {
        return BlockHelper.isWater(blockPos.getOffset(0, 1, 0)) || BlockHelper.isAdjacentToWater(blockPos);
    }

    public static boolean isAdjacentToWater(BlockPos blockPos) {
        return BlockHelper.isAdjacentToMaterial(blockPos, Material.field_151586_h);
    }

    public static BlockPos followWaterStreamToSourceBlock(BlockPos blockPos) {
        return BlockHelper.followFluidStreamToSourceBlock(blockPos, FluidRegistry.WATER);
    }

    public static BlockPos followFluidStreamToSourceBlock(BlockPos blockPos, Fluid fluid) {
        return BlockHelper.followFluidStreamToSourceBlock(blockPos, fluid, new HashSet<BlockPos>());
    }

    public static BlockPos followFluidStreamToSourceBlock(BlockPos blockPos, Fluid fluid, Set<BlockPos> blocksChecked) {
        if (fluid.getBlock() instanceof BlockFluidFinite || blockPos.getMeta() == FluidHelper.getStillMetadata(fluid)) {
            return blockPos;
        }
        ArrayList<BlockPos> blocksToCheck = new ArrayList<BlockPos>();
        blocksToCheck.add(blockPos.getOffset(0, 1, 0));
        blocksToCheck.addAll(Arrays.asList(BlockHelper.getBlocksAdjacentTo(blockPos)));
        for (BlockPos blockToCheck : blocksToCheck) {
            if (FluidHelper.getFluidTypeOfBlock(blockToCheck.getBlock()) != fluid || blocksChecked.contains(blockToCheck)) continue;
            if (blockToCheck.getMeta() == 0) {
                return blockToCheck;
            }
            blocksChecked.add(blockToCheck);
            BlockPos foundSourceBlock = BlockHelper.followFluidStreamToSourceBlock(blockToCheck, fluid, blocksChecked);
            if (foundSourceBlock == null) continue;
            return foundSourceBlock;
        }
        return null;
    }

    public static BlockPos[] getBlocksInRadiusAround(BlockPos centerBlock, int radius) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        int radiusSq = radius * radius;
        for (int xOffset = 0; xOffset <= radius; ++xOffset) {
            for (int yOffset = 0; yOffset <= radius; ++yOffset) {
                for (int zOffset = 0; zOffset <= radius; ++zOffset) {
                    BlockPos block = centerBlock.getOffset(xOffset, yOffset, zOffset);
                    int xDelta = block.x - centerBlock.x;
                    int yDelta = block.y - centerBlock.y;
                    int zDelta = block.z - centerBlock.z;
                    int deltaLengthSq = xDelta * xDelta + yDelta * yDelta + zDelta * zDelta;
                    if (deltaLengthSq > radiusSq) continue;
                    blocks.add(block);
                    blocks.add(centerBlock.getOffset(-xOffset, yOffset, zOffset));
                    blocks.add(centerBlock.getOffset(xOffset, yOffset, -zOffset));
                    blocks.add(centerBlock.getOffset(-xOffset, yOffset, -zOffset));
                    blocks.add(centerBlock.getOffset(xOffset, -yOffset, zOffset));
                    blocks.add(centerBlock.getOffset(xOffset, -yOffset, -zOffset));
                    blocks.add(centerBlock.getOffset(-xOffset, -yOffset, zOffset));
                    blocks.add(centerBlock.getOffset(-xOffset, -yOffset, -zOffset));
                }
            }
        }
        return blocks.toArray(new BlockPos[0]);
    }

    public static BlockPos[] filterBlockListToBreakableBlocks(BlockPos ... blocks) {
        ArrayList<BlockPos> filteredBlocks = new ArrayList<BlockPos>();
        for (BlockPos blockPos : blocks) {
            Block block = blockPos.getBlock();
            if (block == null || block.isAir((IBlockAccess)blockPos.world, blockPos.x, blockPos.y, blockPos.z) || BlockHelper.isBlockUnbreakable(block, blockPos.world, blockPos.x, blockPos.y, blockPos.z) || block.func_149688_o().func_76224_d()) continue;
            filteredBlocks.add(blockPos);
        }
        return filteredBlocks.toArray(new BlockPos[0]);
    }

    public static boolean isBlockUnbreakable(Block block, World world, int x, int y, int z) {
        return block.func_149712_f(world, x, y, z) == -1.0f;
    }

    public static class BlockPos {
        public final World world;
        public final int x;
        public final int y;
        public final int z;

        public BlockPos(World world, int x, int y, int z) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Block getBlock() {
            return this.world.func_147439_a(this.x, this.y, this.z);
        }

        public int getMeta() {
            return this.world.func_72805_g(this.x, this.y, this.z);
        }

        public TileEntity getTile() {
            return this.world.func_147438_o(this.x, this.y, this.z);
        }

        public BlockPos getOffset(int x, int y, int z) {
            return new BlockPos(this.world, this.x + x, this.y + y, this.z + z);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.world == null ? 0 : this.world.hashCode());
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BlockPos other = (BlockPos)obj;
            if (this.world == null ? other.world != null : !this.world.equals(other.world)) {
                return false;
            }
            if (this.x != other.x) {
                return false;
            }
            if (this.y != other.y) {
                return false;
            }
            return this.z == other.z;
        }
    }
}

