/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.opengl.GL11;
import squeek.veganoption.ModInfo;
import squeek.veganoption.blocks.tiles.TileEntityComposter;
import squeek.veganoption.content.registry.CompostRegistry;
import squeek.veganoption.helpers.LangHelper;
import squeek.veganoption.inventory.ContainerComposter;
import squeek.veganoption.network.MessageComposterTumble;
import squeek.veganoption.network.NetworkHandler;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class GuiComposter
extends GuiContainer
implements INEIGuiHandler {
    protected IInventory playerInventory = null;
    protected IInventory inventory = null;
    protected TileEntityComposter composter = null;
    public static final ResourceLocation guiTexture = new ResourceLocation("textures/gui/container/generic_54.png");
    public static final ResourceLocation guiComponents = new ResourceLocation(ModInfo.MODID_LOWER, "textures/gui/composter.png");
    public int xStart;
    public int yStart;
    public int inventoryRows;
    public static final int GUI_HEADER_SIZE = 17;
    public static final int SIDE_TAB_WIDTH = 18;
    public static final int SIDE_TAB_HEIGHT = 54;
    public static final int SIDE_TAB_Y_START = 17;
    public static final int SIDE_TAB_OVERLAP = 3;
    public static final String DEGREE_SYMBOL = "\u00b0";

    public GuiComposter(InventoryPlayer playerInventory, TileEntityComposter composter) {
        super((Container)new ContainerComposter(playerInventory, composter));
        this.composter = composter;
        this.inventory = composter;
        this.playerInventory = playerInventory;
        this.inventoryRows = this.inventory.func_70302_i_() / 9;
        this.field_147000_g = 114 + this.inventoryRows * 18;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.xStart = (this.field_146294_l - this.field_146999_f) / 2;
        this.yStart = (this.field_146295_m - this.field_147000_g) / 2;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_146281_b() {
        super.func_146281_b();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (CompostRegistry.isBrown(event.itemStack)) {
            String itemName = (String)event.toolTip.get(0);
            event.toolTip.set(0, EnumChatFormatting.GOLD + itemName + EnumChatFormatting.RESET);
        } else if (CompostRegistry.isGreen(event.itemStack)) {
            String itemName = (String)event.toolTip.get(0);
            event.toolTip.set(0, EnumChatFormatting.GREEN + itemName + EnumChatFormatting.RESET);
        }
    }

    public boolean isMouseOverTumbleButton(int mouseX, int mouseY) {
        int buttonStartX = this.xStart - 18 + 3 + 4;
        int buttonStartY = this.yStart + 17 + 54 - 17;
        return mouseX >= buttonStartX && mouseX < buttonStartX + 13 && mouseY >= buttonStartY && mouseY < buttonStartY + 13;
    }

    public boolean isMouseOverTemperature(int mouseX, int mouseY) {
        int mouseoverStartX = this.xStart - 18 + 3 + 4;
        int mouseoverStartY = this.yStart + 17 + 4;
        return mouseX >= mouseoverStartX && mouseX < mouseoverStartX + 13 && mouseY >= mouseoverStartY && mouseY < mouseoverStartY + 32;
    }

    public boolean isMouseOverCompostingPercent(int mouseX, int mouseY) {
        int mouseoverStartX = this.xStart + this.field_146999_f - 3 + 1;
        int mouseoverStartY = this.yStart + 17 + 5;
        return mouseX >= mouseoverStartX && mouseX < mouseoverStartX + 12 && mouseY >= mouseoverStartY && mouseY < mouseoverStartY + 44;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.inventory.func_145818_k_() ? this.inventory.func_145825_b() : I18n.func_135052_a((String)this.inventory.func_145825_b(), (Object[])new Object[0]), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145818_k_() ? this.playerInventory.func_145825_b() : I18n.func_135052_a((String)this.playerInventory.func_145825_b(), (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiComponents);
        this.func_73729_b(-11, 54, 0, this.composter.isAerating() ? 80 : (this.isMouseOverTumbleButton(mouseX, mouseY) ? 67 : 54), 13, 13);
        super.func_146979_b(mouseX, mouseY);
    }

    public List<String> getRobustToolTip(String identifier, Object ... args) {
        ArrayList<String> toolTipText = new ArrayList<String>(this.field_146289_q.func_78271_c(LangHelper.translate(identifier + ".desc").replaceAll("\\\\n", String.valueOf('\n')), this.field_146999_f));
        toolTipText.add(0, LangHelper.translate(identifier, args));
        for (int i = 1; i < toolTipText.size(); ++i) {
            toolTipText.set(i, EnumChatFormatting.GRAY + (String)toolTipText.get(i));
        }
        return toolTipText;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        if (this.isMouseOverTumbleButton(mouseX, mouseY)) {
            this.drawHoveringText(this.getRobustToolTip("gui.composter.tumble", new Object[0]), mouseX, mouseY, this.field_146289_q);
        } else if (this.isMouseOverTemperature(mouseX, mouseY)) {
            this.drawHoveringText(this.getRobustToolTip("gui.composter.temperature", Math.round(this.composter.getCompostTemperature()) + DEGREE_SYMBOL + "C"), mouseX, mouseY, this.field_146289_q);
        } else if (this.isMouseOverCompostingPercent(mouseX, mouseY)) {
            this.drawHoveringText(this.getRobustToolTip("gui.composter.composting", (int)(this.composter.getCompostingPercent() * 100.0f) + "%"), mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        this.func_73729_b(this.xStart, this.yStart, 0, 0, this.field_146999_f, this.inventoryRows * 18 + 17);
        this.func_73729_b(this.xStart, this.yStart + this.inventoryRows * 18 + 17, 0, 126, this.field_146999_f, 96);
        this.field_146297_k.func_110434_K().func_110577_a(guiComponents);
        this.func_73729_b(this.xStart - 18 + 3, this.yStart + 17, 0, 0, 18, 54);
        this.func_73729_b(this.xStart + this.field_146999_f - 3, this.yStart + 17, 18, 0, 18, 54);
        this.func_73729_b(this.xStart + this.field_146999_f - 3 + 1, this.yStart + 17 + 5, 47, 0, 12, Math.round(this.composter.getCompostingPercent() * 44.0f));
        int temperatureHeight = Math.max(0, Math.round((this.composter.getCompostTemperature() - this.composter.biomeTemperature) / (70.0f - this.composter.biomeTemperature) * 30.0f));
        this.func_73729_b(this.xStart - 18 + 3 + 5, this.yStart + 17 + 5 + 30 - temperatureHeight, 36, 30 - temperatureHeight, 11, temperatureHeight);
    }

    protected void func_73864_a(int mouseX, int mouseY, int type) {
        if (this.isMouseOverTumbleButton(mouseX, mouseY) && type == 0) {
            NetworkHandler.channel.sendToServer((IMessage)new MessageComposterTumble());
        }
        super.func_73864_a(mouseX, mouseY, type);
    }

    private boolean rectanglesOverlap(int Ax, int Ay, int Aw, int Ah, int Bx, int By, int Bw, int Bh) {
        return Ax < Bx + Bw && Ax + Aw > Bx && Ay < By + Bh && Ay + Ah > By;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        return this.rectanglesOverlap(x, y, w, h, this.xStart - 18, this.yStart + 17, this.field_146999_f + 36, 54);
    }

    @Optional.Method(modid="NotEnoughItems")
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return new ArrayList<TaggedInventoryArea>();
    }

    @Optional.Method(modid="NotEnoughItems")
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack itemStack) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return currentVisibility;
    }
}

