/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.content.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import squeek.veganoption.content.recipes.InputItemStack;
import squeek.veganoption.content.recipes.PistonCraftingRecipe;
import squeek.veganoption.helpers.FluidHelper;

public class PistonCraftingRegistry {
    protected static List<PistonCraftingRecipe> pistonRecipes = new ArrayList<PistonCraftingRecipe>();

    public static List<PistonCraftingRecipe> getRecipes() {
        return pistonRecipes;
    }

    public static void register(PistonCraftingRecipe pistonRecipe) {
        pistonRecipes.add(pistonRecipe);
    }

    public static List<PistonCraftingRecipe> getSubsetByInput(ItemStack search) {
        ArrayList<PistonCraftingRecipe> matchingRecipes = new ArrayList<PistonCraftingRecipe>();
        block0: for (PistonCraftingRecipe recipe : PistonCraftingRegistry.getRecipes()) {
            if (recipe.fluidInput != null && recipe.fluidInput.isFluidEqual(FluidHelper.fromItemStack(search))) {
                matchingRecipes.add(recipe);
                continue;
            }
            for (InputItemStack recipeInput : recipe.itemInputs) {
                if (!recipeInput.matches(search)) continue;
                matchingRecipes.add(recipe);
                continue block0;
            }
        }
        return matchingRecipes;
    }

    public static List<PistonCraftingRecipe> getSubsetByInput(FluidStack search) {
        return PistonCraftingRegistry.getSubsetByInput(FluidHelper.toItemStack(search));
    }

    public static List<PistonCraftingRecipe> getSubsetByOutput(ItemStack search) {
        ArrayList<PistonCraftingRecipe> matchingRecipes = new ArrayList<PistonCraftingRecipe>();
        block0: for (PistonCraftingRecipe recipe : PistonCraftingRegistry.getRecipes()) {
            if (recipe.fluidOutput != null && recipe.fluidOutput.isFluidEqual(FluidHelper.fromItemStack(search))) {
                matchingRecipes.add(recipe);
                continue;
            }
            for (ItemStack recipeOutput : recipe.itemOutputs) {
                if (!recipeOutput.func_77969_a(search)) continue;
                matchingRecipes.add(recipe);
                continue block0;
            }
        }
        return matchingRecipes;
    }

    public static List<PistonCraftingRecipe> getSubsetByOutput(FluidStack search) {
        return PistonCraftingRegistry.getSubsetByOutput(FluidHelper.toItemStack(search));
    }
}

