/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.content.recipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import squeek.veganoption.content.crafting.PistonCraftingHandler;
import squeek.veganoption.content.recipes.InputItemStack;
import squeek.veganoption.helpers.WorldHelper;

public class PistonCraftingRecipe {
    public List<InputItemStack> itemInputs = new ArrayList<InputItemStack>();
    public FluidStack fluidInput = null;
    public List<ItemStack> itemOutputs = new ArrayList<ItemStack>();
    public FluidStack fluidOutput = null;
    protected Random rand = new Random();

    public PistonCraftingRecipe(Object output, Object ... inputs) {
        this(new Object[]{output}, inputs);
    }

    public PistonCraftingRecipe(Object[] outputs, Object[] inputs) {
        for (Object input : inputs) {
            if (input instanceof InputItemStack) {
                this.itemInputs.add((InputItemStack)input);
                continue;
            }
            if (input instanceof String || input instanceof Item || input instanceof Block || input instanceof ItemStack) {
                this.itemInputs.add(new InputItemStack(input));
                continue;
            }
            if (input instanceof Fluid) {
                this.fluidInput = new FluidStack((Fluid)input, 1000);
                continue;
            }
            if (input instanceof FluidStack) {
                this.fluidInput = (FluidStack)input;
                continue;
            }
            throw new RuntimeException("Unsupported PistonCraftingRecipe input: " + input);
        }
        for (Object output : outputs) {
            if (output instanceof Item) {
                this.itemOutputs.add(new ItemStack((Item)output));
                continue;
            }
            if (output instanceof Block) {
                this.itemOutputs.add(new ItemStack((Block)output));
                continue;
            }
            if (output instanceof ItemStack) {
                this.itemOutputs.add((ItemStack)output);
                continue;
            }
            if (output instanceof Fluid) {
                this.fluidOutput = new FluidStack((Fluid)output, 1000);
                continue;
            }
            if (output instanceof FluidStack) {
                this.fluidOutput = (FluidStack)output;
                continue;
            }
            throw new RuntimeException("Unsupported PistonCraftingRecipe output: " + output);
        }
    }

    public boolean tryCraft(World world, int x, int y, int z) {
        boolean isReplacementPossible;
        IFluidHandler fluidHandler = this.getOutputFluidHandler(world, x, y, z);
        if (!this.canOutputFluid(fluidHandler)) {
            return false;
        }
        PistonCraftingHandler.WorldPosition fluidPos = new PistonCraftingHandler.WorldPosition(world, x, y, z);
        FluidStack displacedFluid = PistonCraftingHandler.displacedLiquids.get((Object)fluidPos);
        if (!this.fluidInputMatches(displacedFluid)) {
            return false;
        }
        List<EntityItem> entityItemsWithin = WorldHelper.getItemEntitiesWithin(world, x, y, z);
        Map<InputItemStack, List<EntityItem>> entityItemsByInput = PistonCraftingRecipe.getEntityItemsByInput(this.itemInputs, entityItemsWithin);
        if (!this.itemInputMatches(entityItemsByInput)) {
            return false;
        }
        boolean bl = isReplacementPossible = this.itemInputs.size() == this.itemOutputs.size() && this.fluidOutput == null;
        if (isReplacementPossible) {
            int i = 0;
            for (Map.Entry<InputItemStack, List<EntityItem>> entry : entityItemsByInput.entrySet()) {
                ItemStack output = this.itemOutputs.get(i);
                for (EntityItem inputEntity : entry.getValue()) {
                    ItemStack inputStack = inputEntity.func_92059_d();
                    ItemStack newItemStack = output.func_77946_l();
                    newItemStack.field_77994_a = (int)((float)inputStack.field_77994_a * ((float)output.field_77994_a / (float)entry.getKey().stackSize()));
                    inputEntity.func_92058_a(newItemStack);
                }
                ++i;
            }
        } else {
            HashMap<ItemStack, EntityItem> entityItemsByOutput = new HashMap<ItemStack, EntityItem>();
            for (ItemStack itemStack : this.itemOutputs) {
                List<EntityItem> randomReferenceEntityList = entityItemsByInput.get(this.itemInputs.get(this.rand.nextInt(this.itemInputs.size())));
                EntityItem randomReferenceEntity = randomReferenceEntityList.get(this.rand.nextInt(randomReferenceEntityList.size()));
                EntityItem outputEntity = new EntityItem(world, randomReferenceEntity.field_70165_t, randomReferenceEntity.field_70163_u, randomReferenceEntity.field_70161_v, itemStack.func_77946_l());
                outputEntity.func_92059_d().field_77994_a = 0;
                entityItemsByOutput.put(itemStack, outputEntity);
            }
            do {
                if (this.fluidInput != null && displacedFluid != null) {
                    displacedFluid.amount -= this.fluidInput.amount;
                    if (displacedFluid.amount <= 0) {
                        PistonCraftingHandler.displacedLiquids.remove((Object)fluidPos);
                        displacedFluid = null;
                    }
                }
                if (this.fluidOutput != null && fluidHandler != null) {
                    fluidHandler.fill(ForgeDirection.UP, this.fluidOutput, true);
                }
                block4: for (Map.Entry entry : entityItemsByInput.entrySet()) {
                    int numRequired = ((InputItemStack)entry.getKey()).stackSize();
                    int numConsumed = 0;
                    for (EntityItem inputEntity : (List)entry.getValue()) {
                        ItemStack inputStack = inputEntity.func_92059_d();
                        int numToConsume = Math.min(inputStack.field_77994_a, numRequired - numConsumed);
                        inputStack.field_77994_a -= numToConsume;
                        if ((numConsumed += numToConsume) < numRequired) continue;
                        continue block4;
                    }
                }
                for (Map.Entry entry : entityItemsByOutput.entrySet()) {
                    ((EntityItem)entry.getValue()).func_92059_d().field_77994_a += ((ItemStack)entry.getKey()).field_77994_a;
                }
            } while (this.fluidInputMatches(displacedFluid) && this.itemInputMatches(entityItemsByInput) && this.canOutputFluid(fluidHandler));
            for (Map.Entry entry : entityItemsByOutput.entrySet()) {
                world.func_72838_d((Entity)entry.getValue());
            }
        }
        return true;
    }

    public boolean canOutputFluid(World world, int x, int y, int z) {
        if (this.fluidOutput == null) {
            return true;
        }
        return this.canOutputFluid(this.getOutputFluidHandler(world, x, y, z));
    }

    public boolean canOutputFluid(IFluidHandler fluidHandler) {
        if (this.fluidOutput == null) {
            return true;
        }
        if (fluidHandler == null) {
            return false;
        }
        return fluidHandler.fill(ForgeDirection.UP, this.fluidOutput, false) == this.fluidOutput.amount;
    }

    public IFluidHandler getOutputFluidHandler(World world, int x, int y, int z) {
        if (this.fluidOutput == null) {
            return null;
        }
        TileEntity tileUnderneath = world.func_147438_o(x, y - 1, z);
        if (!(tileUnderneath instanceof IFluidHandler)) {
            return null;
        }
        return (IFluidHandler)tileUnderneath;
    }

    public boolean itemInputMatches(World world, int x, int y, int z) {
        if (this.itemInputs.isEmpty()) {
            return true;
        }
        return this.itemInputMatches(WorldHelper.getItemEntitiesWithin(world, x, y, z));
    }

    public boolean itemInputMatches(List<EntityItem> entityItems) {
        if (this.itemInputs.isEmpty()) {
            return true;
        }
        return this.itemInputMatches(PistonCraftingRecipe.getEntityItemsByInput(this.itemInputs, entityItems));
    }

    public boolean itemInputMatches(Map<InputItemStack, List<EntityItem>> entityItemsByInput) {
        if (this.itemInputs.isEmpty()) {
            return true;
        }
        for (Map.Entry<InputItemStack, List<EntityItem>> entityItemsByInputEntry : entityItemsByInput.entrySet()) {
            if (PistonCraftingRecipe.getStackSizeOfEntityItems((Collection<EntityItem>)entityItemsByInputEntry.getValue()) >= entityItemsByInputEntry.getKey().stackSize()) continue;
            return false;
        }
        return true;
    }

    public static Map<InputItemStack, List<EntityItem>> getEntityItemsByInput(Collection<InputItemStack> targets, Collection<EntityItem> entityItems) {
        HashMap<InputItemStack, List<EntityItem>> entityItemsByItemStack = new HashMap<InputItemStack, List<EntityItem>>();
        for (InputItemStack target : targets) {
            entityItemsByItemStack.put(target, PistonCraftingRecipe.getMatchingEntityItems(target, entityItems));
        }
        return entityItemsByItemStack;
    }

    public static List<EntityItem> getMatchingEntityItems(InputItemStack target, Collection<EntityItem> entityItems) {
        ArrayList<EntityItem> matchingEntities = new ArrayList<EntityItem>();
        for (EntityItem entityItem : entityItems) {
            if (!target.matches(entityItem.func_92059_d())) continue;
            matchingEntities.add(entityItem);
        }
        if (!matchingEntities.isEmpty() && target.isOreDict() && target.stackSize() > 1) {
            List<EntityItem> entitiesOfOneTypeWithLargestStackSize = null;
            int largestStackSize = 0;
            for (EntityItem entityItem : matchingEntities) {
                if (entitiesOfOneTypeWithLargestStackSize != null && ((EntityItem)entitiesOfOneTypeWithLargestStackSize.get(0)).func_92059_d().func_77969_a(entityItem.func_92059_d())) continue;
                List<EntityItem> exactMatches = PistonCraftingRecipe.getMatchingEntityItems(new InputItemStack(entityItem.func_92059_d()), matchingEntities);
                int exactMatchesStackSize = PistonCraftingRecipe.getStackSizeOfEntityItems(exactMatches);
                if (exactMatchesStackSize >= target.stackSize()) {
                    return exactMatches;
                }
                if (exactMatchesStackSize <= largestStackSize) continue;
                entitiesOfOneTypeWithLargestStackSize = exactMatches;
                largestStackSize = exactMatchesStackSize;
            }
            matchingEntities = entitiesOfOneTypeWithLargestStackSize;
        }
        return matchingEntities;
    }

    public static int getStackSizeOfEntityItems(Collection<EntityItem> entityItems) {
        int stackSize = 0;
        for (EntityItem entityItem : entityItems) {
            stackSize += entityItem.func_92059_d().field_77994_a;
        }
        return stackSize;
    }

    public boolean fluidInputMatches(World world, int x, int y, int z) {
        return this.fluidInputMatches(PistonCraftingHandler.displacedLiquids.get((Object)new PistonCraftingHandler.WorldPosition(world, x, y, z)));
    }

    public boolean fluidInputMatches(FluidStack fluidStack) {
        if (fluidStack == null) {
            return this.fluidInput == null;
        }
        return fluidStack.isFluidEqual(this.fluidInput) && fluidStack.amount >= this.fluidInput.amount;
    }
}

