/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.content.recipes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class InputItemStack {
    public ItemStack wrappedItemStack = null;
    public List<ItemStack> oreDictItemStacks = null;
    protected int oreDictStackSize = 1;

    public InputItemStack(String oredict, int stackSize) {
        this(oredict);
        this.oreDictStackSize = stackSize;
    }

    public InputItemStack(ItemStack itemStack) {
        this((Object)itemStack);
    }

    public InputItemStack(Item item) {
        this((Object)item);
    }

    public InputItemStack(Block block) {
        this((Object)block);
    }

    public InputItemStack(Object object) {
        if (object instanceof String) {
            this.oreDictItemStacks = OreDictionary.getOres((String)((String)object));
        } else if (object instanceof ArrayList) {
            this.oreDictItemStacks = (List)object;
        } else if (object instanceof ItemStack) {
            this.wrappedItemStack = (ItemStack)object;
        } else if (object instanceof Block) {
            this.wrappedItemStack = new ItemStack((Block)object, 1, Short.MAX_VALUE);
        } else if (object instanceof Item) {
            this.wrappedItemStack = new ItemStack((Item)object, 1, Short.MAX_VALUE);
        } else {
            throw new RuntimeException("Unsupported InputItemStack input: " + object);
        }
    }

    protected InputItemStack(List<ItemStack> itemStacks) {
        this.oreDictItemStacks = itemStacks;
    }

    public boolean matches(ItemStack input) {
        return this.matches(input, false);
    }

    public boolean matches(ItemStack input, boolean strict) {
        if (this.wrappedItemStack != null) {
            return OreDictionary.itemMatches((ItemStack)this.wrappedItemStack, (ItemStack)input, (boolean)strict);
        }
        if (this.oreDictItemStacks != null) {
            for (ItemStack oreDictItemStack : this.oreDictItemStacks) {
                if (!OreDictionary.itemMatches((ItemStack)oreDictItemStack, (ItemStack)input, (boolean)strict)) continue;
                return true;
            }
        }
        return false;
    }

    public int stackSize() {
        return this.wrappedItemStack != null ? this.wrappedItemStack.field_77994_a : (this.oreDictItemStacks != null ? this.oreDictStackSize : 0);
    }

    public boolean isOreDict() {
        return this.oreDictItemStacks != null;
    }
}

