/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.content.modifiers;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;
import squeek.veganoption.helpers.RandomHelper;

public class DropsModifier {
    private static final HashMap<BlockSpecifier, DropSpecifier> blockDrops = new HashMap();

    public DropsModifier() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void addDropsToBlock(Block block, Item drop) {
        this.addDropsToBlock(block, new ItemStack(drop));
    }

    public void addDropsToBlock(Block block, ItemStack drop) {
        this.addDropsToBlock(new BlockSpecifier(block), new DropSpecifier(drop));
    }

    public void addDropsToBlock(BlockSpecifier blockSpecifier, DropSpecifier dropSpecifier) {
        blockDrops.put(blockSpecifier, dropSpecifier);
    }

    public boolean dropExists(ItemStack itemStack) {
        for (Map.Entry<BlockSpecifier, DropSpecifier> blockDropSpecifier : blockDrops.entrySet()) {
            if (!OreDictionary.itemMatches((ItemStack)blockDropSpecifier.getValue().itemStack, (ItemStack)itemStack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDrops(ItemStack itemStack) {
        for (Map.Entry<BlockSpecifier, DropSpecifier> blockDropSpecifier : blockDrops.entrySet()) {
            BlockSpecifier block = blockDropSpecifier.getKey();
            if (!OreDictionary.itemMatches((ItemStack)new ItemStack(block.block, 1, block.meta), (ItemStack)itemStack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public List<DropInfo> getSubsetByDroppedItem(ItemStack itemStack) {
        ArrayList<DropInfo> subset = new ArrayList<DropInfo>();
        for (Map.Entry<BlockSpecifier, DropSpecifier> blockDropSpecifier : blockDrops.entrySet()) {
            if (!OreDictionary.itemMatches((ItemStack)blockDropSpecifier.getValue().itemStack, (ItemStack)itemStack, (boolean)false)) continue;
            subset.add(new DropInfo(blockDropSpecifier.getKey(), blockDropSpecifier.getValue()));
        }
        return subset;
    }

    public List<DropInfo> getSubsetByBlock(ItemStack itemStack) {
        ArrayList<DropInfo> subset = new ArrayList<DropInfo>();
        for (Map.Entry<BlockSpecifier, DropSpecifier> blockDropSpecifier : blockDrops.entrySet()) {
            BlockSpecifier block = blockDropSpecifier.getKey();
            if (!OreDictionary.itemMatches((ItemStack)new ItemStack(block.block, 1, block.meta), (ItemStack)itemStack, (boolean)false)) continue;
            subset.add(new DropInfo(blockDropSpecifier.getKey(), blockDropSpecifier.getValue()));
        }
        return subset;
    }

    public List<DropInfo> getAllDrops() {
        ArrayList<DropInfo> subset = new ArrayList<DropInfo>();
        for (Map.Entry<BlockSpecifier, DropSpecifier> blockDropSpecifier : blockDrops.entrySet()) {
            subset.add(new DropInfo(blockDropSpecifier.getKey(), blockDropSpecifier.getValue()));
        }
        return subset;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onGetHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        for (Map.Entry<BlockSpecifier, DropSpecifier> blockDropSpecifier : blockDrops.entrySet()) {
            if (!blockDropSpecifier.getKey().matches((IBlockAccess)event.world, event.x, event.y, event.z, event.block, event.blockMetadata)) continue;
            blockDropSpecifier.getValue().modifyDrops(event.drops, event.harvester, event.fortuneLevel, event.isSilkTouching);
        }
    }

    public static class DropInfo {
        public DropSpecifier drop;
        public BlockSpecifier dropper;

        public DropInfo(BlockSpecifier dropper, DropSpecifier drop) {
            this.dropper = dropper;
            this.drop = drop;
        }
    }

    public static class NEIDropSpecifier
    extends DropSpecifier {
        public NEIDropSpecifier(ItemStack itemStack, float dropChance, int dropsMin, int dropsMax) {
            super(itemStack, dropChance, dropsMin, dropsMax);
        }

        @Override
        public void modifyDrops(List<ItemStack> drops, EntityPlayer harvester, int fortuneLevel, boolean isSilkTouching) {
        }
    }

    public static class NEIBlockSpecifier
    extends BlockSpecifier {
        public NEIBlockSpecifier(Block block, int meta, ItemStack neiItemStack) {
            super(block, meta, neiItemStack);
        }

        @Override
        public boolean matches(IBlockAccess world, int x, int y, int z, Block block, int meta) {
            return false;
        }
    }

    public static class DropSpecifier {
        public final ItemStack itemStack;
        public final float dropChance;
        public final int dropsMin;
        public final int dropsMax;

        public DropSpecifier(ItemStack itemStack) {
            this(itemStack, 1.0f);
        }

        public DropSpecifier(ItemStack itemStack, float dropChance) {
            this(itemStack, dropChance, 1, 1);
        }

        public DropSpecifier(ItemStack itemStack, int dropsMin, int dropsMax) {
            this(itemStack, 1.0f, dropsMin, dropsMax);
        }

        public DropSpecifier(ItemStack itemStack, float dropChance, int dropsMin, int dropsMax) {
            this.itemStack = itemStack;
            this.dropsMin = dropsMin;
            this.dropsMax = dropsMax;
            this.dropChance = dropChance;
        }

        public boolean shouldDrop(EntityPlayer harvester, int fortuneLevel, boolean isSilkTouching) {
            return RandomHelper.random.nextFloat() < this.dropChance && !isSilkTouching;
        }

        public int amountToDrop(EntityPlayer harvester, int fortuneLevel, boolean isSilkTouching) {
            return RandomHelper.getRandomIntFromRange(this.dropsMin, this.dropsMax);
        }

        public List<ItemStack> getDrops(EntityPlayer harvester, int fortuneLevel, boolean isSilkTouching) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (this.shouldDrop(harvester, fortuneLevel, isSilkTouching)) {
                int amountToDrop = this.amountToDrop(harvester, fortuneLevel, isSilkTouching);
                for (int i = 0; i < amountToDrop; ++i) {
                    drops.add(this.itemStack.func_77946_l());
                }
            }
            return drops;
        }

        public void modifyDrops(List<ItemStack> drops, EntityPlayer harvester, int fortuneLevel, boolean isSilkTouching) {
            drops.addAll(this.getDrops(harvester, fortuneLevel, isSilkTouching));
        }
    }

    public static class BlockSpecifier {
        public final Block block;
        public final int meta;
        public final ItemStack neiItemStack;

        public BlockSpecifier(Block block) {
            this(block, null);
        }

        public BlockSpecifier(Block block, ItemStack neiItemStack) {
            this(block, 0, neiItemStack);
        }

        public BlockSpecifier(Block block, int meta) {
            this(block, meta, null);
        }

        public BlockSpecifier(Block block, int meta, ItemStack neiItemStack) {
            this.block = block;
            this.meta = meta;
            this.neiItemStack = neiItemStack;
        }

        public boolean matches(Block block) {
            return this.matches(block, 0);
        }

        public boolean matches(Block block, int meta) {
            return this.blockMatches(block) && this.metaMatches(block, meta);
        }

        public boolean matches(IBlockAccess world, int x, int y, int z, Block block, int meta) {
            return this.matches(block, meta);
        }

        public boolean blockMatches(Block block) {
            return this.block == block;
        }

        public boolean metaMatches(int meta) {
            return this.meta == meta || this.meta == Short.MAX_VALUE;
        }

        public boolean metaMatches(Block block, int meta) {
            return this.metaMatches(meta);
        }
    }
}

