/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.content.crafting;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import squeek.veganoption.api.event.PistonEvent;
import squeek.veganoption.content.recipes.PistonCraftingRecipe;
import squeek.veganoption.content.registry.PistonCraftingRegistry;
import squeek.veganoption.helpers.FluidHelper;

public class PistonCraftingHandler {
    public static HashMap<WorldPosition, FluidStack> displacedLiquids = new HashMap();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new PistonCraftingHandler());
    }

    @SubscribeEvent
    public void onCrushItem(PistonEvent.CrushItem event) {
        for (PistonCraftingRecipe pistonRecipe : PistonCraftingRegistry.getRecipes()) {
            if (!pistonRecipe.tryCraft(event.world, event.headX, event.headY, event.headZ)) continue;
            return;
        }
    }

    @SubscribeEvent
    public void onPistonExtend(PistonEvent.TryExtend event) {
        if (event.world.field_72995_K) {
            return;
        }
        WorldPosition pos = new WorldPosition(event.world, event.headX, event.headY, event.headZ);
        displacedLiquids.remove((Object)pos);
        Block displacedBlock = event.world.func_147439_a(event.headX, event.headY, event.headZ);
        if (displacedBlock == null || displacedBlock.isAir((IBlockAccess)event.world, event.headX, event.headY, event.headZ)) {
            return;
        }
        Fluid displacedFluid = FluidHelper.getFluidTypeOfBlock(displacedBlock);
        int meta = event.world.func_72805_g(event.headX, event.headY, event.headZ);
        if (displacedFluid != null && meta == FluidHelper.getStillMetadata(displacedFluid)) {
            displacedLiquids.put(pos, new FluidStack(displacedFluid, 1000));
        }
    }

    @SubscribeEvent
    public void onPistonRetract(PistonEvent.Retract event) {
        if (event.world.field_72995_K) {
            return;
        }
        displacedLiquids.remove((Object)new WorldPosition(event.world, event.headX, event.headY, event.headZ));
    }

    public static class WorldPosition
    extends ChunkPosition {
        public final World world;

        public WorldPosition(World world, int x, int y, int z) {
            super(x, y, z);
            this.world = world;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.world == null ? 0 : this.world.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof WorldPosition)) {
                return false;
            }
            WorldPosition other = (WorldPosition)((Object)obj);
            return !(this.world == null ? other.world != null : !this.world.equals(other.world));
        }
    }
}

