/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.content;

import java.util.HashMap;
import java.util.Map;
import squeek.veganoption.content.IContentModule;
import squeek.veganoption.content.modules.Basin;
import squeek.veganoption.content.modules.Bioplastic;
import squeek.veganoption.content.modules.Burlap;
import squeek.veganoption.content.modules.Composting;
import squeek.veganoption.content.modules.DollsEye;
import squeek.veganoption.content.modules.Egg;
import squeek.veganoption.content.modules.Ender;
import squeek.veganoption.content.modules.Feather;
import squeek.veganoption.content.modules.Fossils;
import squeek.veganoption.content.modules.FrozenBubble;
import squeek.veganoption.content.modules.Gunpowder;
import squeek.veganoption.content.modules.Ink;
import squeek.veganoption.content.modules.Jute;
import squeek.veganoption.content.modules.Kapok;
import squeek.veganoption.content.modules.MobHeads;
import squeek.veganoption.content.modules.PlantMilk;
import squeek.veganoption.content.modules.ProofOfSuffering;
import squeek.veganoption.content.modules.Resin;
import squeek.veganoption.content.modules.Seitan;
import squeek.veganoption.content.modules.Soap;
import squeek.veganoption.content.modules.StrawBed;
import squeek.veganoption.content.modules.ToxicMushroom;
import squeek.veganoption.content.modules.VegetableOil;
import squeek.veganoption.content.modules.compat.CompatEnderBubble;

public class ContentModuleHandler {
    private static Map<String, IContentModule> modules = new HashMap<String, IContentModule>();
    private static Map<String, IContentModule> compatModules = new HashMap<String, IContentModule>();

    public static void preInit() {
        for (IContentModule module : modules.values()) {
            module.create();
            module.oredict();
        }
        for (IContentModule compatModule : compatModules.values()) {
            compatModule.create();
            compatModule.oredict();
        }
    }

    public static void init() {
        for (IContentModule module : modules.values()) {
            module.recipes();
        }
        for (IContentModule compatModule : compatModules.values()) {
            compatModule.recipes();
        }
    }

    public static void postInit() {
        for (IContentModule module : modules.values()) {
            module.finish();
        }
        for (IContentModule compatModule : compatModules.values()) {
            compatModule.finish();
        }
    }

    static {
        modules.put("Bioplastic", new Bioplastic());
        modules.put("Burlap", new Burlap());
        modules.put("Composting", new Composting());
        modules.put("EggReplacers", new Egg());
        modules.put("Ender", new Ender());
        modules.put("Feather", new Feather());
        modules.put("Fossils", new Fossils());
        modules.put("FrozenBubble", new FrozenBubble());
        modules.put("Gunpowder", new Gunpowder());
        modules.put("Ink", new Ink());
        modules.put("Jute", new Jute());
        modules.put("Kapok", new Kapok());
        modules.put("MobHeads", new MobHeads());
        modules.put("PlantMilk", new PlantMilk());
        modules.put("Resin", new Resin());
        modules.put("Soap", new Soap());
        modules.put("StrawBed", new StrawBed());
        modules.put("ToxicMushroom", new ToxicMushroom());
        modules.put("VegetableOil", new VegetableOil());
        modules.put("ProofOfSuffering", new ProofOfSuffering());
        modules.put("DollsEye", new DollsEye());
        modules.put("Basin", new Basin());
        modules.put("Seitan", new Seitan());
        compatModules.put("EnderBubble", new CompatEnderBubble());
    }
}

