/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.blocks.tiles;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import squeek.veganoption.blocks.BlockBasin;
import squeek.veganoption.content.modules.Basin;
import squeek.veganoption.helpers.BlockHelper;
import squeek.veganoption.helpers.FluidContainerHelper;
import squeek.veganoption.helpers.FluidHelper;
import squeek.veganoption.helpers.WorldHelper;

public class TileEntityBasin
extends TileEntity
implements IFluidHandler {
    protected FluidTank fluid = new FluidTank(1000);
    protected boolean isPowered = false;
    protected boolean fluidConsumeStopped = true;
    protected int ticksUntilNextFluidConsume = FLUID_CONSUME_TICK_PERIOD;
    protected int ticksUntilNextContainerFill = CONTAINER_FILL_TICK_PERIOD;
    protected boolean needsInit = true;
    public static int FLUID_CONSUME_TICK_PERIOD = 20;
    public static int CONTAINER_FILL_TICK_PERIOD = 20;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.needsInit) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.needsInit = false;
        }
        if (this.shouldConsumeFluid()) {
            boolean didConsume = this.tryConsumeFluidAbove();
            if (didConsume) {
                this.scheduleFluidConsume();
            } else {
                this.endFluidConsume();
            }
        } else {
            this.ticksUntilNextFluidConsume = Math.max(0, this.ticksUntilNextFluidConsume - 1);
        }
        if (this.shouldFillContainers()) {
            this.tryFillContainersInside();
            this.scheduleFillContainers();
        } else {
            this.ticksUntilNextContainerFill = Math.max(0, this.ticksUntilNextContainerFill - 1);
        }
    }

    public boolean couldFillContainers() {
        return this.isOpen() && this.fluid.getFluidAmount() > 0;
    }

    public boolean shouldFillContainers() {
        return this.couldFillContainers() && this.ticksUntilNextContainerFill <= 0;
    }

    public boolean tryFillContainersInside() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || !this.couldFillContainers()) {
            return false;
        }
        List<EntityItem> entityItemsWithin = WorldHelper.getItemEntitiesWithin(this.field_145850_b, ((BlockBasin)Basin.basin).getInnerBoundingBox(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        for (EntityItem entityItemWithin : entityItemsWithin) {
            if (!FluidContainerRegistry.isEmptyContainer((ItemStack)entityItemWithin.func_92059_d())) continue;
            EntityItem entityItemToFill = entityItemWithin;
            ItemStack containerToFill = entityItemWithin.func_92059_d();
            ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)this.fluid.getFluid(), (ItemStack)containerToFill);
            if (filledContainer == null) continue;
            if (containerToFill.field_77994_a > 1) {
                containerToFill.func_77979_a(1);
                entityItemToFill = new EntityItem(entityItemToFill.field_70170_p, entityItemToFill.field_70165_t, entityItemToFill.field_70163_u, entityItemToFill.field_70161_v, filledContainer);
                entityItemToFill.field_145804_b = 10;
                entityItemToFill.field_70170_p.func_72838_d((Entity)entityItemToFill);
            }
            entityItemToFill.func_92058_a(filledContainer);
            FluidStack filledWith = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer);
            this.drain(ForgeDirection.UNKNOWN, filledWith.amount, true);
            return true;
        }
        return false;
    }

    public void scheduleFillContainers(int ticksUntilContainerFill) {
        this.ticksUntilNextContainerFill = this.ticksUntilNextContainerFill == 0 ? ticksUntilContainerFill : Math.min(this.ticksUntilNextContainerFill, ticksUntilContainerFill);
    }

    public void scheduleFillContainers() {
        this.scheduleFillContainers(CONTAINER_FILL_TICK_PERIOD);
    }

    public boolean couldConsumeFluid() {
        return this.isOpen() && this.fluid.getFluidAmount() != this.fluid.getCapacity();
    }

    public boolean shouldConsumeFluid() {
        return this.couldConsumeFluid() && !this.fluidConsumeStopped && this.ticksUntilNextFluidConsume <= 0;
    }

    public boolean tryConsumeFluidAbove() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || !this.couldConsumeFluid()) {
            return false;
        }
        BlockHelper.BlockPos blockPosAbove = new BlockHelper.BlockPos(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        Block blockAbove = blockPosAbove.getBlock();
        Fluid fluidAbove = FluidHelper.getFluidTypeOfBlock(blockAbove);
        if (fluidAbove == null || !this.canFill(ForgeDirection.UP, fluidAbove)) {
            return false;
        }
        FluidStack fluidToAdd = FluidHelper.consumeFluid(blockPosAbove, fluidAbove, this.fluid.getCapacity() - this.fluid.getFluidAmount());
        if (fluidToAdd == null) {
            return false;
        }
        this.fill(ForgeDirection.UP, fluidToAdd, true);
        return true;
    }

    public void scheduleFluidConsume(int ticksUntilFluidConsume) {
        if (ticksUntilFluidConsume == 0) {
            this.tryConsumeFluidAbove();
        } else {
            this.ticksUntilNextFluidConsume = this.ticksUntilNextFluidConsume == 0 ? ticksUntilFluidConsume : Math.min(this.ticksUntilNextFluidConsume, ticksUntilFluidConsume);
        }
        this.fluidConsumeStopped = false;
    }

    public void scheduleFluidConsume() {
        this.scheduleFluidConsume(FLUID_CONSUME_TICK_PERIOD);
    }

    public void endFluidConsume() {
        this.fluidConsumeStopped = true;
    }

    public boolean isOpen() {
        return this.isPowered();
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public void onOpen() {
        this.scheduleFluidConsume();
    }

    public void onClose() {
        this.endFluidConsume();
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem != null && FluidContainerRegistry.isContainer((ItemStack)heldItem)) {
            FluidStack containerFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)heldItem);
            if (containerFluid != null && this.fill(ForgeDirection.UNKNOWN, containerFluid, false) == containerFluid.amount) {
                ItemStack emptyContainer = FluidContainerHelper.tryEmptyContainer(player, heldItem);
                if (emptyContainer == null) {
                    return false;
                }
                this.fill(ForgeDirection.UNKNOWN, containerFluid, true);
            } else if (this.fluid.getFluidAmount() > 0) {
                ItemStack filledContainer = FluidContainerHelper.tryFillContainer(player, heldItem, this.fluid.getFluid());
                if (filledContainer == null) {
                    return false;
                }
                this.drain(ForgeDirection.UNKNOWN, FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer).amount, true);
            }
            return true;
        }
        return false;
    }

    public void setPowered(boolean isPowered) {
        if (isPowered != this.isPowered()) {
            this.isPowered = isPowered;
            if (isPowered) {
                this.onPowered();
            } else {
                this.onUnpowered();
            }
            if (this.field_145850_b != null) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void onPowered() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Basin.basin);
        }
        this.onOpen();
    }

    public void onUnpowered() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Basin.basin);
        }
        this.onClose();
    }

    public void onFluidLevelChanged(IFluidTank tank, FluidStack fluidDelta) {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Basin.basin);
            this.scheduleFluidConsume();
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || !this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int amountFilled = this.fluid.fill(resource, doFill);
        if (doFill && amountFilled > 0) {
            this.onFluidLevelChanged((IFluidTank)this.fluid, new FluidStack(resource.getFluid(), amountFilled));
        }
        return amountFilled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drainedStack = this.fluid.drain(maxDrain, doDrain);
        if (doDrain && drainedStack != null && drainedStack.amount > 0) {
            this.onFluidLevelChanged((IFluidTank)this.fluid, drainedStack.copy());
        }
        return drainedStack;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fluid.getFluid() == null || this.fluid.getFluid().getFluid() == fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.fluid.getFluid() != null && this.fluid.getFluid().getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.fluid.getInfo()};
    }

    public void readSyncedNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("Fluid")) {
            this.fluid.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("Fluid")));
        } else {
            this.fluid.setFluid(null);
        }
        this.setPowered(compound.func_74767_n("Powered"));
    }

    public void writeSyncedNBT(NBTTagCompound compound) {
        if (this.fluid.getFluid() != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            this.fluid.getFluid().writeToNBT(fluidTag);
            compound.func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        if (this.isPowered()) {
            compound.func_74757_a("Powered", this.isPowered());
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readSyncedNBT(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeSyncedNBT(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readSyncedNBT(compound);
        if (compound.func_74764_b("NextConsume")) {
            this.scheduleFluidConsume(compound.func_74762_e("NextConsume"));
        } else {
            this.endFluidConsume();
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeSyncedNBT(compound);
        if (!this.fluidConsumeStopped) {
            compound.func_74768_a("NextConsume", this.ticksUntilNextFluidConsume);
        }
    }
}

