/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.blocks.renderers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import org.lwjgl.opengl.GL11;
import squeek.veganoption.blocks.tiles.TileEntityBasin;
import squeek.veganoption.content.modules.Basin;

@SideOnly(value=Side.CLIENT)
public class RenderBasin
extends TileEntitySpecialRenderer
implements IItemRenderer {
    public static final TileEntityBasin dummyBasin = new TileEntityBasin();
    public static final double SIDE_WIDTH = 0.125;

    public void renderTileEntityAt(TileEntityBasin basin, double x, double y, double z, float partialTickTime) {
        RenderBlocks renderer = new RenderBlocks((IBlockAccess)basin.func_145831_w());
        Block block = Basin.basin;
        int meta = basin == dummyBasin ? 0 : basin.field_145847_g;
        this.func_147499_a(TextureMap.field_110575_b);
        renderer.func_147775_a(block);
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslated((double)x, (double)y, (double)z);
        if (basin == dummyBasin) {
            GL11.glEnable((int)2896);
            this.renderStandardInventoryBlock(block, meta, renderer);
            GL11.glDisable((int)2896);
        }
        GL11.glDisable((int)2896);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        int brightness = 0;
        int innerBrightness = 0;
        if (basin != dummyBasin) {
            int xInt = basin.field_145851_c;
            int yInt = basin.field_145848_d;
            int zInt = basin.field_145849_e;
            int colorMultiplier = block.func_149720_d((IBlockAccess)basin.func_145831_w(), xInt, yInt, zInt);
            float red = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
            float green = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
            float blue = (float)(colorMultiplier & 0xFF) / 255.0f;
            if (EntityRenderer.field_78517_a) {
                float newRed = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
                float newGreen = (red * 30.0f + green * 70.0f) / 100.0f;
                float newBlue = (red * 30.0f + blue * 70.0f) / 100.0f;
                red = newRed;
                green = newGreen;
                blue = newBlue;
            }
            brightness = block.func_149677_c((IBlockAccess)basin.func_145831_w(), xInt, yInt, zInt);
            innerBrightness = (int)(basin.isClosed() ? (float)brightness * 0.35f : (float)brightness * 0.5f);
            tessellator.func_78380_c(innerBrightness);
            tessellator.func_78386_a(red, green, blue);
        }
        IIcon sideIcon = block.func_149733_h(2);
        float offset = 0.125f;
        renderer.func_147764_f(block, (double)(-1.0f + offset), 0.0, 0.0, sideIcon);
        renderer.func_147798_e(block, (double)(1.0f - offset), 0.0, 0.0, sideIcon);
        renderer.func_147734_d(block, 0.0, 0.0, (double)(-1.0f + offset), sideIcon);
        renderer.func_147761_c(block, 0.0, 0.0, (double)(1.0f - offset), sideIcon);
        IIcon innerIconBottom = block.func_149733_h(ForgeDirection.DOWN.ordinal());
        renderer.func_147806_b(block, 0.0, (double)(-1.0f + offset), 0.0, innerIconBottom);
        if (basin.isClosed()) {
            IIcon innerIconTop = block.func_149733_h(ForgeDirection.UP.ordinal());
            renderer.func_147768_a(block, 0.0, (double)(1.0f - offset), 0.0, innerIconTop);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        FluidTankInfo tankInfo = basin.getTankInfo(ForgeDirection.UNKNOWN)[0];
        if (tankInfo.fluid != null && tankInfo.fluid.amount > 0) {
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            int color = tankInfo.fluid.getFluid().getColor(tankInfo.fluid);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            tessellator.func_78386_a(red, green, blue);
            if (basin != dummyBasin) {
                tessellator.func_78380_c(brightness);
            }
            IIcon fluidIcon = tankInfo.fluid.getFluid().getIcon();
            float percentFull = (float)tankInfo.fluid.amount / (float)tankInfo.capacity;
            float fluidTopOffset = offset + percentFull * (1.0f - offset - offset);
            renderer.func_147782_a((double)offset, (double)offset, (double)offset, (double)(1.0f - offset), (double)fluidTopOffset, (double)(1.0f - offset));
            renderer.func_147806_b(block, 0.0, 0.0, 0.0, fluidIcon);
            renderer.func_147798_e(block, 0.0, 0.0, 0.0, fluidIcon);
            renderer.func_147764_f(block, 0.0, 0.0, 0.0, fluidIcon);
            renderer.func_147761_c(block, 0.0, 0.0, 0.0, fluidIcon);
            renderer.func_147734_d(block, 0.0, 0.0, 0.0, fluidIcon);
            GL11.glDisable((int)2896);
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glEnable((int)2896);
    }

    public void func_147500_a(TileEntity p_147500_1_, double p_147500_2_, double p_147500_4_, double p_147500_6_, float p_147500_8_) {
        this.renderTileEntityAt((TileEntityBasin)p_147500_1_, p_147500_2_, p_147500_4_, p_147500_6_, p_147500_8_);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.renderTileEntityAt(dummyBasin, -0.5, -0.5, -0.5, 0.0f);
                return;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                this.renderTileEntityAt(dummyBasin, 0.0, 0.0, 0.0, 0.0f);
                return;
            }
            case INVENTORY: {
                this.renderTileEntityAt(dummyBasin, 0.5, 0.3f, 0.5, 0.0f);
                return;
            }
        }
    }

    public void renderStandardInventoryBlock(Block block, int metadata, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, metadata));
        tessellator.func_78381_a();
    }
}

