/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import squeek.veganoption.content.modules.Jute;

public class BlockJutePlant
extends BlockBush
implements IGrowable {
    IIcon[] blockIcons = new IIcon[7];
    public static final int NUM_BOTTOM_STAGES = 6;
    public static final int NUM_TOP_STAGES = 5;
    public static final int NUM_GROWTH_STAGES = 11;
    public static final int BOTTOM_META_FULL = 6;
    public static final int BOTTOM_META_GROWTH_MAX = 5;
    public static final int TOP_META_START = 7;
    public static final int META_MAX = 12;
    public static final int NUM_ICONS = 7;
    public static float GROWTH_CHANCE_PER_UPDATETICK = 0.1f;

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int normalizedMeta;
        int meta = world.func_72805_g(x, y, z);
        int n = normalizedMeta = BlockJutePlant.isTop(meta) ? meta - 7 : meta;
        if (normalizedMeta >= 4) {
            ++normalizedMeta;
        }
        float growthPercent = BlockJutePlant.isTop(meta) ? (float)normalizedMeta / 5.0f : (float)normalizedMeta / 6.0f;
        growthPercent = Math.min(1.0f, growthPercent);
        this.func_149676_a(0.15f, 0.0f, 0.15f, 0.85f, 0.25f + growthPercent * 0.75f, 0.85f);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return !BlockJutePlant.isTop(meta) ? 1 : 0;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Jute.juteSeeds;
    }

    public void deltaGrowth(World world, int x, int y, int z, int delta) {
        if (world.func_147439_a(x, y, z) != this) {
            return;
        }
        int oldMeta = world.func_72805_g(x, y, z);
        if (oldMeta == 6 && world.func_147439_a(x, y + 1, z) == this) {
            this.deltaGrowth(world, x, y + 1, z, delta);
            return;
        }
        int newMeta = oldMeta + delta;
        if (BlockJutePlant.isFullyGrown(newMeta)) {
            Blocks.field_150398_cm.func_149889_c(world, x, y - 1, z, 3, 3);
        } else if (newMeta <= 5 || newMeta >= 7 && oldMeta >= 7) {
            world.func_72921_c(x, y, z, newMeta, 3);
        } else if (oldMeta <= 5 && world.func_147439_a(x, y + 1, z).isAir((IBlockAccess)world, x, y + 1, z)) {
            int metaTransferred = newMeta - 6;
            world.func_72921_c(x, y, z, 6, 3);
            world.func_147465_d(x, y + 1, z, (Block)this, 7 + metaTransferred, 3);
        } else if (oldMeta <= 5) {
            newMeta = Math.min(newMeta, 5);
            world.func_72921_c(x, y, z, newMeta, 3);
        }
    }

    public float getGrowthPercent(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 6 && world.func_147439_a(x, y + 1, z) == this) {
            return this.getGrowthPercent(world, x, y + 1, z);
        }
        int growthMeta = BlockJutePlant.isTop(meta) ? meta - 1 : meta;
        return (float)growthMeta / 11.0f;
    }

    public static boolean isFullyGrown(int meta) {
        return meta >= 12;
    }

    public static boolean isTop(int meta) {
        return meta >= 7;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        boolean shouldGrow;
        super.func_149674_a(world, x, y, z, random);
        boolean bl = shouldGrow = random.nextFloat() < GROWTH_CHANCE_PER_UPDATETICK;
        if (shouldGrow && world.func_72805_g(x, y, z) != 6) {
            this.deltaGrowth(world, x, y, z, 1);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this) {
            return super.func_149718_j(world, x, y, z);
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta == 6) {
            return world.func_147439_a(x, y + 1, z) == this;
        }
        if (BlockJutePlant.isTop(meta)) {
            return world.func_147439_a(x, y - 1, z) == this;
        }
        return super.func_149718_j(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return world.func_72807_a(x, z).func_150558_b(x, y, z);
    }

    public IIcon func_149691_a(int side, int meta) {
        int iconIndex;
        int n = iconIndex = BlockJutePlant.isTop(meta) ? meta - 7 : meta;
        if (iconIndex < this.blockIcons.length) {
            return this.blockIcons[iconIndex];
        }
        return super.func_149691_a(side, meta);
    }

    public void func_149651_a(IIconRegister register) {
        for (int i = 0; i < 7; ++i) {
            this.blockIcons[i] = register.func_94245_a(this.func_149641_N() + "_" + i);
        }
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isRemote) {
        return true;
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        int deltaGrowth = MathHelper.func_76136_a((Random)random, (int)2, (int)5);
        this.deltaGrowth(world, x, y, z, deltaGrowth);
    }
}

