/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.blocks;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLogic;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import squeek.veganoption.blocks.BlockEncrustedObsidian;
import squeek.veganoption.blocks.IFluidFlowHandler;
import squeek.veganoption.blocks.tiles.TileEntityEnderRift;
import squeek.veganoption.content.modules.Ender;
import squeek.veganoption.helpers.BlockHelper;
import squeek.veganoption.helpers.RandomHelper;
import squeek.veganoption.network.MessageFX;
import squeek.veganoption.network.NetworkHandler;

public class BlockEnderRift
extends BlockEndPortal
implements IFluidFlowHandler {
    public static final int BLOCK_TELEPORT_RADIUS = 4;
    public static final int NAUSEA_LENGTH_IN_SECONDS = 5;
    public static MaterialEnderRift materialEnderRift = new MaterialEnderRift();

    public BlockEnderRift() {
        super((Material)materialEnderRift);
        this.func_149675_a(true);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityEnderRift();
    }

    public void func_149719_a(IBlockAccess p_149719_1_, int p_149719_2_, int p_149719_3_, int p_149719_4_) {
        this.func_149676_a(0.0f, 0.25f, 0.0f, 1.0f, 0.75f, 1.0f);
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal();
    }

    @Override
    public boolean onFluidFlowInto(World world, int x, int y, int z, int flowDecay) {
        return true;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        BlockHelper.BlockPos sourceBlockToConsume;
        super.func_149674_a(world, x, y, z, random);
        BlockHelper.BlockPos riftBlockPos = BlockHelper.blockPos(world, x, y, z);
        BlockHelper.BlockPos aboveBlockPos = riftBlockPos.getOffset(0, 1, 0);
        if (BlockHelper.isWater(aboveBlockPos) && world.func_147439_a(x, y - 1, z).isReplaceable((IBlockAccess)world, x, y - 1, z) && (sourceBlockToConsume = BlockHelper.followWaterStreamToSourceBlock(aboveBlockPos)) != null) {
            world.func_147468_f(sourceBlockToConsume.x, sourceBlockToConsume.y, sourceBlockToConsume.z);
            if (!world.func_72935_r()) {
                world.func_147465_d(x, y - 1, z, Ender.rawEnder, 7, 3);
            } else {
                BlockHelper.BlockPos[] blocksInRadius = BlockHelper.getBlocksInRadiusAround(new BlockHelper.BlockPos(world, x, y, z), 4);
                if ((blocksInRadius = BlockHelper.filterBlockListToBreakableBlocks(blocksInRadius)).length > 0) {
                    BlockHelper.BlockPos blockPosToSwallow = blocksInRadius[RandomHelper.random.nextInt(blocksInRadius.length)];
                    blockPosToSwallow.world.func_147468_f(blockPosToSwallow.x, blockPosToSwallow.y, blockPosToSwallow.z);
                    blockPosToSwallow.world.func_72908_a((double)blockPosToSwallow.x, (double)blockPosToSwallow.y, (double)blockPosToSwallow.z, "mob.endermen.portal", 1.0f, 1.0f);
                    if (!world.field_72995_K) {
                        NetworkRegistry.TargetPoint target = new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)blockPosToSwallow.x, (double)blockPosToSwallow.y, (double)blockPosToSwallow.z, 80.0);
                        NetworkHandler.channel.sendToAllAround((IMessage)new MessageFX(blockPosToSwallow.x, blockPosToSwallow.y, blockPosToSwallow.z, MessageFX.FX.BLOCK_TELEPORT), target);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnBlockTeleportFX(World world, double x, double y, double z, Random rand) {
        for (int i = 0; i < 128; ++i) {
            double posX = x + rand.nextDouble();
            double posY = y + rand.nextDouble();
            double posZ = z + rand.nextDouble();
            double velX = rand.nextDouble() - 0.5;
            double velY = rand.nextDouble() - 0.5;
            double velZ = rand.nextDouble() - 0.5;
            world.func_72869_a("portal", posX, posY, posZ, velX, velY, velZ);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block changedBlock) {
        super.func_149695_a(world, x, y, z, changedBlock);
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return BlockEnderRift.isValidPortalLocation(world, x, y, z) && super.func_149718_j(world, x, y, z);
    }

    public static boolean isValidPortalLocation(World world, int x, int y, int z) {
        BlockHelper.BlockPos blockPos = BlockHelper.blockPos(world, x, y, z);
        for (BlockHelper.BlockPos blockToCheck : BlockHelper.getBlocksAdjacentTo(blockPos)) {
            if (blockToCheck.getBlock() instanceof BlockEncrustedObsidian) continue;
            return false;
        }
        return true;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100));
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
    }

    public static class MaterialEnderRift
    extends MaterialLogic {
        public MaterialEnderRift() {
            super(MapColor.field_151660_b);
            this.func_76225_o();
        }
    }
}

