/*
 * Decompiled with CFR 0.152.
 */
package squeek.veganoption.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import squeek.veganoption.blocks.IHollowBlock;
import squeek.veganoption.blocks.tiles.TileEntityBasin;

public class BlockBasin
extends BlockContainer
implements IHollowBlock {
    public static final double SIDE_WIDTH = 0.125;
    public IIcon blockIconTopOpen;
    public IIcon blockIconTopClosed;
    public IIcon blockIconBottom;
    public IIcon blockIconSide;
    public static IIcon blockIconInner;

    public BlockBasin(Material material) {
        super(material);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityBasin();
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        if (side != ForgeDirection.UP) {
            return true;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBasin) {
            return ((TileEntityBasin)tile).isClosed();
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block changedBlock) {
        super.func_149695_a(world, x, y, z, changedBlock);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBasin) {
            ((TileEntityBasin)tile).setPowered(world.func_72864_z(x, y, z));
            ((TileEntityBasin)tile).scheduleFluidConsume();
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBasin) {
            ((TileEntityBasin)tile).setPowered(world.func_72864_z(x, y, z));
            ((TileEntityBasin)tile).scheduleFluidConsume();
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ)) {
            return true;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        return tile instanceof TileEntityBasin && ((TileEntityBasin)tile).onBlockActivated(player, side, hitX, hitY, hitZ);
    }

    public AxisAlignedBB getSideBoundingBox(ForgeDirection side) {
        return this.getSideBoundingBox(side, 0.0, 0.0, 0.0);
    }

    public AxisAlignedBB getSideBoundingBox(ForgeDirection side, double offsetX, double offsetY, double offsetZ) {
        return this.getSideBoundingBox(side, offsetX, offsetY, offsetZ, 1.0f);
    }

    public AxisAlignedBB getSideBoundingBox(ForgeDirection side, double offsetX, double offsetY, double offsetZ, float depthScale) {
        return this.getSideBoundingBox(side, offsetX, offsetY, offsetZ, depthScale, 1.0f, 1.0f);
    }

    public AxisAlignedBB getSideBoundingBox(ForgeDirection side, double offsetX, double offsetY, double offsetZ, float depthScale, float widthScale, float heightScale) {
        double height;
        double width;
        double minX = this.field_149759_B;
        double minY = this.field_149760_C;
        double minZ = this.field_149754_D;
        double maxX = this.field_149755_E;
        double maxY = this.field_149756_F;
        double maxZ = this.field_149757_G;
        if (side.offsetX != 0) {
            if (side.offsetX > 0) {
                minX = maxX - 0.125 * (double)depthScale;
            } else {
                maxX = minX + 0.125 * (double)depthScale;
            }
            if (widthScale != 1.0f) {
                width = maxZ - minZ;
                if (widthScale > 0.0f) {
                    maxZ = minZ + width * (double)widthScale;
                } else {
                    minZ = maxZ + width * (double)widthScale;
                }
            }
            if (heightScale != 1.0f) {
                height = maxZ - minZ;
                if (heightScale > 0.0f) {
                    maxY = minY + height * (double)heightScale;
                } else {
                    minY = maxY + height * (double)heightScale;
                }
            }
        }
        if (side.offsetY != 0) {
            if (side.offsetY > 0) {
                minY = maxY - 0.125 * (double)depthScale;
            } else {
                maxY = minY + 0.125 * (double)depthScale;
            }
            if (widthScale != 1.0f) {
                width = maxZ - minZ;
                if (widthScale > 0.0f) {
                    maxZ = minZ + width * (double)widthScale;
                } else {
                    minZ = maxZ + width * (double)widthScale;
                }
            }
            if (heightScale != 1.0f) {
                height = maxX - minX;
                if (heightScale > 0.0f) {
                    maxX = minX + height * (double)heightScale;
                } else {
                    minX = maxX + height * (double)heightScale;
                }
            }
        }
        if (side.offsetZ != 0) {
            if (side.offsetZ > 0) {
                minZ = maxZ - 0.125 * (double)depthScale;
            } else {
                maxZ = minZ + 0.125 * (double)depthScale;
            }
            if (widthScale != 1.0f) {
                width = maxX - minX;
                if (widthScale > 0.0f) {
                    maxX = minX + width * (double)widthScale;
                } else {
                    minX = maxX + width * (double)widthScale;
                }
            }
            if (heightScale != 1.0f) {
                height = maxY - minY;
                if (heightScale > 0.0f) {
                    maxY = minY + height * (double)heightScale;
                } else {
                    minY = maxY + height * (double)heightScale;
                }
            }
        }
        return AxisAlignedBB.func_72330_a((double)(offsetX + minX), (double)(offsetY + minY), (double)(offsetZ + minZ), (double)(offsetX + maxX), (double)(offsetY + maxY), (double)(offsetZ + maxZ));
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB collidingAABB, List collidingBoundingBoxes, Entity collidingEntity) {
        if (collidingEntity == null) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityBasin && ((TileEntityBasin)tile).isPowered()) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (side == ForgeDirection.UP) continue;
                ArrayList<AxisAlignedBB> AABBs = new ArrayList<AxisAlignedBB>(4);
                AABBs.add(this.getSideBoundingBox(side, x, y, z));
                for (AxisAlignedBB AABB : AABBs) {
                    if (AABB == null || !collidingAABB.func_72326_a(AABB)) continue;
                    collidingBoundingBoxes.add(AABB);
                }
            }
        } else {
            AxisAlignedBB AABB = this.getOuterBoundingBox(world, x, y, z);
            if (AABB != null && collidingAABB.func_72326_a(AABB)) {
                collidingBoundingBoxes.add(AABB);
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return this.getOuterBoundingBox(world, x, y, z);
    }

    public AxisAlignedBB getOuterBoundingBox(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public AxisAlignedBB getInnerBoundingBox(World world, int x, int y, int z) {
        AxisAlignedBB AABB = AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B + 0.125), (double)((double)y + this.field_149760_C + 0.125), (double)((double)z + this.field_149754_D + 0.125), (double)((double)x + this.field_149755_E - 0.125), (double)((double)y + this.field_149756_F - 0.125), (double)((double)z + this.field_149757_G - 0.125));
        return AABB;
    }

    @Override
    public boolean isBlockFullCube(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBasin) {
            return ((TileEntityBasin)tile).isClosed();
        }
        return true;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return super.func_149645_b();
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.blockIconTopOpen = iconRegister.func_94245_a(this.func_149641_N() + "_top_open");
        this.blockIconTopClosed = iconRegister.func_94245_a(this.func_149641_N() + "_top_closed");
        this.blockIconBottom = iconRegister.func_94245_a(this.func_149641_N() + "_bottom");
        blockIconInner = iconRegister.func_94245_a(this.func_149641_N() + "_inner");
        this.blockIconSide = iconRegister.func_94245_a(this.func_149641_N() + "_side");
    }

    public IIcon func_149691_a(int side, int metadata) {
        switch (ForgeDirection.getOrientation((int)side)) {
            case DOWN: {
                return this.blockIconBottom;
            }
            case UP: {
                return this.blockIconTopClosed;
            }
            case EAST: 
            case WEST: 
            case NORTH: 
            case SOUTH: {
                return this.blockIconSide;
            }
        }
        return super.func_149691_a(side, metadata);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile;
        if (ForgeDirection.getOrientation((int)side) == ForgeDirection.UP && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityBasin && ((TileEntityBasin)tile).isOpen()) {
            return this.blockIconTopOpen;
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public static IIcon getInnerIcon() {
        return blockIconInner;
    }
}

