/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.capabilities;

import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import thaumcraft.api.research.ResearchCategory;

public interface IPlayerKnowledge
extends INBTSerializable<NBTTagCompound> {
    public void clear();

    public EnumResearchStatus getResearchStatus(@Nonnull String var1);

    public boolean isResearchComplete(String var1);

    public boolean isResearchKnown(String var1);

    public int getResearchStage(@Nonnull String var1);

    public boolean addResearch(@Nonnull String var1);

    public boolean setResearchStage(@Nonnull String var1, int var2);

    public boolean removeResearch(@Nonnull String var1);

    @Nonnull
    public Set<String> getResearchList();

    public boolean setResearchFlag(@Nonnull String var1, @Nonnull EnumResearchFlag var2);

    public boolean clearResearchFlag(@Nonnull String var1, @Nonnull EnumResearchFlag var2);

    public boolean hasResearchFlag(@Nonnull String var1, @Nonnull EnumResearchFlag var2);

    public boolean addKnowledge(@Nonnull EnumKnowledgeType var1, ResearchCategory var2, int var3);

    public int getKnowledge(@Nonnull EnumKnowledgeType var1, ResearchCategory var2);

    public int getKnowledgeRaw(@Nonnull EnumKnowledgeType var1, ResearchCategory var2);

    public void sync(EntityPlayerMP var1);

    public static enum EnumResearchFlag {
        PAGE,
        RESEARCH,
        POPUP;

    }

    public static enum EnumKnowledgeType {
        THEORY(32, true, "T"),
        OBSERVATION(16, true, "O");

        private short progression;
        private boolean hasFields;
        private String abbr;

        private EnumKnowledgeType(int progression, boolean hasFields, String abbr) {
            this.progression = (short)progression;
            this.hasFields = hasFields;
            this.abbr = abbr;
        }

        public int getProgression() {
            return this.progression;
        }

        public boolean hasFields() {
            return this.hasFields;
        }

        public String getAbbreviation() {
            return this.abbr;
        }
    }

    public static enum EnumResearchStatus {
        UNKNOWN,
        COMPLETE,
        IN_PROGRESS;

    }
}

