/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PedestalBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PedestalBlock
extends WaterBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.125, (double)0.1875, (double)0.815, (double)0.885, (double)0.815), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.0625, (double)0.8125, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375), Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.9375)});
    protected static final VoxelShape SHAPE_UP = Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.125, (double)0.1875, (double)0.815, (double)1.0, (double)0.815), (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.9375));
    protected static final VoxelShape SHAPE_DOWN = Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.815, (double)0.885, (double)0.815), (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.8125, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375));
    protected static final VoxelShape SHAPE_UP_DOWN = Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.815, (double)1.0, (double)0.815);
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty HAS_ITEM = BlockProperties.HAS_ITEM;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;

    public PedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false)));
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity blockEntity;
        if (ServerConfigs.cached.CRYSTAL_ENCHANTING && (blockEntity = world.m_7702_(pos)) instanceof PedestalBlockTile) {
            PedestalBlockTile te = (PedestalBlockTile)blockEntity;
            if (te.f_58855_ == PedestalBlockTile.DisplayType.CRYSTAL) {
                return 3.0f;
            }
        }
        return 0.0f;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, WATERLOGGED, HAS_ITEM, AXIS});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        boolean flag = world.m_6425_(pos = context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_(AXIS, (Comparable)context.m_8125_().m_122434_())).m_61124_((Property)UP, (Comparable)Boolean.valueOf(PedestalBlock.canConnect(world.m_8055_(pos.m_7494_()), pos, (LevelAccessor)world, Direction.UP, false)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(PedestalBlock.canConnect(world.m_8055_(pos.m_7495_()), pos, (LevelAccessor)world, Direction.DOWN, false)));
    }

    public static boolean canConnect(BlockState state, BlockPos pos, LevelAccessor world, Direction dir, boolean hasItem) {
        if (state.m_60734_() instanceof PedestalBlock) {
            if (dir == Direction.DOWN) {
                return (Boolean)state.m_61143_((Property)HAS_ITEM) == false;
            }
            if (dir == Direction.UP) {
                return !hasItem;
            }
        }
        return false;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (facing == Direction.UP) {
            return (BlockState)stateIn.m_61124_((Property)UP, (Comparable)Boolean.valueOf(PedestalBlock.canConnect(facingState, currentPos, worldIn, facing, (Boolean)stateIn.m_61143_((Property)HAS_ITEM))));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(PedestalBlock.canConnect(facingState, currentPos, worldIn, facing, (Boolean)stateIn.m_61143_((Property)HAS_ITEM))));
        }
        return stateIn;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemDisplayTile tile;
        ItemStack i;
        BlockEntity blockEntity;
        if (target.m_82450_().m_7098_() > (double)(pos.m_123342_() + 1) - 0.1875 && (blockEntity = world.m_7702_(pos)) instanceof ItemDisplayTile && !(i = (tile = (ItemDisplayTile)blockEntity).getDisplayedItem()).m_41619_()) {
            return i;
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        PedestalBlockTile tile;
        if (!((Boolean)state.m_61143_((Property)HAS_ITEM)).booleanValue()) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_ITEM, (Comparable)Boolean.valueOf(true)), 6);
        }
        InteractionResult resultType = InteractionResult.PASS;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof PedestalBlockTile && (tile = (PedestalBlockTile)blockEntity).isAccessibleBy(player)) {
            ItemStack handItem = player.m_21120_(handIn);
            if (handItem.m_41720_() instanceof SackItem) {
                ItemStack it = handItem.m_41777_();
                it.m_41764_(1);
                ItemStack removed = tile.m_8016_(0);
                tile.setDisplayedItem(it);
                if (!player.m_7500_()) {
                    handItem.m_41774_(1);
                }
                if (!worldIn.m_5776_()) {
                    player.m_21008_(handIn, removed);
                    worldIn.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, worldIn.f_46441_.nextFloat() * 0.1f + 0.95f);
                    tile.m_6596_();
                } else {
                    tile.updateClientVisualsOnLoad();
                }
                resultType = InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            } else {
                resultType = tile.interact(player, handIn);
            }
            if (resultType.m_19077_()) {
                Direction.Axis axis = player.m_6350_().m_122434_();
                boolean isEmpty = tile.getDisplayedItem().m_41619_();
                if (axis != state.m_61143_(AXIS) || isEmpty) {
                    worldIn.m_7731_(pos, (BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)axis)).m_61124_((Property)HAS_ITEM, (Comparable)Boolean.valueOf(!isEmpty)), 2);
                    if (isEmpty) {
                        worldIn.m_46747_(pos);
                    }
                }
            }
        }
        return resultType;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean up = (Boolean)state.m_61143_((Property)UP);
        boolean down = (Boolean)state.m_61143_((Property)DOWN);
        if (!up) {
            if (!down) {
                return SHAPE;
            }
            return SHAPE_DOWN;
        }
        if (!down) {
            return SHAPE_UP;
        }
        return SHAPE_UP_DOWN;
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        return tileEntity instanceof MenuProvider ? (MenuProvider)tileEntity : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (((Boolean)pState.m_61143_((Property)HAS_ITEM)).booleanValue()) {
            return new PedestalBlockTile(pPos, pState);
        }
        return null;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof ItemDisplayTile) {
                ItemDisplayTile tile = (ItemDisplayTile)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)tile);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PedestalBlockTile) {
            PedestalBlockTile tile = (PedestalBlockTile)blockEntity;
            return tile.m_7983_() ? 0 : 15;
        }
        return 0;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (rotation == Rotation.CLOCKWISE_180) {
            return state;
        }
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Direction.Axis.Z -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
            case Direction.Axis.X -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
            default -> state;
        };
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockUtils.addOptionalOwnership(placer, world, pos);
    }
}

