/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlowerBoxBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlowerBoxBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class FlowerBoxBakedModel
implements IDynamicBakedModel {
    private final BakedModel box;
    private final BlockModelShaper blockModelShaper;

    public FlowerBoxBakedModel(BakedModel box) {
        this.box = box;
        this.blockModelShaper = Minecraft.m_91087_().m_91289_().m_110907_();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        try {
            quads.addAll(this.box.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (state != null) {
                BlockState[] flowers = new BlockState[]{(BlockState)extraData.getData(FlowerBoxBlockTile.FLOWER_0), (BlockState)extraData.getData(FlowerBoxBlockTile.FLOWER_1), (BlockState)extraData.getData(FlowerBoxBlockTile.FLOWER_2)};
                PoseStack matrixStack = new PoseStack();
                matrixStack.m_85837_(0.5, 0.5, 0.5);
                float yaw = -((Direction)state.m_61143_((Property)FlowerBoxBlock.FACING)).m_122424_().m_122435_();
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(yaw));
                matrixStack.m_85837_(-0.3125, -0.1875, 0.0);
                if (((Boolean)state.m_61143_((Property)FlowerBoxBlock.FLOOR)).booleanValue()) {
                    matrixStack.m_85837_(0.0, 0.0, -0.3125);
                }
                matrixStack.m_85841_(0.625f, 0.625f, 0.625f);
                matrixStack.m_85837_(0.5, 0.5, 0.5);
                matrixStack.m_85837_(-0.5, 0.0, 0.0);
                for (int i = 0; i < 3; ++i) {
                    BlockState flower = flowers[i];
                    if (flower != null && !flower.m_60795_()) {
                        this.addBlockToModel(i, quads, flower, matrixStack, side, rand);
                        if (flower.m_61138_((Property)DoublePlantBlock.f_52858_)) {
                            matrixStack.m_85837_(0.0, 1.0, 0.0);
                            this.addBlockToModel(i, quads, (BlockState)flower.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER), matrixStack, side, rand);
                            matrixStack.m_85837_(0.0, -1.0, 0.0);
                        }
                    }
                    matrixStack.m_85837_(0.5, 0.0, 0.0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return quads;
    }

    private void addBlockToModel(int index, List<BakedQuad> quads, BlockState state, PoseStack matrixStack, @Nullable Direction side, @Nonnull Random rand) {
        BakedModel model;
        ResourceLocation res = FlowerPotHandler.getSpecialFlowerModel(state.m_60734_().m_5456_());
        if (res != null) {
            if (state.m_61138_((Property)DoublePlantBlock.f_52858_) && state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
                return;
            }
            model = this.blockModelShaper.m_110881_().getModel(res);
        } else {
            model = this.blockModelShaper.m_110893_(state);
        }
        List mimicQuads = model.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
        for (BakedQuad q : mimicQuads) {
            int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
            TextureAtlasSprite texture = this.m_6160_();
            if (res == null) {
                RendererUtil.moveVertices(v, -0.5f, -0.5f, -0.5f, texture);
                RendererUtil.scaleVertices(v, 0.6249f, texture);
            } else {
                RendererUtil.moveVertices(v, -0.5f, -0.3125f, -0.5f, texture);
            }
            RendererUtil.transformVertices(v, matrixStack, texture);
            quads.add(new BakedQuad(v, q.m_111305_() >= 0 ? index : q.m_111305_(), q.m_111306_(), q.m_173410_(), q.m_111307_()));
        }
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.box.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }
}

