/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.smallships.corelib;

import de.maxhenkel.smallships.corelib.config.ConfigBase;
import de.maxhenkel.smallships.corelib.config.DynamicConfig;
import de.maxhenkel.smallships.corelib.net.Message;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class CommonRegistry {
    private static final LevelResource SERVERCONFIG = new LevelResource("serverconfig");
    private static final Path DEFAULT_CONFIG_PATH = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath());

    public static SimpleChannel registerChannel(String modId, String name, int protocolVersion) {
        String protocolVersionString = String.valueOf(protocolVersion);
        return NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(modId, name), () -> protocolVersionString, s -> s.equals(protocolVersionString), s -> s.equals(protocolVersionString));
    }

    public static SimpleChannel registerChannel(String modId, String name) {
        return NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(modId, name), () -> "1.0.0", s -> true, s -> true);
    }

    public static <T extends Message<?>> void registerMessage(SimpleChannel channel, int id, Class<T> message) {
        channel.registerMessage(id, message, Message::toBytes, buf -> {
            try {
                Message msg = (Message)message.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return msg.fromBytes((FriendlyByteBuf)buf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (msg, fun) -> {
            if (msg.getExecutingSide().equals((Object)Dist.CLIENT)) {
                msg.executeClientSide((NetworkEvent.Context)fun.get());
            } else if (msg.getExecutingSide().equals((Object)Dist.DEDICATED_SERVER)) {
                msg.executeServerSide((NetworkEvent.Context)fun.get());
            }
        });
    }

    public static <T extends Entity> EntityType<T> registerEntity(String modId, String name, MobCategory classification, Class<? extends Entity> entityClass, Consumer<EntityType.Builder<T>> builderConsumer) {
        EntityType.Builder builder = EntityType.Builder.m_20704_((type, world) -> {
            try {
                try {
                    return (Entity)entityClass.getConstructor(EntityType.class, Level.class).newInstance(type, world);
                }
                catch (NoSuchMethodException e) {
                    return (Entity)entityClass.getConstructor(Level.class).newInstance(world);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, (MobCategory)classification);
        builderConsumer.accept(builder);
        EntityType type2 = builder.m_20712_(modId + ":" + name);
        type2.setRegistryName(new ResourceLocation(modId, name));
        return type2;
    }

    public static <T extends ConfigBase> T registerConfig(ModConfig.Type type, Class<T> configClass, boolean registerListener) {
        ConfigBase config;
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        try {
            config = (ConfigBase)configClass.getConstructor(ForgeConfigSpec.Builder.class).newInstance(builder);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        ForgeConfigSpec spec = builder.build();
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)spec);
        config.setConfigSpec(spec);
        if (registerListener) {
            Consumer<ModConfigEvent> consumer = evt -> {
                if (evt.getConfig().getType() == type) {
                    config.onReload((ModConfigEvent)evt);
                }
            };
            FMLJavaModLoadingContext.get().getModEventBus().addListener(consumer);
        }
        return (T)config;
    }

    public static <T extends ConfigBase> T registerConfig(ModConfig.Type type, Class<T> configClass) {
        return CommonRegistry.registerConfig(type, configClass, false);
    }

    public static <T extends DynamicConfig> T registerDynamicConfig(DynamicConfig.DynamicConfigType type, String folderName, String configName, Class<T> configClass) {
        try {
            DynamicConfig config = (DynamicConfig)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String configFileName = configName + ".toml";
            if (type.equals((Object)DynamicConfig.DynamicConfigType.SERVER)) {
                Consumer<ServerAboutToStartEvent> consumer = event -> {
                    Path serverConfig = event.getServer().m_129843_(SERVERCONFIG).resolve(folderName);
                    serverConfig.toFile().mkdirs();
                    Path configPath = serverConfig.resolve(configFileName);
                    Path defaultPath = DEFAULT_CONFIG_PATH.resolve(folderName).resolve(configFileName);
                    config.init(configPath, defaultPath);
                };
                MinecraftForge.EVENT_BUS.addListener(consumer);
            } else {
                Path commonConfig = FMLPaths.CONFIGDIR.get().resolve(folderName);
                commonConfig.toFile().mkdirs();
                Path configPath = commonConfig.resolve(configFileName);
                config.init(configPath);
            }
            return (T)config;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

