/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.network;

import com.talhanation.smallships.entities.AbstractSailShip;
import de.maxhenkel.smallships.corelib.net.Message;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageControlShip
implements Message<MessageControlShip> {
    private boolean forward;
    private boolean backward;
    private boolean left;
    private boolean right;
    private UUID uuid;

    public MessageControlShip() {
    }

    public MessageControlShip(boolean forward, boolean backward, boolean left, boolean right, Player player) {
        this.forward = forward;
        this.backward = backward;
        this.left = left;
        this.right = right;
        this.uuid = player.m_142081_();
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        if (!context.getSender().m_142081_().equals(this.uuid)) {
            return;
        }
        Entity entity = context.getSender().m_20202_();
        if (!(entity instanceof AbstractSailShip)) {
            return;
        }
        AbstractSailShip ship = (AbstractSailShip)entity;
        ship.updateControls(this.forward, this.backward, this.left, this.right, (Player)context.getSender());
        ship.m_6352_((Component)new TextComponent("Forward: " + this.forward), context.getSender().m_142081_());
    }

    @Override
    public MessageControlShip fromBytes(FriendlyByteBuf buf) {
        this.forward = buf.readBoolean();
        this.backward = buf.readBoolean();
        this.left = buf.readBoolean();
        this.right = buf.readBoolean();
        this.uuid = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.forward);
        buf.writeBoolean(this.backward);
        buf.writeBoolean(this.left);
        buf.writeBoolean(this.right);
        buf.m_130077_(this.uuid);
    }
}

