/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.talhanation.smallships.InventoryEvents;
import com.talhanation.smallships.entities.AbstractCannonShip;
import com.talhanation.smallships.init.ModEntityTypes;
import com.talhanation.smallships.init.ModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CogEntity
extends AbstractCannonShip {
    public CogEntity(EntityType<? extends CogEntity> type, Level world) {
        super((EntityType<? extends AbstractCannonShip>)type, world);
    }

    public CogEntity(Level world, double x, double y, double z) {
        this((EntityType<? extends CogEntity>)((EntityType)ModEntityTypes.COG.get()), world);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    @Override
    public double getWidth() {
        return 3.0;
    }

    @Override
    public double getHeight() {
        return 1.5;
    }

    @Override
    public double getShipDefense() {
        return 12.0;
    }

    @Override
    public int getInventorySize() {
        return 54;
    }

    @Override
    public float getMaxSpeed() {
        return 6.0f;
    }

    @Override
    public float getMaxReverseSpeed() {
        return 0.1f;
    }

    @Override
    public float getAcceleration() {
        return 0.015f;
    }

    @Override
    public float getMaxRotationSpeed() {
        return 2.0f;
    }

    @Override
    public float getRotationAcceleration() {
        return 0.3f;
    }

    @Override
    public float getCargoModifier() {
        return (float)this.getCargo() * 0.02f;
    }

    @Override
    public float getCannonModifier() {
        return (float)this.getTotalCannonCount() * 0.02f;
    }

    @Override
    public float getPassengerModifier() {
        return (float)this.getPassengerSize() * 0.01f;
    }

    @Override
    public float getVelocityResistance() {
        return 0.009f;
    }

    @Override
    public ResourceLocation getLootTable() {
        return null;
    }

    @Override
    public int getPassengerSize() {
        return switch (this.getTotalCannonCount()) {
            case 0 -> 5;
            case 1 -> 4;
            case 2 -> 4;
            case 3 -> 3;
            case 4 -> 3;
            default -> throw new IllegalStateException("Unexpected passenger size: " + this.getTotalCannonCount());
        };
    }

    @Override
    public int getMaxCannons() {
        return 4;
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (player.m_36341_()) {
            if (this.m_20160_() && !(this.m_6688_() instanceof Player)) {
                this.m_20153_();
            } else {
                if (!(this.m_6688_() instanceof Player)) {
                    InventoryEvents.openShipGUI(player, this, 0);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        if (!this.getSunken()) {
            if (itemInHand.m_41720_() == ModItems.CANNON_ITEM.get()) {
                this.onInteractionWithCannon(player, itemInHand);
                return InteractionResult.SUCCESS;
            }
            if (itemInHand.m_41720_() instanceof DyeItem) {
                this.onInteractionWithDye(player, ((DyeItem)itemInHand.m_41720_()).m_41089_(), itemInHand);
                return InteractionResult.SUCCESS;
            }
            if (itemInHand.m_41720_() instanceof BannerItem) {
                this.onInteractionWithBanner(itemInHand, player);
                return InteractionResult.SUCCESS;
            }
            if (itemInHand.m_41720_() instanceof AxeItem) {
                if (this.hasPlanks(player.m_150109_()) && this.hasIronNugget(player.m_150109_()) && (double)this.getShipDamage() > 16.0) {
                    this.onInteractionWitAxe(player);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            if (itemInHand.m_41720_() instanceof ShearsItem) {
                if (this.getHasBanner()) {
                    this.onInteractionWithShears(player);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (!player.m_36341_()) {
                if (!this.f_19853_.f_46443_) {
                    return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    @Override
    public boolean doesEnterThirdPerson() {
        return true;
    }

    @Override
    public void WaterSplash() {
        Vec3 vector3d = this.m_20252_(0.0f);
        float f0 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.8f;
        float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.8f;
        float f0_1 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.6f;
        float f1_1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 1.6f;
        float f2 = 2.5f - this.f_19796_.nextFloat() * 0.7f;
        float f2_ = -1.3f - this.f_19796_.nextFloat() * 0.7f;
        float x = 0.0f;
        for (int i = 0; i < 2; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vector3d.f_82479_ * (double)f2 + (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.5, this.m_20189_() - vector3d.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vector3d.f_82479_ * (double)f2 - (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.5, this.m_20189_() - vector3d.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vector3d.f_82479_ * (double)f2 + (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.5, this.m_20189_() - vector3d.f_82481_ * (double)f2 + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vector3d.f_82479_ * (double)f2 - (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.5, this.m_20189_() - vector3d.f_82481_ * (double)f2 - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2 + (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2 - (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2 + (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)f2 + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2 - (double)f0, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)f2 - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ + (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) + (double)f1_1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ - (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) - (double)f1_1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ + (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) + (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ - (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) - (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ + (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) + (double)f1_1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ - (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) - (double)f1_1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ + (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) + (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - vector3d.f_82479_ * (double)f2_ - (double)f0_1, this.m_20186_() - vector3d.f_82480_ + 0.8, this.m_20189_() - vector3d.f_82481_ * (double)(f2_ - x) - (double)f1_1 * 1.1, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getBiomesModifierType() {
        return 0;
    }

    @Override
    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            float f = -1.75f;
            float d = 0.0f;
            float x = 0.0f;
            float f1 = (float)((this.m_146910_() ? 0.02 : this.m_6048_()) + passenger.m_6049_());
            if (this.m_20197_().size() == 2) {
                i = this.m_20197_().indexOf(passenger);
                f = i == 0 ? -1.75f : 1.25f;
                d = 0.0f;
            } else if (this.m_20197_().size() == 3) {
                i = this.m_20197_().indexOf(passenger);
                if (i == 0) {
                    f = -1.75f;
                    d = 0.0f;
                } else if (i == 1) {
                    f = 1.25f;
                    d = 0.9f;
                } else {
                    f = 1.25f;
                    d = -0.9f;
                }
            } else if (this.m_20197_().size() == 4) {
                i = this.m_20197_().indexOf(passenger);
                if (i == 0) {
                    f = -1.75f;
                    d = 0.0f;
                } else if (i == 1) {
                    f = 1.25f;
                    d = -0.9f;
                } else if (i == 2) {
                    f = 1.25f;
                    d = 0.9f;
                } else {
                    f = 0.45f;
                    d = 0.0f;
                }
            } else if (this.m_20197_().size() == 5) {
                i = this.m_20197_().indexOf(passenger);
                if (i == 0) {
                    f = -1.75f;
                    d = 0.0f;
                } else if (i == 1) {
                    f = 1.25f;
                    d = -0.9f;
                } else if (i == 2) {
                    f = 1.25f;
                    d = 0.9f;
                } else if (i == 3) {
                    f = 0.45f;
                    d = 0.9f;
                } else {
                    f = 0.45f;
                    d = -0.9f;
                }
            }
            Vec3 vector3d = new Vec3((double)(f += x), 0.0, 0.0 + (double)d).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            passenger.m_6034_(this.m_20185_() + vector3d.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vector3d.f_82481_);
            passenger.m_146922_(passenger.m_146908_() + this.deltaRotation);
            this.applyOriantationsToEntity(passenger);
        }
    }
}

