/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.talhanation.smallships.config.SmallShipsConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractWaterVehicle
extends Entity {
    public Status status;
    public Status previousStatus;
    public double waterLevel;
    public double lastYd;
    private int steps;
    private double clientX;
    private double clientY;
    private double clientZ;
    private double clientYaw;
    private double clientPitch;
    protected float deltaRotation;
    protected AABB boundingBox;

    public AbstractWaterVehicle(EntityType<? extends AbstractWaterVehicle> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
        this.f_19793_ = 0.6f;
        this.recalculateBoundingBox();
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            this.f_19854_ = this.m_20185_();
            this.f_19855_ = this.m_20186_();
            this.f_19856_ = this.m_20189_();
        }
        this.previousStatus = this.status;
        this.status = this.getStatus();
        super.m_8119_();
        this.tickLerp();
        this.recalculateBoundingBox();
        this.m_20101_();
        this.handleCollisionWithEntity();
    }

    public void handleCollisionWithEntity() {
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.f_19853_.f_46443_ && !(this.m_6688_() instanceof Player);
            for (Entity entity : list) {
                if (entity.m_20363_((Entity)this)) continue;
                if (flag && this.m_7310_(entity) && !entity.m_20159_() && entity.m_20205_() < this.m_20205_() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity);
            }
        }
    }

    public void recalculateBoundingBox() {
        double width = this.getWidth();
        double height = this.getHeight();
        this.boundingBox = new AABB(this.m_20185_() - width / 2.0, this.m_20186_(), this.m_20189_() - width / 2.0, this.m_20185_() + width / 2.0, this.m_20186_() + height, this.m_20189_() + width / 2.0);
    }

    public abstract double getWidth();

    public abstract double getHeight();

    @Nullable
    public Player getDriver() {
        List passengers = this.m_20197_();
        if (passengers.size() <= 0) {
            return null;
        }
        if (passengers.get(0) instanceof Player) {
            return (Player)passengers.get(0);
        }
        return null;
    }

    public abstract int getPassengerSize();

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < this.getPassengerSize() && !((List)SmallShipsConfig.PassengerBlackList.get()).contains(passenger.m_20078_());
    }

    protected void applyOriantationsToEntity(Entity entityToUpdate) {
        entityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-130.0f, (float)130.0f);
        entityToUpdate.f_19859_ += f1 - f;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + f1 - f);
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7340_(Entity entityToUpdate) {
        this.applyOriantationsToEntity(entityToUpdate);
    }

    public void m_7332_(Entity passenger) {
        if (!this.m_20363_(passenger)) {
            // empty if block
        }
    }

    public Entity m_6688_() {
        return this.getDriver();
    }

    public boolean m_7337_(Entity entity) {
        return (entity.m_5829_() || entity.m_6094_()) && !this.m_20365_(entity);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.steps = 0;
            this.m_20167_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.steps > 0) {
            double d0 = this.m_20185_() + (this.clientX - this.m_20185_()) / (double)this.steps;
            double d1 = this.m_20186_() + (this.clientY - this.m_20186_()) / (double)this.steps;
            double d2 = this.m_20189_() + (this.clientZ - this.m_20189_()) / (double)this.steps;
            double d3 = Mth.m_14175_((double)(this.clientYaw - (double)this.m_146908_()));
            this.m_146922_((float)((double)this.m_146908_() + d3 / (double)this.steps));
            this.m_146926_((float)((double)this.m_146909_() + (this.clientPitch - (double)this.m_146909_()) / (double)this.steps));
            --this.steps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.clientX = x;
        this.clientY = y;
        this.clientZ = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.steps = 10;
    }

    public static double calculateMotionX(float speed, float rotationYaw) {
        return Mth.m_14031_((float)(-rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public static double calculateMotionZ(float speed, float rotationYaw) {
        return Mth.m_14089_((float)(rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public abstract InteractionResult m_6096_(Player var1, InteractionHand var2);

    public abstract boolean doesEnterThirdPerson();

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Vec3 m_7688_(LivingEntity entity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(entity);
        }
        int[][] offsets = DismountHelper.m_38467_((Direction)direction);
        AABB bb = entity.m_21270_(Pose.STANDING);
        AABB carBB = this.m_142469_();
        for (int[] offset : offsets) {
            Vec3 dismountPos = new Vec3(this.m_20185_() + (double)offset[0] * (carBB.m_82362_() / 2.0 + bb.m_82362_() / 2.0 + 0.0625), this.m_20186_() + 0.75, this.m_20189_() + (double)offset[1] * (carBB.m_82362_() / 2.0 + bb.m_82362_() / 2.0 + 0.0625));
            double y = this.f_19853_.m_45573_(new BlockPos(dismountPos));
            if (!DismountHelper.m_38439_((double)y) || !DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)entity, (AABB)bb.m_82383_(dismountPos))) continue;
            return dismountPos;
        }
        return super.m_7688_(entity);
    }

    public Status getStatus() {
        Status boatentity$status = this.getUnderwaterStatus();
        if (boatentity$status != null) {
            this.waterLevel = this.m_142469_().f_82292_;
            return boatentity$status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float f = this.getBoatGlide();
        if (f > 0.0f) {
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    private boolean checkInWater() {
        AABB axisalignedbb = this.m_142469_();
        int i = Mth.m_14107_((double)axisalignedbb.f_82288_);
        int j = Mth.m_14165_((double)axisalignedbb.f_82291_);
        int k = Mth.m_14107_((double)axisalignedbb.f_82289_);
        int l = Mth.m_14165_((double)(axisalignedbb.f_82289_ + 0.001));
        int i1 = Mth.m_14107_((double)axisalignedbb.f_82290_);
        int j1 = Mth.m_14165_((double)axisalignedbb.f_82293_);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutable);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    public float getBoatGlide() {
        AABB axisalignedbb = this.m_142469_();
        AABB axisalignedbb1 = new AABB(axisalignedbb.f_82288_, axisalignedbb.f_82289_ - 0.001, axisalignedbb.f_82290_, axisalignedbb.f_82291_, axisalignedbb.f_82289_, axisalignedbb.f_82293_);
        int i = Mth.m_14107_((double)axisalignedbb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)axisalignedbb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)axisalignedbb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)axisalignedbb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)axisalignedbb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)axisalignedbb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)axisalignedbb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutable.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutable).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction((LevelReader)this.f_19853_, (BlockPos)blockpos$mutable, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    public float getWaterLevelAbove() {
        AABB axisalignedbb = this.m_142469_();
        int i = Mth.m_14107_((double)axisalignedbb.f_82288_);
        int j = Mth.m_14165_((double)axisalignedbb.f_82291_);
        int k = Mth.m_14107_((double)axisalignedbb.f_82292_);
        int l = Mth.m_14165_((double)(axisalignedbb.f_82292_ - this.lastYd));
        int i1 = Mth.m_14107_((double)axisalignedbb.f_82290_);
        int j1 = Mth.m_14165_((double)axisalignedbb.f_82293_);
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutable);
                    if (fluidstate.m_205070_(FluidTags.f_13131_)) {
                        f = Math.max(f, fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutable.m_123342_() + f;
        }
        return l + 1;
    }

    protected void floatUp() {
        if (this.m_204029_(FluidTags.f_13131_)) {
            this.m_20334_(this.m_20184_().f_82479_, 0.2, this.m_20184_().f_82481_);
        }
    }

    @Nullable
    private Status getUnderwaterStatus() {
        AABB axisalignedbb = this.m_142469_();
        double d0 = axisalignedbb.f_82292_ + 0.075;
        int i = Mth.m_14107_((double)axisalignedbb.f_82288_);
        int j = Mth.m_14165_((double)axisalignedbb.f_82291_);
        int k = Mth.m_14107_((double)axisalignedbb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)axisalignedbb.f_82290_);
        int j1 = Mth.m_14165_((double)axisalignedbb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutable);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_) || !(1.5 * d0 < (double)((float)blockpos$mutable.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    public boolean m_20305_() {
        return this.f_19853_.m_8055_(this.m_142538_()).m_60713_(Blocks.f_50628_);
    }

    public void m_20321_(boolean p_203004_1_) {
    }

    public void m_6845_(boolean p_203002_1_) {
        if (this.f_19853_.m_5776_()) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)this.f_19796_.nextFloat(), this.m_20186_() + 0.7, this.m_20189_() + (double)this.f_19796_.nextFloat(), 0.0, 0.0, 0.0);
        }
        if (this.f_19796_.nextInt(20) == 0) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11917_, this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.nextFloat(), false);
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }

    public static enum Type {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] aboatentity$type = Type.values();
            if (id < 0 || id >= aboatentity$type.length) {
                id = 0;
            }
            return aboatentity$type[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] aboatentity$type;
            for (Type type : aboatentity$type = Type.values()) {
                if (!type.getName().equals(nameIn)) continue;
                return type;
            }
            return aboatentity$type[0];
        }
    }
}

