/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.talhanation.smallships.DamageSourceShip;
import com.talhanation.smallships.entities.AbstractBannerUser;
import com.talhanation.smallships.entities.AbstractWaterVehicle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractShipDamage
extends AbstractBannerUser {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(AbstractShipDamage.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> SUNKEN = SynchedEntityData.m_135353_(AbstractShipDamage.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int sunkenTimer = 0;

    public AbstractShipDamage(EntityType<? extends AbstractShipDamage> type, Level world) {
        super((EntityType<? extends AbstractBannerUser>)type, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SUNKEN, (Object)false);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_20077_()) {
            this.setShipDamage(this.getShipDamage() + 1.5f);
        }
        if (this.m_6060_()) {
            this.setShipDamage(this.getShipDamage() + 0.5f);
        }
        if (this.m_20305_()) {
            this.setShipDamage(this.getShipDamage() + 0.15f);
        }
        if (this.getShipDamage() >= 100.0f || this.getStatus() == AbstractWaterVehicle.Status.UNDER_WATER) {
            this.setSunken(true);
            this.m_20334_(0.0, -0.1, 0.0);
            if (this.f_19853_.m_5776_()) {
                this.updateSunkenParticles();
            }
        }
        if (!this.getSunken()) {
            this.floatUp();
        }
        if (this.getSunken()) {
            ++this.sunkenTimer;
        }
        if (this.sunkenTimer >= 6000) {
            this.destroyShip(DamageSource.f_19317_);
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128350_("Damage", this.getShipDamage());
        nbt.m_128379_("Sunken", this.getSunken());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setShipDamage(nbt.m_128457_("Damage"));
        this.setSunken(nbt.m_128471_("Sunken"));
    }

    public boolean getSunken() {
        return (Boolean)this.f_19804_.m_135370_(SUNKEN);
    }

    public float getShipDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public abstract double getShipDefense();

    public void setSunken(boolean sunken) {
        if (sunken != this.getSunken()) {
            if (this.f_19853_.f_46443_) {
                for (int i = 0; i < 600; ++i) {
                    double d0 = this.f_19796_.nextGaussian() * 0.04;
                    double d1 = this.f_19796_.nextGaussian() * 0.02;
                    double d2 = this.f_19796_.nextGaussian() * 0.04;
                    double d3 = 45.0;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20165_(1.0) - d0 * d3, this.m_20187_() - d1 * d3 + (double)i * 1.0E-4, this.m_20262_(2.0) - d2 * d3, d0, d1, d2);
                }
            }
            this.m_20153_();
            this.f_19804_.m_135381_(SUNKEN, (Object)sunken);
        }
    }

    public void setShipDamage(float damage) {
        if (this.getShipDamage() <= 100.0f) {
            this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity sourceEntity = source.m_7640_();
        if (this.f_19853_.f_46443_ || !this.m_6084_() || this.m_20147_() || sourceEntity == null) {
            return false;
        }
        if (sourceEntity instanceof Player) {
            Player player = (Player)sourceEntity;
            if (this.m_20363_((Entity)player)) {
                return false;
            }
            if (player.m_150110_().f_35937_ && player.m_6144_()) {
                this.destroyShip(source);
                return true;
            }
            if (amount >= 2.0f) {
                this.damageShip(amount);
            }
            this.m_5834_();
            return false;
        }
        if (source.m_19360_()) {
            if (amount >= 2.0f) {
                this.damageShip(amount / 2.0f);
            }
            this.m_5834_();
            source.m_7640_().m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.getShipDamage() >= 100.0f) {
            this.setSunken(true);
        }
        if (amount >= 2.0f) {
            this.damageShip(amount);
        }
        return false;
    }

    public abstract ResourceLocation getLootTable();

    @Override
    public void destroyShip(DamageSource source) {
        super.destroyShip(source);
        this.m_146870_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateSunkenParticles() {
        if (this.f_19796_.nextInt(5) == 0) {
            for (int i = 0; i < this.f_19796_.nextInt(4) + 1; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)this.m_20097_().m_123341_() + 0.5, (double)this.m_20097_().m_123342_() + 3.5, (double)this.m_20097_().m_123343_() + 0.5, (double)(this.f_19796_.nextFloat() / 2.0f), 5.0E-5, (double)(this.f_19796_.nextFloat() / 2.0f));
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)this.m_20097_().m_123341_() + 0.5, (double)this.m_20097_().m_123342_() + 2.5, (double)this.m_20097_().m_123343_() + 0.5, (double)(this.f_19796_.nextFloat() / 2.0f), 5.0E-5, (double)(this.f_19796_.nextFloat() / 2.0f));
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)this.m_20097_().m_123341_() + 0.5, (double)this.m_20097_().m_123342_() + 1.5, (double)this.m_20097_().m_123343_() + 0.5, (double)(this.f_19796_.nextFloat() / 2.0f), 5.0E-5, (double)(this.f_19796_.nextFloat() / 2.0f));
            }
        }
    }

    @Override
    public void damageShip(double damage) {
        this.setShipDamage((float)((double)this.getShipDamage() + (damage - damage * (this.getShipDefense() + 15.0) / 100.0)));
    }

    @Override
    public boolean m_7337_(Entity entityIn) {
        float speed;
        if (entityIn instanceof LivingEntity && !this.m_20197_().contains(entityIn) && entityIn.m_142469_().m_82381_(this.m_142469_()) && (speed = this.getSpeed()) > 0.1f) {
            float damage = speed * 10.0f;
            entityIn.m_6469_((DamageSource)DamageSourceShip.DAMAGE_SHIP, damage);
            this.damageShip(damage / 100.0f);
        }
        return super.m_7337_(entityIn);
    }

    public void onInteractionWitAxe(Player player) {
        Inventory playerInventory = player.m_150109_();
        int healBonus = this.f_19796_.nextInt(7) + 5;
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), SoundEvents.f_12635_, this.m_5720_(), 10.0f, 0.8f + 0.4f * this.f_19796_.nextFloat());
        this.setShipDamage(this.getShipDamage() - (float)healBonus);
        this.handleItemsOnRepair(playerInventory);
    }

    public boolean hasPlanks(Inventory inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41720_() != Items.f_42647_ && itemStack.m_41720_() != Items.f_42700_ && itemStack.m_41720_() != Items.f_42795_ && itemStack.m_41720_() != Items.f_42796_ && itemStack.m_41720_() != Items.f_42753_ && itemStack.m_41720_() != Items.f_42794_) continue;
            return true;
        }
        return false;
    }

    public boolean hasIronNugget(Inventory inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41720_() != Items.f_42749_) continue;
            return true;
        }
        return false;
    }

    public void handleItemsOnRepair(Inventory inventory) {
        ItemStack itemStack;
        int i;
        for (i = 0; i < inventory.m_6643_(); ++i) {
            itemStack = inventory.m_8020_(i);
            if (itemStack.m_41720_() != Items.f_42749_) continue;
            itemStack.m_41774_(1);
        }
        for (i = 0; i < inventory.m_6643_(); ++i) {
            itemStack = inventory.m_8020_(i);
            if (itemStack.m_41720_() != Items.f_42647_ && itemStack.m_41720_() != Items.f_42700_ && itemStack.m_41720_() != Items.f_42795_ && itemStack.m_41720_() != Items.f_42796_ && itemStack.m_41720_() != Items.f_42753_ && itemStack.m_41720_() != Items.f_42794_) continue;
            itemStack.m_41774_(1);
        }
    }
}

