/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.talhanation.smallships.Main;
import com.talhanation.smallships.client.model.ModelSail;
import com.talhanation.smallships.client.render.RenderSailColor;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.entities.AbstractWaterVehicle;
import com.talhanation.smallships.init.SoundInit;
import com.talhanation.smallships.network.MessageControlShip;
import com.talhanation.smallships.network.MessageSailState;
import de.maxhenkel.smallships.corelib.math.MathUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractSailShip
extends AbstractWaterVehicle {
    private float wheelRotation;
    private final float[] paddlePositions = new float[2];
    private float waveAngle;
    private float prevWaveAngle;
    private boolean collidedLastTick;
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(AbstractSailShip.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROT_SPEED = SynchedEntityData.m_135353_(AbstractSailShip.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> FORWARD = SynchedEntityData.m_135353_(AbstractSailShip.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BACKWARD = SynchedEntityData.m_135353_(AbstractSailShip.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEFT = SynchedEntityData.m_135353_(AbstractSailShip.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT = SynchedEntityData.m_135353_(AbstractSailShip.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SAIL_STATE = SynchedEntityData.m_135353_(AbstractSailShip.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> SAIL_COLOR = SynchedEntityData.m_135353_(AbstractSailShip.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(AbstractSailShip.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> LEFT_PADDLE = SynchedEntityData.m_135353_(AbstractSailShip.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT_PADDLE = SynchedEntityData.m_135353_(AbstractSailShip.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final ImmutableSet<ResourceKey<Biome>> COLD_BIOMES = ImmutableSet.of((Object)Biomes.f_48168_, (Object)Biomes.f_48171_, (Object)Biomes.f_48211_, (Object)Biomes.f_48172_, (Object)Biomes.f_48212_);
    public static final ImmutableSet<ResourceKey<Biome>> WARM_BIOMES = ImmutableSet.of((Object)Biomes.f_48166_, (Object)Biomes.f_48167_, (Object)Biomes.f_48170_);
    public static final ImmutableSet<ResourceKey<Biome>> NEUTRAL_BIOMES = ImmutableSet.of((Object)Biomes.f_48174_, (Object)Biomes.f_48225_, (Object)Biomes.f_48208_);

    public AbstractSailShip(EntityType<? extends AbstractWaterVehicle> type, Level world) {
        super(type, world);
        this.f_19793_ = 0.2f;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROT_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FORWARD, (Object)false);
        this.f_19804_.m_135372_(BACKWARD, (Object)false);
        this.f_19804_.m_135372_(LEFT, (Object)false);
        this.f_19804_.m_135372_(RIGHT, (Object)false);
        this.f_19804_.m_135372_(SAIL_STATE, (Object)0);
        this.f_19804_.m_135372_(SAIL_COLOR, (Object)"white");
        this.f_19804_.m_135372_(TYPE, (Object)Type.OAK.ordinal());
    }

    public abstract float getMaxSpeed();

    public abstract float getMaxReverseSpeed();

    public abstract float getAcceleration();

    public abstract float getMaxRotationSpeed();

    public abstract float getRotationAcceleration();

    public abstract float getCargoModifier();

    public abstract float getCannonModifier();

    public abstract float getPassengerModifier();

    public abstract boolean getHasBanner();

    public abstract void WaterSplash();

    public abstract void onInteractionWithShears(Player var1);

    public abstract void onCannonKeyPressed();

    public abstract boolean onInteractionWithBanner(ItemStack var1, Player var2);

    public abstract void damageShip(double var1);

    public abstract int getBiomesModifierType();

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getSpeed() > 0.085f || this.getSpeed() < -0.085f) {
            this.knockBack(this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_(4.0, 2.0, 4.0).m_82386_(0.0, -2.0, 0.0), EntitySelector.f_20406_));
            this.knockBack(this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_(4.0, 2.0, 4.0).m_82386_(0.0, -2.0, 0.0), EntitySelector.f_20406_));
            if (this.getStatus() == AbstractWaterVehicle.Status.IN_WATER) {
                this.WaterSplash();
                if (((Boolean)SmallShipsConfig.PlaySwimmSound.get()).booleanValue()) {
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11918_, this.m_5720_(), 0.05f, 0.8f + 0.4f * this.f_19796_.nextFloat());
                }
            }
        }
        if (this.m_6688_() == null || !(this.m_6688_() instanceof Player)) {
            this.setSailState(0);
        }
        if (this.getStatus() == AbstractWaterVehicle.Status.IN_WATER) {
            this.updateWaveAngle();
        }
        this.updateGravity();
        this.controlShip();
        this.checkPush();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.updateWaterMobs();
        this.breakLily();
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128359_("SailColor", this.getSailColor());
        nbt.m_128359_("Type", this.getWoodType().getName());
    }

    public void m_7378_(CompoundTag nbt) {
        this.setSailColor(nbt.m_128461_("SailColor"));
        if (nbt.m_128425_("Type", 8)) {
            this.setWoodType(Type.getTypeFromString(nbt.m_128461_("Type")));
        }
    }

    public float getVelocityResistance() {
        return 0.008f;
    }

    public String getSailColor() {
        return (String)this.f_19804_.m_135370_(SAIL_COLOR);
    }

    public boolean getSteerState(int side) {
        return (Boolean)this.f_19804_.m_135370_(side == 0 ? LEFT : RIGHT) != false && this.m_6688_() != null;
    }

    public Integer getSailState() {
        return (Integer)this.f_19804_.m_135370_(SAIL_STATE);
    }

    public boolean getPaddleState(int side) {
        return (Boolean)this.f_19804_.m_135370_(side == 0 ? LEFT_PADDLE : RIGHT_PADDLE) != false && this.m_6688_() != null;
    }

    public float getKilometerPerHour() {
        return this.getSpeed() * 20.0f * 60.0f * 60.0f / 1000.0f;
    }

    public float getBiomesModifier() {
        int biomeType = this.getBiomesModifierType();
        BlockPos pos = new BlockPos(this.m_20185_(), this.m_20186_() - 0.1, this.m_20189_());
        Optional biome = this.f_19853_.m_5962_().m_175515_(Registry.f_122885_).m_7854_((Object)((Biome)this.f_19853_.m_204166_(pos).m_203334_()));
        if (biome.isPresent()) {
            boolean warmType;
            boolean coldBiomes = COLD_BIOMES.contains(biome.get());
            boolean neutralBiomes = NEUTRAL_BIOMES.contains(biome.get());
            boolean warmBiomes = WARM_BIOMES.contains(biome.get());
            boolean coldType = biomeType == 0;
            boolean neutralType = biomeType == 1;
            boolean bl = warmType = biomeType == 2;
            if (coldBiomes && coldType || warmBiomes && warmType || neutralBiomes && neutralType) {
                return -0.1f;
            }
            if (coldBiomes && warmType || warmBiomes && coldType || (coldBiomes || warmBiomes) && neutralType) {
                return 0.1f;
            }
            if (neutralBiomes && warmType || neutralBiomes && coldType) {
                return 0.05f;
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public float getWheelRotationAmount() {
        return 120.0f * this.getSpeed();
    }

    public float getSpeed() {
        return ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
    }

    public float getRotSpeed() {
        return ((Float)this.f_19804_.m_135370_(ROT_SPEED)).floatValue();
    }

    public Type getWoodType() {
        return Type.byId((Integer)this.f_19804_.m_135370_(TYPE));
    }

    public float getWaveFactor() {
        return this.f_19853_.m_46471_() ? 3.0f : 1.25f;
    }

    public float getWaveSpeed() {
        return this.f_19853_.m_46471_() ? 0.12f : 0.03f;
    }

    public float getWaveAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevWaveAngle, (float)this.waveAngle);
    }

    public boolean isForward() {
        if (this.getDriver() == null) {
            return false;
        }
        return (Boolean)this.f_19804_.m_135370_(FORWARD);
    }

    public boolean isBackward() {
        if (this.getDriver() == null) {
            return false;
        }
        return (Boolean)this.f_19804_.m_135370_(BACKWARD);
    }

    public boolean isLeft() {
        return (Boolean)this.f_19804_.m_135370_(LEFT);
    }

    public boolean isRight() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT);
    }

    public boolean isAccelerating() {
        return (this.isForward() || this.isBackward()) && !this.f_19862_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRowingTime(int side, float limbSwing) {
        return this.getPaddleState(side) ? (float)Mth.m_14085_((double)((double)this.paddlePositions[side] - (double)0.3926991f), (double)this.paddlePositions[side], (double)limbSwing) : 0.0f;
    }

    public void setSailColor(String color) {
        this.f_19804_.m_135381_(SAIL_COLOR, (Object)color);
    }

    public void setSailState(int state) {
        if (state != this.getSailState()) {
            this.playSailSound(state);
            this.f_19804_.m_135381_(SAIL_STATE, (Object)state);
        }
    }

    public void setPaddleState(boolean left, boolean right) {
        this.f_19804_.m_135381_(LEFT_PADDLE, (Object)left);
        this.f_19804_.m_135381_(RIGHT_PADDLE, (Object)right);
    }

    public void setForward(boolean forward) {
        this.f_19804_.m_135381_(FORWARD, (Object)forward);
    }

    public void setBackward(boolean backward) {
        this.f_19804_.m_135381_(BACKWARD, (Object)backward);
    }

    public void setLeft(boolean left) {
        this.f_19804_.m_135381_(LEFT, (Object)left);
    }

    public void setRight(boolean right) {
        this.f_19804_.m_135381_(RIGHT, (Object)right);
    }

    public void setSpeed(float speed) {
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(speed));
    }

    public void setRotSpeed(float rotSpeed) {
        this.f_19804_.m_135381_(ROT_SPEED, (Object)Float.valueOf(rotSpeed));
    }

    public void setWoodType(Type type) {
        this.f_19804_.m_135381_(TYPE, (Object)type.ordinal());
    }

    public void sendSailStateToServer(int state) {
        if (this.f_19853_.f_46443_) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSailState(state));
        }
    }

    public void checkPush() {
        List list = this.f_19853_.m_45976_(Player.class, this.m_142469_().m_82363_(0.2, 0.0, 0.2).m_82363_(-0.2, 0.0, -0.2));
        for (Player player : list) {
            if (player.m_20363_((Entity)this) || !player.m_6144_()) continue;
            double motX = AbstractSailShip.calculateMotionX(0.05f, player.m_146908_());
            double motZ = AbstractSailShip.calculateMotionZ(0.05f, player.m_146908_());
            this.m_6478_(MoverType.PLAYER, new Vec3(motX, 0.0, motZ));
            return;
        }
    }

    private void controlShip() {
        if (!this.m_20160_()) {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
        int sailstate = this.getSailState();
        float modifier = 1.0f - (this.getBiomesModifier() + this.getPassengerModifier() + this.getCannonModifier() + this.getCargoModifier());
        float blockedmodf = 1.0f;
        float maxSp = this.getMaxSpeed() / 13.799999f * modifier;
        float maxBackSp = this.getMaxReverseSpeed() * modifier;
        float maxRotSp = (this.getMaxRotationSpeed() * 0.1f + 1.8f) * modifier;
        float speed = MathUtils.subtractToZero(this.getSpeed(), this.getVelocityResistance());
        if (sailstate != 0) {
            switch (sailstate) {
                case 1: {
                    maxSp *= 0.25f;
                    if (!(speed <= maxSp)) break;
                    speed = Math.min(speed + this.getAcceleration() * 9.0f / 16.0f, maxSp);
                    break;
                }
                case 2: {
                    maxSp *= 0.5f;
                    if (!(speed <= maxSp)) break;
                    speed = Math.min(speed + this.getAcceleration() * 11.0f / 16.0f, maxSp);
                    break;
                }
                case 3: {
                    maxSp *= 0.75f;
                    if (!(speed <= maxSp)) break;
                    speed = Math.min(speed + this.getAcceleration() * 13.0f / 16.0f, maxSp);
                    break;
                }
                case 4: {
                    maxSp *= 1.0f;
                    if (!(speed <= maxSp)) break;
                    speed = Math.min(speed + this.getAcceleration(), maxSp);
                }
            }
        }
        if (this.isForward() && speed <= maxSp) {
            speed = Math.min(speed + this.getAcceleration() * 1.0f / 8.0f, maxSp);
        }
        if (this.isBackward() && speed >= -maxBackSp) {
            speed = Math.max(speed - this.getAcceleration() * 1.0f / 8.0f, -maxBackSp);
        }
        if (this.isLeft() || this.isRight()) {
            speed *= 1.0f - Mth.m_14154_((float)this.getRotSpeed()) * 0.02f;
        }
        this.setSpeed(speed * blockedmodf);
        this.deltaRotation = 0.0f;
        float rotationSpeed = MathUtils.subtractToZero(this.getRotSpeed(), this.getVelocityResistance() * 3.0f);
        if (this.isRight() && rotationSpeed <= maxRotSp) {
            rotationSpeed = Math.min(rotationSpeed + this.getRotationAcceleration() * 1.0f / 8.0f, maxRotSp);
        }
        if (this.isLeft() && rotationSpeed >= -maxRotSp) {
            rotationSpeed = Math.max(rotationSpeed - this.getRotationAcceleration() * 1.0f / 8.0f, -maxRotSp);
        }
        this.setRotSpeed(rotationSpeed);
        this.deltaRotation = rotationSpeed;
        this.m_146922_(this.m_146908_() + this.deltaRotation);
        this.m_20334_(AbstractSailShip.calculateMotionX(this.getSpeed(), this.m_146908_()), this.m_20184_().f_82480_, AbstractSailShip.calculateMotionZ(this.getSpeed(), this.m_146908_()));
    }

    public void onKeyPressed() {
        int state = this.getSailState();
        state = state != 4 ? 4 : 0;
        this.sendSailStateToServer(state);
    }

    public void onKeyLowerPressed() {
        int state = this.getSailState();
        if (state != 4) {
            ++state;
        }
        this.sendSailStateToServer(state);
    }

    public void onKeyHigherPressed() {
        int state = this.getSailState();
        if (state != 0) {
            --state;
        }
        this.sendSailStateToServer(state);
    }

    public void onInteractionWithDye(Player player, DyeColor dyeColor, ItemStack itemStack) {
        String color = dyeColor.m_41065_();
        this.setSailColor(color);
        if (!player.m_7500_()) {
            itemStack.m_41774_(1);
        }
    }

    public void onCollision(float speed) {
        if (this.f_19853_.f_46443_) {
            // empty if block
        }
        this.setSpeed(0.0f);
        this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
    }

    public void updateWaveAngle() {
        this.prevWaveAngle = this.waveAngle;
        this.waveAngle = (float)Math.sin(this.getWaveSpeed() * (float)this.f_19797_) * this.getWaveFactor();
    }

    public void updateWaterMobs() {
        if (((Boolean)SmallShipsConfig.WaterMobFlee.get()).booleanValue()) {
            double radius = 15.0;
            List list1 = this.f_19853_.m_45976_(WaterAnimal.class, new AABB(this.m_20185_() - radius, this.m_20186_() - radius, this.m_20189_() - radius, this.m_20185_() + radius, this.m_20186_() + radius, this.m_20189_() + radius));
            for (WaterAnimal ent : list1) {
                this.fleeEntity((Mob)ent);
            }
        }
    }

    public void updateWheelRotation() {
        this.wheelRotation += this.getWheelRotationAmount();
    }

    private void updateGravity() {
        double d1 = this.m_20068_() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        float momentum = 0.05f;
        if (this.previousStatus == AbstractWaterVehicle.Status.IN_AIR && this.status != AbstractWaterVehicle.Status.IN_AIR && this.status != AbstractWaterVehicle.Status.ON_LAND) {
            this.waterLevel = this.m_20227_(1.0);
            this.m_6034_(this.m_20185_(), (double)(this.getWaterLevelAbove() - this.m_20206_()) + 0.101, this.m_20189_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = AbstractWaterVehicle.Status.IN_WATER;
        } else {
            if (this.status == AbstractWaterVehicle.Status.IN_WATER) {
                d2 = (this.waterLevel - this.m_20186_()) / (double)this.m_20206_();
                momentum = 0.9f;
            }
            Vec3 vector3d = this.m_20184_();
            this.m_20334_(vector3d.f_82479_ * (double)momentum, vector3d.f_82480_ + d1, vector3d.f_82481_ * (double)momentum);
            this.deltaRotation *= momentum;
            if (d2 > 0.0) {
                Vec3 vector3d1 = this.m_20184_();
                this.m_20334_(vector3d1.f_82479_, (vector3d1.f_82480_ + d2 * 0.06153846016296973) * 0.75, vector3d1.f_82481_);
            }
        }
    }

    public void updateControls(boolean forward, boolean backward, boolean left, boolean right, Player player) {
        boolean needsUpdate = false;
        if (this.isForward() != forward) {
            this.setForward(forward);
            needsUpdate = true;
        }
        if (this.isBackward() != backward) {
            this.setBackward(backward);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.f_19853_.f_46443_ && needsUpdate) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageControlShip(forward, backward, left, right, player));
        }
    }

    public boolean canPlayerEnterShip(Player player) {
        return true;
    }

    public void playSailSound(int state) {
        if (state != 0) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), (SoundEvent)SoundInit.SHIP_SAIL_0.get(), this.m_5720_(), 15.0f, 0.8f + 0.4f * this.f_19796_.nextFloat());
        } else {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), (SoundEvent)SoundInit.SHIP_SAIL_1.get(), this.m_5720_(), 10.0f, 0.8f + 0.4f * this.f_19796_.nextFloat());
        }
    }

    public void renderSailColor(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks, ModelSail sailModel) {
        RenderSailColor.renderSailColor(this, partialTicks, matrixStack, this.getSailColor(), buffer, packedLight, sailModel);
    }

    public void destroyShip(DamageSource src) {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public void fleeEntity(Mob entity) {
        double fleeDistance = 10.0;
        Vec3 vecBoat = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 vecEntity = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        Vec3 fleeDir = vecEntity.m_82546_(vecBoat);
        fleeDir = fleeDir.m_82541_();
        Vec3 fleePos = new Vec3(vecEntity.f_82479_ + fleeDir.f_82479_ * fleeDistance, vecEntity.f_82480_ + fleeDir.f_82480_ * fleeDistance, vecEntity.f_82481_ + fleeDir.f_82481_ * fleeDistance);
        entity.m_21573_().m_26519_(fleePos.f_82479_, fleePos.f_82480_, fleePos.f_82481_, 1.5);
    }

    private void knockBack(List<Entity> entities) {
        double d0 = (this.m_142469_().f_82288_ + this.m_142469_().f_82291_) / 2.5;
        double d1 = (this.m_142469_().f_82290_ + this.m_142469_().f_82293_) / 2.5;
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            double d2 = entity.m_20185_() - d0;
            double d3 = entity.m_20189_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.m_5997_(d2 / d4 * 0.4, 0.0, d3 / d4 * 0.4);
            this.m_7337_(entity);
        }
    }

    private void breakLily() {
        AABB boundingBox = this.m_142469_();
        double offset = 0.75;
        BlockPos start = new BlockPos(boundingBox.f_82288_ - offset, boundingBox.f_82289_ - offset, boundingBox.f_82290_ - offset);
        BlockPos end = new BlockPos(boundingBox.f_82291_ + offset, boundingBox.f_82292_ + offset, boundingBox.f_82293_ + offset);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        boolean hasBroken = false;
        if (this.f_19853_.m_46832_(start, end)) {
            for (int i = start.m_123341_(); i <= end.m_123341_(); ++i) {
                for (int j = start.m_123342_(); j <= end.m_123342_(); ++j) {
                    for (int k = start.m_123343_(); k <= end.m_123343_(); ++k) {
                        pos.m_122178_(i, j, k);
                        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)pos);
                        if (!(blockstate.m_60734_() instanceof WaterlilyBlock)) continue;
                        this.f_19853_.m_46961_((BlockPos)pos, true);
                        hasBroken = true;
                    }
                }
            }
        }
        if (hasBroken) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 0.9f + 0.2f * this.f_19796_.nextFloat());
        }
    }

    public Item getItemBoat() {
        return switch (this.getWoodType()) {
            default -> throw new IncompatibleClassChangeError();
            case Type.OAK -> Items.f_42453_;
            case Type.SPRUCE -> Items.f_42742_;
            case Type.BIRCH -> Items.f_42743_;
            case Type.JUNGLE -> Items.f_42744_;
            case Type.ACACIA -> Items.f_42745_;
            case Type.DARK_OAK -> Items.f_42746_;
        };
    }

    public static enum Type {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] aboatentity$type = Type.values();
            if (id < 0 || id >= aboatentity$type.length) {
                id = 0;
            }
            return aboatentity$type[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] aboatentity$type;
            for (Type type : aboatentity$type = Type.values()) {
                if (!type.getName().equals(nameIn)) continue;
                return type;
            }
            return aboatentity$type[0];
        }
    }
}

