/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.talhanation.smallships.entities.AbstractSailShip;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractInventoryEntity
extends AbstractSailShip {
    private static final EntityDataAccessor<Integer> CARGO = SynchedEntityData.m_135353_(AbstractInventoryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> INV_PAGE = SynchedEntityData.m_135353_(AbstractInventoryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final SimpleContainer inventory = new SimpleContainer(this.getInventorySize());

    public AbstractInventoryEntity(EntityType<? extends AbstractInventoryEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CARGO, (Object)0);
        this.f_19804_.m_135372_(INV_PAGE, (Object)1);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag list = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundnbt);
            list.add((Object)compoundnbt);
        }
        nbt.m_128365_("Inventory", (Tag)list);
        nbt.m_128405_("Cargo", this.getCargo());
        nbt.m_128405_("InventoryPage", this.getInvPage());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        ListTag list = nbt.m_128437_("Inventory", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compoundnbt = list.m_128728_(i);
            int j = compoundnbt.m_128445_("Slot") & 0xFF;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
        }
        this.setCargo(nbt.m_128451_("Cargo"));
        this.setInvPage(nbt.m_128451_("InventoryPage"));
    }

    public int getCargo() {
        return (Integer)this.f_19804_.m_135370_(CARGO);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public abstract int getInventorySize();

    public int getMaxInvPage() {
        if (this.getInventorySize() <= 54) {
            return 1;
        }
        if (this.getInventorySize() > 54) {
            return 2;
        }
        return 3;
    }

    public int getInvPage() {
        return (Integer)this.f_19804_.m_135370_(INV_PAGE);
    }

    public boolean setSlot(int slot, ItemStack itemStack) {
        if (super.m_141942_(slot).m_142104_(itemStack)) {
            return true;
        }
        int i = slot - 300;
        if (i >= 0 && i < this.inventory.f_19147_.size()) {
            this.inventory.m_6836_(i, itemStack);
            return true;
        }
        return false;
    }

    public void setCargo(int cargo) {
        this.f_19804_.m_135381_(CARGO, (Object)cargo);
    }

    public void setInvPage(int page) {
        this.f_19804_.m_135381_(INV_PAGE, (Object)page);
    }

    @Override
    public void destroyShip(DamageSource dmg) {
        for (int i = 0; i < this.inventory.f_19147_.size(); ++i) {
            Containers.m_18992_((Level)this.f_19853_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)this.inventory.m_8020_(i));
        }
        super.destroyShip(dmg);
    }

    public void updateCargo() {
        int slotCount = 0;
        int oldSlots = this.getCargo();
        for (int i = 0; i < this.inventory.f_19147_.size(); ++i) {
            if (this.inventory.m_8020_(i).m_41619_()) continue;
            ++slotCount;
        }
        int average = (slotCount + oldSlots) / 2;
        int x = average > 27 * this.getMaxInvPage() ? 4 : (average > 16 * this.getMaxInvPage() ? 3 : (average > 8 * this.getMaxInvPage() ? 2 : (average > 2 * this.getMaxInvPage() ? 1 : 0)));
        this.setCargo(x);
    }
}

