/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.talhanation.smallships.Main;
import com.talhanation.smallships.client.render.RenderCannon;
import com.talhanation.smallships.entities.AbstractShipDamage;
import com.talhanation.smallships.entities.projectile.CannonBallEntity;
import com.talhanation.smallships.init.ModItems;
import com.talhanation.smallships.init.SoundInit;
import com.talhanation.smallships.network.MessageShootCannon;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractCannonShip
extends AbstractShipDamage {
    private static final EntityDataAccessor<Integer> RIGHT_CANNON_COUNT = SynchedEntityData.m_135353_(AbstractCannonShip.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LEFT_CANNON_COUNT = SynchedEntityData.m_135353_(AbstractCannonShip.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> LEFT_CANNON = SynchedEntityData.m_135353_(AbstractCannonShip.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT_CANNON = SynchedEntityData.m_135353_(AbstractCannonShip.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LEFT_SHOOT_COOLDOWN = SynchedEntityData.m_135353_(AbstractCannonShip.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RIGHT_SHOOT_COOLDOWN = SynchedEntityData.m_135353_(AbstractCannonShip.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public AbstractCannonShip(EntityType<? extends AbstractCannonShip> type, Level world) {
        super((EntityType<? extends AbstractShipDamage>)type, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RIGHT_CANNON_COUNT, (Object)0);
        this.f_19804_.m_135372_(LEFT_CANNON_COUNT, (Object)0);
        this.f_19804_.m_135372_(RIGHT_CANNON, (Object)false);
        this.f_19804_.m_135372_(LEFT_CANNON, (Object)false);
        this.f_19804_.m_135372_(LEFT_SHOOT_COOLDOWN, (Object)30);
        this.f_19804_.m_135372_(RIGHT_SHOOT_COOLDOWN, (Object)30);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.updateCountdown();
        if (this.getDriver() != null) {
            // empty if block
        }
    }

    private void updateCountdown() {
        if (this.getRightShootCoolDown() >= 0) {
            this.setRightShootCoolDown(this.getRightShootCoolDown() - 1);
        }
        if (this.getLeftShootCoolDown() >= 0) {
            this.setLeftShootCoolDown(this.getLeftShootCoolDown() - 1);
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("RightCannonCount", this.getRightCannonCount());
        nbt.m_128405_("LeftCannonCount", this.getLeftCannonCount());
        nbt.m_128405_("LeftShootCoolDown", this.getLeftShootCoolDown());
        nbt.m_128405_("RightShootCoolDown", this.getRightShootCoolDown());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setRightCannonCount(nbt.m_128451_("RightCannonCount"));
        this.setLeftCannonCount(nbt.m_128451_("LeftCannonCount"));
        this.setRightShootCoolDown(nbt.m_128451_("RightShootCoolDown"));
        this.setLeftShootCoolDown(nbt.m_128451_("LeftShootCoolDown"));
    }

    public abstract int getMaxCannons();

    public int getTotalCannonCount() {
        return this.getRightCannonCount() + this.getLeftCannonCount();
    }

    public int getRightShootCoolDown() {
        return (Integer)this.f_19804_.m_135370_(RIGHT_SHOOT_COOLDOWN);
    }

    public int getLeftShootCoolDown() {
        return (Integer)this.f_19804_.m_135370_(LEFT_SHOOT_COOLDOWN);
    }

    public int getRightCannonCount() {
        return (Integer)this.f_19804_.m_135370_(RIGHT_CANNON_COUNT);
    }

    public int getLeftCannonCount() {
        return (Integer)this.f_19804_.m_135370_(LEFT_CANNON_COUNT);
    }

    public boolean getRightCannon() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT_CANNON);
    }

    public boolean getLeftCannon() {
        return (Boolean)this.f_19804_.m_135370_(LEFT_CANNON);
    }

    public boolean canShoot() {
        return this.hasGunPowder() && this.hasCannonBall();
    }

    public boolean hasGunPowder() {
        SimpleContainer inventory = this.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41720_() != Items.f_42403_) continue;
            return true;
        }
        return false;
    }

    public boolean hasCannonBall() {
        SimpleContainer inventory = this.getInventory();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41720_() != ModItems.CANNONBALL.get()) continue;
            return true;
        }
        return false;
    }

    public void setRightCannonCount(int count) {
        this.f_19804_.m_135381_(RIGHT_CANNON_COUNT, (Object)count);
    }

    public void setLeftCannonCount(int count) {
        this.f_19804_.m_135381_(LEFT_CANNON_COUNT, (Object)count);
    }

    public void setRightShootCoolDown(int i) {
        this.f_19804_.m_135381_(RIGHT_SHOOT_COOLDOWN, (Object)i);
    }

    public void setLeftShootCoolDown(int i) {
        this.f_19804_.m_135381_(LEFT_SHOOT_COOLDOWN, (Object)i);
    }

    @Override
    public void onCannonKeyPressed() {
        if (this.getLeftShootCoolDown() <= 0 || this.getRightShootCoolDown() <= 0) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageShootCannon(true));
        }
    }

    public Vec3 getShootVector() {
        Vec3 forward = this.m_20156_().m_82541_();
        Vec3 VecRight = forward.m_82524_(-1.57f).m_82541_();
        Vec3 VecLeft = forward.m_82524_(1.57f).m_82541_();
        Vec3 playerVec = this.getDriver().m_20154_().m_82541_();
        if (playerVec.m_82554_(VecLeft) > playerVec.m_82554_(VecRight)) {
            return VecRight;
        }
        if (playerVec.m_82554_(VecLeft) < playerVec.m_82554_(VecRight)) {
            return VecLeft;
        }
        return null;
    }

    public void startCannons(boolean a) {
        if (this.getTotalCannonCount() >= 1) {
            this.shootCannons();
        }
    }

    public void shootCannons() {
        Vec3 shootVector = this.getShootVector();
        Vec3 forward = this.m_20156_();
        Vec3 VecRight = forward.m_82524_(-1.57f).m_82541_();
        Vec3 VecLeft = forward.m_82524_(1.57f).m_82541_();
        boolean shoot = false;
        float x0 = 0.0f;
        int cannonCount = 0;
        if (shootVector == null) {
            return;
        }
        if (shootVector.m_82554_(VecLeft) > shootVector.m_82554_(VecRight) && this.getRightShootCoolDown() <= 0) {
            this.setRightShootCoolDown(60);
            x0 = -1.0f;
            cannonCount = this.getRightCannonCount();
            shoot = true;
        }
        if (shootVector.m_82554_(VecLeft) < shootVector.m_82554_(VecRight) && this.getLeftShootCoolDown() <= 0) {
            this.setLeftShootCoolDown(60);
            x0 = 1.0f;
            cannonCount = this.getLeftCannonCount();
            shoot = true;
        }
        if (shoot) {
            float speed = 2.5f;
            float k = 2.0f;
            boolean playerView = this.getDriver().m_20154_().f_82480_ >= 0.0;
            double yShootVec = playerView ? shootVector.m_7098_() + this.getDriver().m_20154_().f_82480_ * 0.75 : shootVector.m_7098_() + 0.25;
            float f2 = 0.0f;
            for (int i = 0; i < cannonCount; ++i) {
                switch (i) {
                    case 0: {
                        f2 = 0.2f;
                        break;
                    }
                    case 1: {
                        f2 = -1.4f;
                        break;
                    }
                    case 2: {
                        f2 = -3.8f;
                    }
                }
                if (!this.canShoot()) continue;
                this.shootCannon(forward, shootVector, yShootVec, speed, f2, k, x0);
            }
        }
    }

    public void shootCannon(Vec3 forward, Vec3 shootVector, double yShootVec, float speed, float f2, float k, float x0) {
        float f0 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * x0;
        float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * x0;
        double d1 = this.m_20185_() - forward.f_82479_ * (double)f2 + (double)f0;
        double d2 = this.m_20186_() - forward.f_82480_ + 1.0;
        double d3 = this.m_20189_() - forward.f_82481_ * (double)f2 + (double)f1;
        CannonBallEntity cannonBallEntity = new CannonBallEntity(this.f_19853_, (LivingEntity)this.getDriver(), d1, d2, d3);
        cannonBallEntity.m_6686_(shootVector.m_7096_(), yShootVec, shootVector.m_7094_(), speed, k);
        this.f_19853_.m_7967_((Entity)cannonBallEntity);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), SoundEvents.f_12512_, this.m_5720_(), 10.0f, 0.8f + 0.4f * this.f_19796_.nextFloat());
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), (SoundEvent)SoundInit.CANNON_SHOOT.get(), this.m_5720_(), 10.0f, 0.8f + 0.4f * this.f_19796_.nextFloat());
        this.handleItemsOnShoot();
    }

    public void handleItemsOnShoot() {
        SimpleContainer inventory = this.getInventory();
        boolean cannonball = false;
        boolean gunpowder = false;
        Item gunpowderItem = Items.f_42403_;
        Item cannonballItem = (Item)ModItems.CANNONBALL.get();
        this.shrinkItemInInv(inventory, gunpowderItem, 1);
        this.shrinkItemInInv(inventory, cannonballItem, 1);
    }

    public void renderCannon(double Zoffset, double height, float angle, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        double offset;
        int i;
        if (this.getLeftCannonCount() != 0) {
            for (i = 0; i < this.getLeftCannonCount(); ++i) {
                offset = switch (i) {
                    case 0 -> 1.0;
                    case 1 -> -0.2;
                    case 2 -> -1.5;
                    default -> 0.0;
                };
                RenderCannon.renderCannon(Zoffset, offset, height, angle, this, partialTicks, matrixStack, buffer, packedLight);
            }
        }
        if (this.getRightCannonCount() != 0) {
            for (i = 0; i < this.getRightCannonCount(); ++i) {
                offset = switch (i) {
                    case 0 -> -1.0;
                    case 1 -> 0.2;
                    case 2 -> 1.5;
                    default -> 0.0;
                };
                RenderCannon.renderCannon(Zoffset, offset, height, angle + 180.0f, this, partialTicks, matrixStack, buffer, packedLight);
            }
        }
    }

    public void onInteractionWithCannon(Player player, ItemStack itemStack) {
        if (this.getRightCannonCount() + this.getLeftCannonCount() != this.getMaxCannons()) {
            if (this.getRightCannonCount() == this.getLeftCannonCount()) {
                this.setRightCannonCount(this.getRightCannonCount() + 1);
            } else {
                this.setLeftCannonCount(this.getLeftCannonCount() + 1);
            }
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
        }
    }

    public void shrinkItemInInv(SimpleContainer inventory, Item item, int count) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStackInSlot = inventory.m_8020_(i);
            Item itemInSlot = itemStackInSlot.m_41720_();
            if (itemInSlot != item) continue;
            itemStackInSlot.m_41774_(count);
            break;
        }
    }
}

