/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.talhanation.smallships.client.render.RenderBanner;
import com.talhanation.smallships.entities.AbstractInventoryEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractBannerUser
extends AbstractInventoryEntity {
    private static final EntityDataAccessor<Boolean> HAS_BANNER = SynchedEntityData.m_135353_(AbstractBannerUser.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<ItemStack> BANNER = SynchedEntityData.m_135353_(AbstractBannerUser.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private float bannerWaveAngle;
    private float prevBannerWaveAngle;

    public AbstractBannerUser(EntityType<? extends AbstractBannerUser> type, Level world) {
        super((EntityType<? extends AbstractInventoryEntity>)type, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_BANNER, (Object)false);
        this.f_19804_.m_135372_(BANNER, (Object)Items.f_42660_.m_7968_());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getHasBanner()) {
            this.prevBannerWaveAngle = this.bannerWaveAngle;
            this.bannerWaveAngle = (float)Math.sin(this.getBannerWaveSpeed() * (float)this.f_19797_) * this.getBannerWaveFactor();
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("banner", (Tag)this.getBanner().serializeNBT());
        nbt.m_128379_("hasbanner", this.getHasBanner());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        Tag banner;
        super.m_7378_(nbt);
        if (nbt.m_128441_("hasbanner")) {
            this.setHasBanner(nbt.m_128471_("hasbanner"));
        }
        if ((banner = nbt.m_128423_("banner")) instanceof CompoundTag) {
            this.f_19804_.m_135381_(BANNER, (Object)ItemStack.m_41712_((CompoundTag)((CompoundTag)banner)));
        }
    }

    @Override
    public boolean getHasBanner() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BANNER);
    }

    public ItemStack getBanner() {
        return (ItemStack)this.f_19804_.m_135370_(BANNER);
    }

    public float getBannerWaveFactor() {
        return this.f_19853_.m_46471_() ? 4.5f : 3.0f;
    }

    public float getBannerWaveSpeed() {
        return this.f_19853_.m_46471_() ? 0.55f : 0.25f;
    }

    public float getBannerWaveAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevBannerWaveAngle, (float)this.bannerWaveAngle);
    }

    public void setBanner(Player player, ItemStack banner) {
        this.playBannerSound();
        this.setHasBanner(true);
        this.f_19804_.m_135381_(BANNER, (Object)banner.m_41777_());
        if (!player.m_7500_()) {
            banner.m_41774_(1);
        }
    }

    public void setHasBanner(boolean bool) {
        this.f_19804_.m_135381_(HAS_BANNER, (Object)bool);
    }

    public void playBannerSound() {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), SoundEvents.f_12641_, this.m_5720_(), 15.0f, 0.8f + 0.4f * this.f_19796_.nextFloat());
    }

    @Override
    public boolean onInteractionWithBanner(ItemStack banner, Player player) {
        if (this.getHasBanner()) {
            this.dropBanner();
        }
        this.setBanner(player, banner);
        return true;
    }

    @Override
    public void onInteractionWithShears(Player playerEntity) {
        if (this.getHasBanner()) {
            this.dropBanner();
            this.setHasBanner(false);
        }
    }

    public void renderBanner(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        if (this.getHasBanner()) {
            RenderBanner.renderBanner(this, partialTicks, matrixStack, buffer, this.getBanner(), packedLight, BannerRenderer.m_173522_().m_171564_());
        }
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void dropBanner() {
        if (this.getHasBanner()) {
            this.getBanner().m_41764_(1);
            this.m_5552_(this.getBanner(), 3.0f);
        }
    }
}

