/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.talhanation.smallships.client.model.ModelCog;
import com.talhanation.smallships.client.model.ModelCogSail;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.entities.CogEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RenderEntityCog
extends EntityRenderer<CogEntity> {
    private static final ResourceLocation[] COG_TEXTURES = new ResourceLocation[]{new ResourceLocation("smallships", "textures/entity/cog/oak_cog.png"), new ResourceLocation("smallships", "textures/entity/cog/spruce_cog.png"), new ResourceLocation("smallships", "textures/entity/cog/birch_cog.png"), new ResourceLocation("smallships", "textures/entity/cog/jungle_cog.png"), new ResourceLocation("smallships", "textures/entity/cog/acacia_cog.png"), new ResourceLocation("smallships", "textures/entity/cog/dark_oak_cog.png")};
    private final ModelCog model = new ModelCog();

    public RenderEntityCog(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 1.5f;
    }

    public void render(CogEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float waveAngle;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 0.4, 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        if (((Boolean)SmallShipsConfig.MakeWaveAnimation.get()).booleanValue() && !Mth.m_14033_((float)(waveAngle = entityIn.getWaveAngle(partialTicks)), (float)0.0f)) {
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(waveAngle));
        }
        matrixStackIn.m_85841_(-1.3f, -1.3f, 1.3f);
        matrixStackIn.m_85837_(0.0, -1.8, -1.0);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        this.model.setupAnim(entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = bufferIn.m_6299_(this.model.m_103119_(this.getTextureLocation(entityIn)));
        this.model.m_7695_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        entityIn.renderBanner(matrixStackIn, bufferIn, packedLightIn, partialTicks);
        entityIn.renderSailColor(matrixStackIn, bufferIn, packedLightIn, partialTicks, new ModelCogSail());
        entityIn.renderCannon(-0.65, 0.03, 0.0f, matrixStackIn, bufferIn, packedLightIn, partialTicks);
        matrixStackIn.m_85849_();
    }

    public ResourceLocation getTextureLocation(CogEntity entity) {
        return COG_TEXTURES[entity.getWoodType().ordinal()];
    }
}

