/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.talhanation.smallships.client.model.ModelBrigg;
import com.talhanation.smallships.client.model.ModelBriggSail;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.entities.BriggEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RenderEntityBrigg
extends EntityRenderer<BriggEntity> {
    private static final ResourceLocation[] COG_TEXTURES = new ResourceLocation[]{new ResourceLocation("smallships", "textures/entity/cog/oak_cog.png"), new ResourceLocation("smallships", "textures/entity/cog/spruce_cog.png"), new ResourceLocation("smallships", "textures/entity/cog/birch_cog.png"), new ResourceLocation("smallships", "textures/entity/cog/jungle_cog.png"), new ResourceLocation("smallships", "textures/entity/cog/acacia_cog.png"), new ResourceLocation("smallships", "textures/entity/cog/dark_oak_cog.png")};
    private final ModelBrigg model = new ModelBrigg();

    public RenderEntityBrigg(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 1.5f;
    }

    public void render(BriggEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        float waveAngle;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, -0.25, 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        if (((Boolean)SmallShipsConfig.MakeWaveAnimation.get()).booleanValue() && !Mth.m_14033_((float)(waveAngle = entityIn.getWaveAngle(partialTicks)), (float)0.0f)) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(waveAngle));
        }
        poseStack.m_85841_(-1.3f, -1.3f, 1.3f);
        poseStack.m_85837_(0.0, -1.8, -1.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
        this.model.setupAnim(entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(this.model.m_103119_(this.getTextureLocation(entityIn)));
        this.model.m_7695_(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        entityIn.renderBanner(poseStack, bufferIn, packedLightIn, partialTicks);
        entityIn.renderSailColor(poseStack, bufferIn, packedLightIn, partialTicks, new ModelBriggSail());
        entityIn.renderCannon(-0.75, -0.55, -90.0f, poseStack, bufferIn, packedLightIn, partialTicks);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(BriggEntity entity) {
        return COG_TEXTURES[entity.getWoodType().ordinal()];
    }
}

