/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.events;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.entities.AbstractSailShip;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    private static final ResourceLocation SHIP_INFO_TEXTURE = new ResourceLocation("smallships", "textures/gui/ship_info.png");
    private final Minecraft mc = Minecraft.m_91087_();
    private AbstractSailShip lastVehicle;

    @SubscribeEvent
    public void onRender(EntityViewRenderEvent.CameraSetup evt) {
        if (this.getShip() != null && !this.mc.f_91066_.m_92176_().m_90612_()) {
            evt.getCamera().m_90568_(-evt.getCamera().m_90566_((Double)SmallShipsConfig.ShipZoom.get() - 4.0), 0.0, 0.0);
        }
    }

    @SubscribeEvent
    public void onRender(InputEvent.MouseScrollEvent evt) {
        if (this.getShip() != null && !this.mc.f_91066_.m_92176_().m_90612_()) {
            SmallShipsConfig.ShipZoom.set((Object)Math.max(1.0, Math.min(20.0, (Double)SmallShipsConfig.ShipZoom.get() - evt.getScrollDelta())));
            SmallShipsConfig.ShipZoom.save();
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side.equals((Object)LogicalSide.SERVER)) {
            return;
        }
        if (!evt.player.equals((Object)this.mc.f_91074_)) {
            return;
        }
        AbstractSailShip vehicle = this.getShip();
        if (vehicle != null && this.lastVehicle == null) {
            this.setThirdPerson(true);
        } else if (vehicle == null && this.lastVehicle != null) {
            this.setThirdPerson(false);
        }
        this.lastVehicle = vehicle;
    }

    private void setThirdPerson(boolean third) {
        if (!((Boolean)SmallShipsConfig.EnterThirdPerson.get()).booleanValue()) {
            return;
        }
        if (third) {
            this.mc.f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
        } else {
            this.mc.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
    }

    private AbstractSailShip getShip() {
        Entity e = this.mc.f_91074_.m_20202_();
        if (e instanceof AbstractSailShip) {
            return (AbstractSailShip)e;
        }
        return null;
    }
}

