/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships;

import com.talhanation.smallships.client.events.ClientRenderEvent;
import com.talhanation.smallships.client.events.KeyEvents;
import com.talhanation.smallships.client.events.PlayerEvents;
import com.talhanation.smallships.client.events.RenderEvents;
import com.talhanation.smallships.client.gui.BasicShipInvScreen;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.entities.AbstractShipDamage;
import com.talhanation.smallships.init.ModEntityTypes;
import com.talhanation.smallships.init.ModItems;
import com.talhanation.smallships.init.SoundInit;
import com.talhanation.smallships.inventory.BasicShipContainer;
import com.talhanation.smallships.network.MessageControlShip;
import com.talhanation.smallships.network.MessageOpenGui;
import com.talhanation.smallships.network.MessageSailState;
import com.talhanation.smallships.network.MessageShootCannon;
import de.maxhenkel.smallships.corelib.ClientRegistry;
import de.maxhenkel.smallships.corelib.CommonRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="smallships")
public class Main {
    public static final String MOD_ID = "smallships";
    public static SimpleChannel SIMPLE_CHANNEL;
    public static final Logger LOGGER;
    public static KeyMapping SAIL_KEY;
    public static KeyMapping SAIL_L_KEY;
    public static KeyMapping SAIL_H_KEY;
    public static KeyMapping INV_KEY;
    public static KeyMapping CANNON_KEY;
    public static KeyMapping FORWARD_KEY;
    public static KeyMapping BACK_KEY;
    public static KeyMapping LEFT_KEY;
    public static KeyMapping RIGHT_KEY;
    public static MenuType<BasicShipContainer> BASIC_SHIP_CONTAINER_TYPE;

    public Main() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SmallShipsConfig.CONFIG);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addGenericListener(MenuType.class, this::registerContainers);
        SoundInit.SOUNDS.register(modEventBus);
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MOD_ID, "default"), () -> "1.0.0", s -> true, s -> true);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 0, MessageControlShip.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 1, MessageOpenGui.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 2, MessageSailState.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 3, MessageShootCannon.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 4, MessageOpenGui.class);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        FORWARD_KEY = ClientRegistry.registerKeyBinding("key.ship_forward", "category.smallships", 87);
        BACK_KEY = ClientRegistry.registerKeyBinding("key.ship_back", "category.smallships", 83);
        LEFT_KEY = ClientRegistry.registerKeyBinding("key.ship_left", "category.smallships", 65);
        RIGHT_KEY = ClientRegistry.registerKeyBinding("key.ship_right", "category.smallships", 68);
        SAIL_KEY = ClientRegistry.registerKeyBinding("key.ship_sail", "category.smallships", 82);
        INV_KEY = ClientRegistry.registerKeyBinding("key.ship_inventory", "category.smallships", 73);
        SAIL_L_KEY = ClientRegistry.registerKeyBinding("key.lower_ship_sail", "category.smallships", 74);
        SAIL_H_KEY = ClientRegistry.registerKeyBinding("key.higher_ship_sail", "category.smallships", 75);
        CANNON_KEY = ClientRegistry.registerKeyBinding("key.cannon_shoot", "category.smallships", 32);
        ClientRegistry.registerScreen(BASIC_SHIP_CONTAINER_TYPE, BasicShipInvScreen::new);
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
        ClientRenderEvent.register();
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
        BASIC_SHIP_CONTAINER_TYPE = new MenuType((MenuType.MenuSupplier)((IContainerFactory)(windowId, inv, data) -> {
            AbstractShipDamage ship = Main.getInvEntityByUUID(inv.f_35978_, data.m_130259_());
            if (ship == null) {
                return null;
            }
            return new BasicShipContainer(windowId, ship, inv, 0);
        }));
        BASIC_SHIP_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MOD_ID, "basic_container"));
        event.getRegistry().register(BASIC_SHIP_CONTAINER_TYPE);
    }

    @Nullable
    public static AbstractShipDamage getInvEntityByUUID(Player player, UUID uuid) {
        double distance = 10.0;
        return player.f_19853_.m_6443_(AbstractShipDamage.class, new AABB(player.m_20185_() - distance, player.m_20186_() - distance, player.m_20189_() - distance, player.m_20185_() + distance, player.m_20186_() + distance, player.m_20189_() + distance), entity -> entity.m_142081_().equals(uuid)).stream().findAny().orElse(null);
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_ID);
    }
}

