/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.repack.bml.utils.text;

import com.black_dog20.servertabinfo.repack.bml.utils.translate.ITranslation;
import java.util.function.Supplier;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;

public class TextComponentBuilder {
    private TextComponent root = new StringTextComponent("");
    private TextComponent prev;

    private TextComponentBuilder() {
    }

    public static TextComponentBuilder of(ITextComponent component) {
        TextComponentBuilder builder = new TextComponentBuilder();
        return builder.with((ITextComponent)((TextComponent)component.func_230532_e_()));
    }

    public static TextComponentBuilder of(String text) {
        return TextComponentBuilder.of((ITextComponent)new StringTextComponent(text));
    }

    public static TextComponentBuilder of(int integer) {
        return TextComponentBuilder.of(Integer.toString(integer));
    }

    public static TextComponentBuilder of(ITranslation translation) {
        return TextComponentBuilder.of(translation.get());
    }

    public TextComponentBuilder with(ITextComponent component) {
        if (this.prev != null) {
            this.root.func_230529_a_((ITextComponent)this.prev);
        }
        this.prev = (TextComponent)component.func_230532_e_();
        return this;
    }

    public TextComponentBuilder with(String text) {
        return this.with((ITextComponent)new StringTextComponent(text));
    }

    public TextComponentBuilder with(int integer) {
        return this.with(Integer.toString(integer));
    }

    public TextComponentBuilder with(ITranslation translation) {
        return this.with((ITextComponent)((TextComponent)translation.get()));
    }

    public TextComponentBuilder space() {
        return this.with((ITextComponent)new StringTextComponent(" "));
    }

    public TextComponentBuilder format(TextFormatting formatting) {
        if (this.prev != null) {
            this.prev.func_230530_a_(this.prev.func_150256_b().func_240712_a_(formatting));
        }
        return this;
    }

    public TextComponent build() {
        if (this.prev != null) {
            this.root.func_230529_a_((ITextComponent)this.prev);
        }
        return this.root;
    }

    public TextComponentBuilder with(ITextComponent component, Supplier<Boolean> supplier) {
        if (Boolean.TRUE.equals(supplier.get())) {
            return this.with(component);
        }
        return this;
    }

    public TextComponentBuilder with(ITextComponent componentTrue, ITextComponent componentFalse, Supplier<Boolean> supplier) {
        if (Boolean.TRUE.equals(supplier.get())) {
            return this.with(componentTrue);
        }
        return this.with(componentFalse);
    }

    public TextComponentBuilder with(String text, Supplier<Boolean> supplier) {
        if (Boolean.TRUE.equals(supplier.get())) {
            return this.with(text);
        }
        return this;
    }

    public TextComponentBuilder with(String textTrue, String textFalse, Supplier<Boolean> supplier) {
        if (Boolean.TRUE.equals(supplier.get())) {
            return this.with(textTrue);
        }
        return this.with(textFalse);
    }

    public TextComponentBuilder with(int integer, Supplier<Boolean> supplier) {
        if (Boolean.TRUE.equals(supplier.get())) {
            return this.with(integer);
        }
        return this;
    }

    public TextComponentBuilder with(int integerTrue, int integerFalse, Supplier<Boolean> supplier) {
        if (Boolean.TRUE.equals(supplier.get())) {
            return this.with(integerTrue);
        }
        return this.with(integerFalse);
    }

    public TextComponentBuilder with(ITranslation translation, Supplier<Boolean> supplier) {
        if (Boolean.TRUE.equals(supplier.get())) {
            return this.with(translation);
        }
        return this;
    }

    public TextComponentBuilder with(ITranslation translationTrue, ITranslation translationFalse, Supplier<Boolean> supplier) {
        if (Boolean.TRUE.equals(supplier.get())) {
            return this.with((ITextComponent)((TextComponent)translationTrue.get()));
        }
        return this.with((ITextComponent)((TextComponent)translationFalse.get()));
    }

    public TextComponentBuilder space(Supplier<Boolean> supplier) {
        if (supplier.get().booleanValue()) {
            return this.with((ITextComponent)new StringTextComponent(" "));
        }
        return this;
    }
}

