/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.common.network;

import com.black_dog20.servertabinfo.client.ClientDataManager;
import com.black_dog20.servertabinfo.common.network.packets.PacketDimensions;
import com.black_dog20.servertabinfo.common.network.packets.PacketPlayers;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static short index = 0;
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("servertabinfo", "network")).clientAcceptedVersions(PacketHandler::checkRemoteVersion).serverAcceptedVersions(PacketHandler::checkClientVersion).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();

    public static void register() {
        PacketHandler.registerMessage(PacketDimensions.class, PacketDimensions::encode, PacketDimensions::decode, PacketDimensions.Handler::handle);
        PacketHandler.registerMessage(PacketPlayers.class, PacketPlayers::encode, PacketPlayers::decode, PacketPlayers.Handler::handle);
    }

    public static void sendTo(Object msg, ServerPlayerEntity player) {
        if (!(player instanceof FakePlayer)) {
            NETWORK.sendTo(msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendToAll(Object msg, World world) {
        for (PlayerEntity player : world.func_217369_A()) {
            if (player instanceof FakePlayer) continue;
            NETWORK.sendTo(msg, ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendToAll(Object msg) {
        NETWORK.send(PacketDistributor.ALL.noArg(), msg);
    }

    public static void sendToServer(Object msg) {
        NETWORK.sendToServer(msg);
    }

    private static <MSG> void registerMessage(Class<MSG> messageType, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        NETWORK.registerMessage((int)index, messageType, encoder, decoder, messageConsumer);
        index = (short)(index + 1);
        if (index > 255) {
            throw new RuntimeException("Too many messages!");
        }
    }

    private static boolean checkRemoteVersion(String s) {
        ClientDataManager.modOnServer = !s.equals(NetworkRegistry.ABSENT);
        return true;
    }

    private static boolean checkClientVersion(String s) {
        return true;
    }
}

