/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.misc.test;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class WaterTest {
    private static final float MAX_FLUID_HEIGHT = 0.8888889f;
    private final TextureAtlasSprite[] lavaIcons = new TextureAtlasSprite[2];
    private final TextureAtlasSprite[] waterIcons = new TextureAtlasSprite[2];
    private TextureAtlasSprite waterOverlay;

    protected void setupSprites() {
        this.lavaIcons[0] = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(Blocks.f_49991_.m_49966_()).m_6160_();
        this.lavaIcons[1] = ModelBakery.f_119221_.m_119204_();
        this.waterIcons[0] = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(Blocks.f_49990_.m_49966_()).m_6160_();
        this.waterIcons[1] = ModelBakery.f_119222_.m_119204_();
        this.waterOverlay = ModelBakery.f_119223_.m_119204_();
    }

    private static boolean isNeighborSameFluid(BlockGetter p_110974_, BlockPos p_110975_, Direction p_110976_, FluidState p_110977_) {
        BlockPos blockpos = p_110975_.m_142300_(p_110976_);
        FluidState fluidstate = p_110974_.m_6425_(blockpos);
        return fluidstate.m_76152_().m_6212_(p_110977_.m_76152_());
    }

    private static boolean isFaceOccludedByState(BlockGetter p_110979_, Direction p_110980_, float p_110981_, BlockPos p_110982_, BlockState p_110983_) {
        if (p_110983_.m_60815_()) {
            VoxelShape voxelshape = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)p_110981_, (double)1.0);
            VoxelShape voxelshape1 = p_110983_.m_60768_(p_110979_, p_110982_);
            return Shapes.m_83117_((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (Direction)p_110980_);
        }
        return false;
    }

    private static boolean isFaceOccludedByNeighbor(BlockGetter p_110969_, BlockPos p_110970_, Direction p_110971_, float p_110972_) {
        BlockPos blockpos = p_110970_.m_142300_(p_110971_);
        BlockState blockstate = p_110969_.m_8055_(blockpos);
        return WaterTest.isFaceOccludedByState(p_110969_, p_110971_, p_110972_, blockpos, blockstate);
    }

    private static boolean isFaceOccludedBySelf(BlockGetter p_110960_, BlockPos p_110961_, BlockState p_110962_, Direction p_110963_) {
        return WaterTest.isFaceOccludedByState(p_110960_, p_110963_.m_122424_(), 1.0f, p_110961_, p_110962_);
    }

    public static boolean shouldRenderFace(BlockAndTintGetter p_110949_, BlockPos p_110950_, FluidState p_110951_, BlockState p_110952_, Direction p_110953_) {
        return !WaterTest.isFaceOccludedBySelf((BlockGetter)p_110949_, p_110950_, p_110952_, p_110953_) && !WaterTest.isNeighborSameFluid((BlockGetter)p_110949_, p_110950_, p_110953_, p_110951_);
    }

    public boolean tesselate(BlockAndTintGetter tintGetter, BlockPos pos, VertexConsumer vertexConsumer, FluidState fluidState) {
        float minY;
        TextureAtlasSprite[] sprites = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)tintGetter, (BlockPos)pos, (FluidState)fluidState);
        BlockState blockstate = tintGetter.m_8055_(pos);
        int color = fluidState.m_76152_().getAttributes().getColor(tintGetter, pos);
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        boolean renderUp = !WaterTest.isNeighborSameFluid((BlockGetter)tintGetter, pos, Direction.UP, fluidState);
        boolean renderDown = WaterTest.shouldRenderFace(tintGetter, pos, fluidState, blockstate, Direction.DOWN) && !WaterTest.isFaceOccludedByNeighbor((BlockGetter)tintGetter, pos, Direction.DOWN, 0.8888889f);
        boolean renderNorth = WaterTest.shouldRenderFace(tintGetter, pos, fluidState, blockstate, Direction.NORTH);
        boolean renderSouth = WaterTest.shouldRenderFace(tintGetter, pos, fluidState, blockstate, Direction.SOUTH);
        boolean renderWest = WaterTest.shouldRenderFace(tintGetter, pos, fluidState, blockstate, Direction.WEST);
        boolean renderEast = WaterTest.shouldRenderFace(tintGetter, pos, fluidState, blockstate, Direction.EAST);
        if (!(renderUp || renderDown || renderEast || renderWest || renderNorth || renderSouth)) {
            return false;
        }
        boolean flag7 = false;
        float shadeDown = tintGetter.m_7717_(Direction.DOWN, true);
        float shadeUp = tintGetter.m_7717_(Direction.UP, true);
        float shadeNorth = tintGetter.m_7717_(Direction.NORTH, true);
        float shadeWest = tintGetter.m_7717_(Direction.WEST, true);
        float myHeight = this.getWaterHeight((BlockGetter)tintGetter, pos, fluidState.m_76152_());
        float southHeight = this.getWaterHeight((BlockGetter)tintGetter, pos.m_142128_(), fluidState.m_76152_());
        float cornerHeight = this.getWaterHeight((BlockGetter)tintGetter, pos.m_142126_().m_142128_(), fluidState.m_76152_());
        float eastHeight = this.getWaterHeight((BlockGetter)tintGetter, pos.m_142126_(), fluidState.m_76152_());
        double chunkX = pos.m_123341_() & 0xF;
        double chunkY = pos.m_123342_() & 0xF;
        double chunkZ = pos.m_123343_() & 0xF;
        float f = minY = renderDown ? 0.001f : 0.0f;
        if (renderUp && !WaterTest.isFaceOccludedByNeighbor((BlockGetter)tintGetter, pos, Direction.UP, Math.min(Math.min(myHeight, southHeight), Math.min(cornerHeight, eastHeight)))) {
            float maxU2;
            float maxV2;
            float maxU;
            float maxV;
            float minV2;
            float minU2;
            float minV;
            float minU;
            flag7 = true;
            myHeight -= 0.001f;
            southHeight -= 0.001f;
            cornerHeight -= 0.001f;
            eastHeight -= 0.001f;
            Vec3 flow = fluidState.m_76179_((BlockGetter)tintGetter, pos);
            if (flow.f_82479_ == 0.0 && flow.f_82481_ == 0.0) {
                TextureAtlasSprite stillTexture = sprites[0];
                minU = stillTexture.m_118367_(0.0);
                minV = stillTexture.m_118393_(0.0);
                minU2 = minU;
                minV2 = minV;
                maxV = stillTexture.m_118393_(16.0);
                maxU = stillTexture.m_118367_(16.0);
                maxV2 = maxV;
                maxU2 = maxU;
            } else {
                TextureAtlasSprite textureatlassprite = sprites[1];
                float f21 = (float)Mth.m_14136_((double)flow.f_82481_, (double)flow.f_82479_) - 1.5707964f;
                float f22 = Mth.m_14031_((float)f21) * 0.25f;
                float f23 = Mth.m_14089_((float)f21) * 0.25f;
                float f24 = 8.0f;
                minU = textureatlassprite.m_118367_((double)(8.0f + (-f23 - f22) * 16.0f));
                minV = textureatlassprite.m_118393_((double)(8.0f + (-f23 + f22) * 16.0f));
                minU2 = textureatlassprite.m_118367_((double)(8.0f + (-f23 + f22) * 16.0f));
                maxV = textureatlassprite.m_118393_((double)(8.0f + (f23 + f22) * 16.0f));
                maxU = textureatlassprite.m_118367_((double)(8.0f + (f23 + f22) * 16.0f));
                maxV2 = textureatlassprite.m_118393_((double)(8.0f + (f23 - f22) * 16.0f));
                maxU2 = textureatlassprite.m_118367_((double)(8.0f + (f23 - f22) * 16.0f));
                minV2 = textureatlassprite.m_118393_((double)(8.0f + (-f23 - f22) * 16.0f));
            }
            float textW = (minU + minU2 + maxU + maxU2) / 4.0f;
            float textH = (minV + maxV + maxV2 + minV2) / 4.0f;
            float f46 = (float)sprites[0].m_118405_() / (sprites[0].m_118410_() - sprites[0].m_118409_());
            float f47 = (float)sprites[0].m_118408_() / (sprites[0].m_118412_() - sprites[0].m_118411_());
            float f48 = 4.0f / Math.max(f47, f46);
            minU = Mth.m_14179_((float)f48, (float)minU, (float)textW);
            minU2 = Mth.m_14179_((float)f48, (float)minU2, (float)textW);
            maxU = Mth.m_14179_((float)f48, (float)maxU, (float)textW);
            maxU2 = Mth.m_14179_((float)f48, (float)maxU2, (float)textW);
            minV = Mth.m_14179_((float)f48, (float)minV, (float)textH);
            maxV = Mth.m_14179_((float)f48, (float)maxV, (float)textH);
            maxV2 = Mth.m_14179_((float)f48, (float)maxV2, (float)textH);
            minV2 = Mth.m_14179_((float)f48, (float)minV2, (float)textH);
            int j = this.getLightColor(tintGetter, pos);
            float f25 = shadeUp * red;
            float f26 = shadeUp * green;
            float f27 = shadeUp * blue;
            this.vertex(vertexConsumer, chunkX + 0.0, chunkY + (double)myHeight, chunkZ + 0.0, f25, f26, f27, alpha, minU, minV, j);
            this.vertex(vertexConsumer, chunkX + 0.0, chunkY + (double)southHeight, chunkZ + 1.0, f25, f26, f27, alpha, minU2, maxV, j);
            this.vertex(vertexConsumer, chunkX + 1.0, chunkY + (double)cornerHeight, chunkZ + 1.0, f25, f26, f27, alpha, maxU, maxV2, j);
            this.vertex(vertexConsumer, chunkX + 1.0, chunkY + (double)eastHeight, chunkZ + 0.0, f25, f26, f27, alpha, maxU2, minV2, j);
            if (fluidState.m_76171_((BlockGetter)tintGetter, pos.m_7494_())) {
                this.vertex(vertexConsumer, chunkX + 0.0, chunkY + (double)myHeight, chunkZ + 0.0, f25, f26, f27, alpha, minU, minV, j);
                this.vertex(vertexConsumer, chunkX + 1.0, chunkY + (double)eastHeight, chunkZ + 0.0, f25, f26, f27, alpha, maxU2, minV2, j);
                this.vertex(vertexConsumer, chunkX + 1.0, chunkY + (double)cornerHeight, chunkZ + 1.0, f25, f26, f27, alpha, maxU, maxV2, j);
                this.vertex(vertexConsumer, chunkX + 0.0, chunkY + (double)southHeight, chunkZ + 1.0, f25, f26, f27, alpha, minU2, maxV, j);
            }
        }
        if (renderDown) {
            float f35 = sprites[0].m_118409_();
            float f36 = sprites[0].m_118410_();
            float f37 = sprites[0].m_118411_();
            float f39 = sprites[0].m_118412_();
            int i1 = this.getLightColor(tintGetter, pos.m_7495_());
            float f41 = shadeDown * red;
            float f42 = shadeDown * green;
            float f43 = shadeDown * blue;
            this.vertex(vertexConsumer, chunkX, chunkY + (double)minY, chunkZ + 1.0, f41, f42, f43, alpha, f35, f39, i1);
            this.vertex(vertexConsumer, chunkX, chunkY + (double)minY, chunkZ, f41, f42, f43, alpha, f35, f37, i1);
            this.vertex(vertexConsumer, chunkX + 1.0, chunkY + (double)minY, chunkZ, f41, f42, f43, alpha, f36, f37, i1);
            this.vertex(vertexConsumer, chunkX + 1.0, chunkY + (double)minY, chunkZ + 1.0, f41, f42, f43, alpha, f36, f39, i1);
            flag7 = true;
        }
        int k = this.getLightColor(tintGetter, pos);
        for (int l = 0; l < 4; ++l) {
            boolean flag8;
            Direction direction;
            double d6;
            double d4;
            double d5;
            double d3;
            float f40;
            float f38;
            if (l == 0) {
                f38 = myHeight;
                f40 = eastHeight;
                d3 = chunkX;
                d5 = chunkX + 1.0;
                d4 = chunkZ + (double)0.001f;
                d6 = chunkZ + (double)0.001f;
                direction = Direction.NORTH;
                flag8 = renderNorth;
            } else if (l == 1) {
                f38 = cornerHeight;
                f40 = southHeight;
                d3 = chunkX + 1.0;
                d5 = chunkX;
                d4 = chunkZ + 1.0 - (double)0.001f;
                d6 = chunkZ + 1.0 - (double)0.001f;
                direction = Direction.SOUTH;
                flag8 = renderSouth;
            } else if (l == 2) {
                f38 = southHeight;
                f40 = myHeight;
                d3 = chunkX + (double)0.001f;
                d5 = chunkX + (double)0.001f;
                d4 = chunkZ + 1.0;
                d6 = chunkZ;
                direction = Direction.WEST;
                flag8 = renderWest;
            } else {
                f38 = eastHeight;
                f40 = cornerHeight;
                d3 = chunkX + 1.0 - (double)0.001f;
                d5 = chunkX + 1.0 - (double)0.001f;
                d4 = chunkZ;
                d6 = chunkZ + 1.0;
                direction = Direction.EAST;
                flag8 = renderEast;
            }
            if (!flag8 || WaterTest.isFaceOccludedByNeighbor((BlockGetter)tintGetter, pos, direction, Math.max(f38, f40))) continue;
            flag7 = true;
            BlockPos blockpos = pos.m_142300_(direction);
            TextureAtlasSprite textureatlassprite2 = sprites[1];
            if (sprites[2] != null && tintGetter.m_8055_(blockpos).shouldDisplayFluidOverlay(tintGetter, blockpos, fluidState)) {
                textureatlassprite2 = sprites[2];
            }
            float f49 = textureatlassprite2.m_118367_(0.0);
            float f50 = textureatlassprite2.m_118367_(8.0);
            float f28 = textureatlassprite2.m_118393_((double)((1.0f - f38) * 16.0f * 0.5f));
            float f29 = textureatlassprite2.m_118393_((double)((1.0f - f40) * 16.0f * 0.5f));
            float f30 = textureatlassprite2.m_118393_(8.0);
            float f31 = l < 2 ? shadeNorth : shadeWest;
            float f32 = shadeUp * f31 * red;
            float f33 = shadeUp * f31 * green;
            float f34 = shadeUp * f31 * blue;
            this.vertex(vertexConsumer, d3, chunkY + (double)f38, d4, f32, f33, f34, alpha, f49, f28, k);
            this.vertex(vertexConsumer, d5, chunkY + (double)f40, d6, f32, f33, f34, alpha, f50, f29, k);
            this.vertex(vertexConsumer, d5, chunkY + (double)minY, d6, f32, f33, f34, alpha, f50, f30, k);
            this.vertex(vertexConsumer, d3, chunkY + (double)minY, d4, f32, f33, f34, alpha, f49, f30, k);
            if (textureatlassprite2 == this.waterOverlay) continue;
            this.vertex(vertexConsumer, d3, chunkY + (double)minY, d4, f32, f33, f34, alpha, f49, f30, k);
            this.vertex(vertexConsumer, d5, chunkY + (double)minY, d6, f32, f33, f34, alpha, f50, f30, k);
            this.vertex(vertexConsumer, d5, chunkY + (double)f40, d6, f32, f33, f34, alpha, f50, f29, k);
            this.vertex(vertexConsumer, d3, chunkY + (double)f38, d4, f32, f33, f34, alpha, f49, f28, k);
        }
        return flag7;
    }

    private void vertex(VertexConsumer p_110985_, double p_110986_, double p_110987_, double p_110988_, float p_110989_, float p_110990_, float p_110991_, float alpha, float p_110992_, float p_110993_, int p_110994_) {
        p_110985_.m_5483_(p_110986_, p_110987_, p_110988_).m_85950_(p_110989_, p_110990_, p_110991_, alpha).m_7421_(p_110992_, p_110993_).m_85969_(p_110994_).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private int getLightColor(BlockAndTintGetter p_110946_, BlockPos p_110947_) {
        int i = LevelRenderer.m_109541_((BlockAndTintGetter)p_110946_, (BlockPos)p_110947_);
        int j = LevelRenderer.m_109541_((BlockAndTintGetter)p_110946_, (BlockPos)p_110947_.m_7494_());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
    }

    private float getWaterHeight(BlockGetter p_110965_, BlockPos p_110966_, Fluid p_110967_) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < 4; ++j) {
            BlockPos blockpos = p_110966_.m_142082_(-(j & 1), 0, -(j >> 1 & 1));
            if (p_110965_.m_6425_(blockpos.m_7494_()).m_76152_().m_6212_(p_110967_)) {
                return 1.0f;
            }
            FluidState fluidstate = p_110965_.m_6425_(blockpos);
            if (fluidstate.m_76152_().m_6212_(p_110967_)) {
                float f1 = fluidstate.m_76155_(p_110965_, blockpos);
                if (f1 >= 0.8f) {
                    f += f1 * 10.0f;
                    i += 10;
                    continue;
                }
                f += f1;
                ++i;
                continue;
            }
            if (p_110965_.m_8055_(blockpos).m_60767_().m_76333_()) continue;
            ++i;
        }
        return f / (float)i;
    }
}

