/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.resourcepack.AfterLanguageLoadEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class BlockTypeRegistry<T extends BlockType> {
    protected boolean frozen = false;
    private final List<BlockType.SetFinder<T>> finders = new ArrayList<BlockType.SetFinder<T>>();
    private final List<ResourceLocation> notInclude = new ArrayList<ResourceLocation>();
    private final List<T> builder = new ArrayList<T>();
    private final Class<T> typeClass;

    public BlockTypeRegistry(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    public Class<T> getType() {
        return this.typeClass;
    }

    public T getFromNBT(String name) {
        return (T)((BlockType)this.getTypes().getOrDefault(new ResourceLocation(name), this.getDefaultType()));
    }

    @Nullable
    public T get(ResourceLocation res) {
        return (T)((BlockType)this.getTypes().get(res));
    }

    public abstract T getDefaultType();

    public abstract Map<ResourceLocation, T> getTypes();

    public abstract String typeName();

    public abstract Optional<T> detectTypeFromBlock(Block var1);

    protected abstract void saveTypes(ImmutableMap<ResourceLocation, T> var1);

    public void registerBlockType(T newType) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register wood types after registry events");
        }
        this.builder.add(newType);
    }

    public Collection<BlockType.SetFinder<T>> getFinders() {
        return this.finders;
    }

    public void addFinder(BlockType.SetFinder<T> finder) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register block type finder after registry events");
        }
        this.finders.add(finder);
    }

    public void addRemover(ResourceLocation id) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried remove a block type after registry events");
        }
        this.notInclude.add(id);
    }

    private void finalizeAndFreeze() {
        if (this.frozen) {
            throw new UnsupportedOperationException("Block types are already finalized");
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.builder.forEach(e -> {
            if (!linkedHashMap.containsKey(e.getId())) {
                linkedHashMap.put(e.getId(), e);
            }
        });
        this.saveTypes(ImmutableMap.copyOf(linkedHashMap));
        this.builder.clear();
        this.frozen = true;
    }

    public void buildAll() {
        if (!this.frozen) {
            this.registerBlockType(this.getDefaultType());
            Collection<BlockType.SetFinder<T>> finders = this.getFinders();
            finders.stream().map(BlockType.SetFinder::get).forEach(f -> f.ifPresent(this::registerBlockType));
            for (Block b : ForgeRegistries.BLOCKS) {
                this.detectTypeFromBlock(b).ifPresent(t -> {
                    if (!this.notInclude.contains(t.getId())) {
                        this.registerBlockType(t);
                    }
                });
            }
            this.finalizeAndFreeze();
        }
    }

    public void addTypeTranslations(AfterLanguageLoadEvent language) {
    }
}

