/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.config;

import java.io.File;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.config.DimletConfiguration;
import mcjty.rftoolsdim.config.DimletConstructionConfiguration;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.LostCityConfiguration;
import mcjty.rftoolsdim.config.MachineConfiguration;
import mcjty.rftoolsdim.config.MobConfiguration;
import mcjty.rftoolsdim.config.OresAPlentyConfiguration;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import net.minecraftforge.common.config.Configuration;

public class ConfigSetup {
    public static Configuration mainConfig;

    public static void init() {
        Configuration cfg = mainConfig = new Configuration(new File(RFToolsDim.setup.getModConfigDir().getPath() + File.separator + "rftools", "dimensions.cfg"));
        try {
            cfg.load();
            cfg.addCustomCategoryComment("general", "Dimension related settings");
            cfg.addCustomCategoryComment("machines", "Machine related settings");
            cfg.addCustomCategoryComment("worldgen", "Worldgen related settings");
            cfg.addCustomCategoryComment("power", "Power related settings");
            cfg.addCustomCategoryComment("dimlets", "Dimlet related settings");
            cfg.addCustomCategoryComment("mobs", "Mob related settings");
            cfg.addCustomCategoryComment("oresaplenty", "Settings for the OresAPlenty dimlet");
            cfg.addCustomCategoryComment("dimletconstruction", "Dimlet construction related settings");
            cfg.addCustomCategoryComment("lostcity", "Settings related to the Lost City dimlet");
            GeneralConfiguration.init(cfg);
            MachineConfiguration.init(cfg);
            WorldgenConfiguration.init(cfg);
            PowerConfiguration.init(cfg);
            DimletConfiguration.init(cfg);
            MobConfiguration.init(cfg);
            OresAPlentyConfiguration.init(cfg);
            LostCityConfiguration.init(cfg);
            DimletConstructionConfiguration.init(cfg);
        }
        catch (Exception e1) {
            Logging.logError((String)"Problem loading config file!", (Throwable)e1);
        }
    }

    public static void postInit() {
        if (mainConfig.hasChanged()) {
            mainConfig.save();
        }
    }
}

