/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import xreliquary.items.ItemBase;
import xreliquary.util.InventoryHelper;

public class WitherlessRoseItem
extends ItemBase {
    public WitherlessRoseItem() {
        super(new Item.Properties().func_200917_a(1));
        MinecraftForge.EVENT_BUS.addListener(this::preventWither);
        MinecraftForge.EVENT_BUS.addListener(this::preventWitherAttack);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    private void preventWither(PotionEvent.PotionApplicableEvent event) {
        LivingEntity entityLiving = event.getEntityLiving();
        if (entityLiving instanceof PlayerEntity && event.getPotionEffect().func_188419_a() == Effects.field_82731_v && InventoryHelper.playerHasItem((PlayerEntity)entityLiving, this)) {
            event.setResult(Event.Result.DENY);
            this.addPreventParticles((PlayerEntity)entityLiving);
        }
    }

    private void preventWitherAttack(LivingAttackEvent event) {
        LivingEntity entityLiving = event.getEntityLiving();
        if (entityLiving instanceof PlayerEntity && event.getSource() == DamageSource.field_82727_n && InventoryHelper.playerHasItem((PlayerEntity)entityLiving, this)) {
            entityLiving.func_195063_d(Effects.field_82731_v);
            event.setCanceled(true);
            this.addPreventParticles((PlayerEntity)entityLiving);
        }
    }

    private void addPreventParticles(PlayerEntity entityLiving) {
        World world = entityLiving.field_70170_p;
        for (int particles = 0; particles < 10; ++particles) {
            double gauss1 = this.gaussian(world.field_73012_v);
            double gauss2 = this.gaussian(world.field_73012_v);
            world.func_195594_a((IParticleData)ParticleTypes.field_197625_r, entityLiving.func_226277_ct_() + gauss1, entityLiving.func_226278_cu_() + (double)(entityLiving.func_213302_cg() / 2.0f), entityLiving.func_226281_cx_() + gauss2, 0.0, 0.0, 1.0);
        }
    }

    private double gaussian(Random rand) {
        return rand.nextGaussian() / 6.0;
    }
}

