/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import xreliquary.handler.CommonEventHandler;
import xreliquary.handler.HandlerPriority;
import xreliquary.handler.IPlayerHurtHandler;
import xreliquary.init.ModItems;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.fluid.FluidHandlerInfernalChalice;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class InfernalChaliceItem
extends ToggleableItem {
    public InfernalChaliceItem() {
        super(new Item.Properties().func_200917_a(1).setNoRepair());
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(PlayerEntity player, LivingAttackEvent event) {
                return (event.getSource() == DamageSource.field_76371_c || event.getSource() == DamageSource.field_76370_b || event.getSource() == DamageSource.field_76372_a) && player.func_71024_bL().func_75116_a() > 0 && InventoryHelper.playerHasItem(player, (Item)ModItems.INFERNAL_CHALICE.get());
            }

            @Override
            public boolean apply(PlayerEntity player, LivingAttackEvent event) {
                player.func_71020_j(event.getAmount() * ((float)((Integer)Settings.COMMON.items.infernalChalice.hungerCostPercent.get()).intValue() / 100.0f));
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack chalice, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"amount", (Object)String.valueOf(NBTHelper.getInt("fluidStacks", chalice))), tooltip);
        if (this.isEnabled(chalice)) {
            LanguageHelper.formatTooltip("tooltip.place", tooltip);
        } else {
            LanguageHelper.formatTooltip("tooltip.drain", tooltip);
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            return super.func_77659_a(world, player, hand);
        }
        BlockRayTraceResult result = InfernalChaliceItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)(this.isEnabled(stack) ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
        if (result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        BlockPos pos = result.func_216350_a();
        if (!world.func_175660_a(player, pos)) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        Direction face = result.func_216354_b();
        if (!player.func_175151_a(pos, face, stack)) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        return this.getFluidHandler(stack).map(fluidHandler -> this.interactWithFluidHandler(world, player, stack, pos, face, (IFluidHandlerItem)fluidHandler)).orElse(new ActionResult(ActionResultType.FAIL, (Object)stack));
    }

    private ActionResult<ItemStack> interactWithFluidHandler(World world, PlayerEntity player, ItemStack stack, BlockPos pos, Direction face, IFluidHandlerItem fluidHandler) {
        BlockState blockState = world.func_180495_p(pos);
        if (this.isEnabled(stack)) {
            if (blockState.func_177230_c() == Blocks.field_150353_l && (Integer)blockState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0 && fluidHandler.fill(new FluidStack((Fluid)Fluids.field_204547_b, 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                fluidHandler.fill(new FluidStack((Fluid)Fluids.field_204547_b, 1000), IFluidHandler.FluidAction.EXECUTE);
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
        } else {
            BlockPos adjustedPos;
            FluidStack fluidDrained = fluidHandler.drain(new FluidStack((Fluid)Fluids.field_204547_b, 1000), IFluidHandler.FluidAction.SIMULATE);
            if ((player.func_184812_l_() || fluidDrained.getAmount() == 1000) && this.tryPlaceContainedLiquid(world, adjustedPos = pos.func_177972_a(face)) && !player.func_184812_l_()) {
                fluidHandler.drain(new FluidStack((Fluid)Fluids.field_204547_b, 1000), IFluidHandler.FluidAction.EXECUTE);
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    private LazyOptional<IFluidHandlerItem> getFluidHandler(ItemStack stack) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    private boolean tryPlaceContainedLiquid(World world, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        Material material = blockState.func_185904_a();
        if (!world.func_175623_d(pos) && material.func_76220_a()) {
            return false;
        }
        world.func_180501_a(pos, Blocks.field_150353_l.func_176223_P(), 3);
        return true;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerInfernalChalice(stack);
    }
}

