/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.shot;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xreliquary.entities.ConcussiveExplosion;
import xreliquary.entities.shot.ShotEntityBase;
import xreliquary.init.ModEntities;
import xreliquary.reference.ClientReference;

public class ConcussiveShotEntity
extends ShotEntityBase {
    public ConcussiveShotEntity(EntityType<ConcussiveShotEntity> entityType, World world) {
        super(entityType, world);
    }

    public ConcussiveShotEntity(World world, PlayerEntity player, Hand hand) {
        super(ModEntities.CONCUSSIVE_SHOT, world, player, hand);
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 8 + this.d6();
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197601_L);
        }
    }

    @Override
    void spawnHitParticles(int i) {
    }

    @Override
    void doFiringEffects() {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, this.func_226277_ct_() + this.smallGauss(0.1), this.func_226278_cu_() + this.smallGauss(0.1), this.func_226281_cx_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197631_x);
    }

    @Override
    protected void onImpact(LivingEntity entityLiving) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.getShooterPlayer().ifPresent(player -> ConcussiveExplosion.customConcussiveExplosion((Entity)this, player, this.func_213303_ch(), 1.5f, true));
        super.onImpact(entityLiving);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.getShooterPlayer().ifPresent(player -> ConcussiveExplosion.customConcussiveExplosion((Entity)this, player, this.func_213303_ch(), 1.5f, true));
        this.func_70106_y();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.CONCUSSIVE;
    }
}

