/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting.alkahestry;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import xreliquary.crafting.AlkahestryCraftingRecipe;
import xreliquary.crafting.conditions.AlkahestryEnabledCondition;

public class CraftingRecipeBuilder {
    private final Ingredient item;
    private final int charge;
    private final int resultCount;
    private final List<ICondition> additionalConditions = new ArrayList<ICondition>();

    private CraftingRecipeBuilder(Ingredient item, int charge, int resultCount) {
        this.item = item;
        this.charge = charge;
        this.resultCount = resultCount;
    }

    public static CraftingRecipeBuilder craftingRecipe(IItemProvider item, int charge, int resultCount) {
        return new CraftingRecipeBuilder(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), charge, resultCount);
    }

    public static CraftingRecipeBuilder craftingRecipe(ITag<Item> tag, int charge, int resultCount) {
        return new CraftingRecipeBuilder(Ingredient.func_199805_a(tag), charge, resultCount);
    }

    public CraftingRecipeBuilder addCondition(ICondition condition) {
        this.additionalConditions.add(condition);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation fullId = new ResourceLocation("xreliquary", "alkahestry/crafting/" + id.func_110623_a());
        ConditionalRecipe.Builder builder = ConditionalRecipe.builder().addCondition((ICondition)new AlkahestryEnabledCondition());
        this.additionalConditions.forEach(arg_0 -> ((ConditionalRecipe.Builder)builder).addCondition(arg_0));
        builder.addRecipe(conditionalConsumer -> conditionalConsumer.accept(new Result(fullId, this.item, this.charge, this.resultCount)));
        builder.build(consumer, fullId);
    }

    public static class Result
    implements IFinishedRecipe {
        private final Ingredient item;
        private final int charge;
        private final int resultCount;
        private final ResourceLocation id;

        public Result(ResourceLocation id, Ingredient item, int charge, int resultCount) {
            this.id = id;
            this.item = item;
            this.charge = charge;
            this.resultCount = resultCount;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("charge", (Number)this.charge);
            json.add("ingredient", this.item.func_200304_c());
            json.addProperty("result_count", (Number)this.resultCount);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return AlkahestryCraftingRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

