/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting.alkahestry;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import xreliquary.crafting.AlkahestryChargingRecipe;
import xreliquary.crafting.conditions.AlkahestryEnabledCondition;

public class ChargingRecipeBuilder {
    private final Ingredient ingredient;
    private final int charge;

    private ChargingRecipeBuilder(IItemProvider ingredient, int charge) {
        this.ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient});
        this.charge = charge;
    }

    public static ChargingRecipeBuilder chargingRecipe(IItemProvider result, int charge) {
        return new ChargingRecipeBuilder(result, charge);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation fullId = new ResourceLocation("xreliquary", "alkahestry/charging/" + id.func_110623_a());
        ConditionalRecipe.builder().addCondition((ICondition)new AlkahestryEnabledCondition()).addRecipe(conditionalConsumer -> conditionalConsumer.accept(new Result(fullId, this.ingredient, this.charge))).build(consumer, fullId);
    }

    public static class Result
    implements IFinishedRecipe {
        private final Ingredient ingredient;
        private final int charge;
        private final ResourceLocation id;

        public Result(ResourceLocation id, Ingredient ingredient, int charge) {
            this.id = id;
            this.ingredient = ingredient;
            this.charge = charge;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("charge", (Number)this.charge);
            json.add("ingredient", this.ingredient.func_200304_c());
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return AlkahestryChargingRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

