/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.jei;

import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import xreliquary.Reliquary;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;
import xreliquary.items.MobCharmFragmentItem;
import xreliquary.items.MobCharmItem;
import xreliquary.util.LanguageHelper;
import xreliquary.util.RegistryHelper;
import xreliquary.util.potions.XRPotionHelper;

public class ItemDescriptionBuilder {
    private ItemDescriptionBuilder() {
    }

    public static void addIngredientInfo(IRecipeRegistration registration) {
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ALKAHESTRY_TOME.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.MERCY_CROSS.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ANGELHEART_VIAL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ANGELIC_FEATHER.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ATTRACTION_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.POTION_ESSENCE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.DESTRUCTION_CATALYST.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.EMPEROR_CHALICE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ENDER_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.FERTILE_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.FORTUNE_COIN.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.GLACIAL_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.GLOWING_WATER.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.HOLY_HAND_GRENADE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.HANDGUN.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.GRIP_ASSEMBLY.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.BARREL_ASSEMBLY.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.HAMMER_ASSEMBLY.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.HARVEST_ROD.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.HERO_MEDALLION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ICE_MAGUS_ROD.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.INFERNAL_CHALICE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.INFERNAL_CLAWS.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.INFERNAL_TEAR.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.KRAKEN_SHELL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.MIDAS_TOUCHSTONE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.PHOENIX_DOWN.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.PYROMANCER_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.RENDING_GALE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ROD_OF_LYSSA.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SOJOURNER_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.TIPPED_ARROW.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.VOID_TEAR.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.WITCH_HAT.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.WITHERLESS_ROSE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.EMPTY_POTION_VIAL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SPLASH_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.LINGERING_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.MOB_CHARM_BELT.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.ZOMBIE_HEART.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SQUID_BEAK.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.RIB_BONE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.CATALYZING_GLAND.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.CHELICERAE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SLIME_PEARL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.KRAKEN_SHELL_FRAGMENT.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.BAT_WING.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.WITHERED_RIB.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.MOLTEN_CORE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.EYE_OF_THE_STORM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.FERTILE_ESSENCE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.FROZEN_CORE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.NEBULOUS_HEART.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.INFERNAL_CLAW.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.GUARDIAN_SPIKE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.CRIMSON_CLOTH.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.LANTERN_OF_PARANOIA.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.MAGICBANE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SALAMANDER_EYE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SERPENT_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.SHEARS_OF_WINTER.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.TWILIGHT_CLOAK.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.GLOWING_BREAD.get());
        ItemDescriptionBuilder.registerCharmFragmentItemsDescription(registration);
        ItemDescriptionBuilder.registerCharmItemsDescription(registration);
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.EMPTY_MAGAZINE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModItems.EMPTY_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.NEUTRAL_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.EXORCISM_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.BLAZE_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.ENDER_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.CONCUSSIVE_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.BUSTER_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.SEEKER_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.SAND_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.STORM_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.NEUTRAL_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.EXORCISM_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.BLAZE_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.ENDER_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.CONCUSSIVE_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.BUSTER_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.SEEKER_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.SAND_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, (Item)ModItems.STORM_BULLET.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModBlocks.ALKAHESTRY_ALTAR_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModBlocks.APOTHECARY_CAULDRON_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModBlocks.APOTHECARY_MORTAR_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModBlocks.INTERDICTION_TORCH_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, (Item)ModBlocks.WRAITH_NODE_ITEM.get());
        ItemDescriptionBuilder.addStacksIngredientInfo(registration, ModBlocks.PEDESTAL_ITEMS.values().stream().map(ro -> new ItemStack((IItemProvider)ro.get())).collect(Collectors.toList()), "pedestal");
        ItemDescriptionBuilder.addStacksIngredientInfo(registration, ModBlocks.PASSIVE_PEDESTAL_ITEMS.values().stream().map(ro -> new ItemStack((IItemProvider)ro.get())).collect(Collectors.toList()), "passive_pedestal");
    }

    private static void registerItemDescription(IRecipeRegistration registration, Item item) {
        NonNullList subItems = NonNullList.func_191196_a();
        item.func_150895_a(Reliquary.ITEM_GROUP, subItems);
        if (!subItems.isEmpty()) {
            ItemDescriptionBuilder.addStacksIngredientInfo(registration, item, (List<ItemStack>)subItems, new String[0]);
        }
    }

    private static void addStacksIngredientInfo(IRecipeRegistration registration, Item item, List<ItemStack> items, String ... additionalKeys) {
        String[] langKeys;
        String regName = RegistryHelper.getRegistryName(item).func_110623_a();
        if (additionalKeys.length > 0) {
            langKeys = new String[additionalKeys.length + 1];
            langKeys[0] = regName;
            System.arraycopy(additionalKeys, 0, langKeys, 1, additionalKeys.length);
        } else {
            langKeys = new String[]{regName};
        }
        ItemDescriptionBuilder.addStacksIngredientInfo(registration, items, langKeys);
    }

    private static void addStacksIngredientInfo(IRecipeRegistration registration, List<ItemStack> items, String ... langKeys) {
        registration.addIngredientInfo(items, VanillaTypes.ITEM, ItemDescriptionBuilder.getTranslationKeys(langKeys));
    }

    private static String[] getTranslationKeys(String ... langKeys) {
        String[] keys = new String[langKeys.length];
        for (int i = 0; i < langKeys.length; ++i) {
            keys[i] = String.format("jei.%s.description.%s", "xreliquary", langKeys[i].replace('/', '.'));
        }
        return keys;
    }

    private static void registerCharmFragmentItemsDescription(IRecipeRegistration registration) {
        MobCharmFragmentItem item = (MobCharmFragmentItem)ModItems.MOB_CHARM_FRAGMENT.get();
        BinaryOperator getLocalization = (itemDescriptionKey, entityName) -> LanguageHelper.getLocalization(itemDescriptionKey, entityName, entityName);
        ItemDescriptionBuilder.registerCharmBasedItems(registration, item, getLocalization, MobCharmFragmentItem::getEntityEggRegistryName);
    }

    private static void registerCharmItemsDescription(IRecipeRegistration registration) {
        MobCharmItem item = (MobCharmItem)ModItems.MOB_CHARM.get();
        BinaryOperator getLocalization = (x$0, xva$1) -> LanguageHelper.getLocalization(x$0, xva$1);
        ItemDescriptionBuilder.registerCharmBasedItems(registration, item, getLocalization, MobCharmItem::getEntityEggRegistryName);
    }

    private static void registerCharmBasedItems(IRecipeRegistration registration, Item item, BinaryOperator<String> getLocalization, Function<ItemStack, ResourceLocation> getEntityRegistryName) {
        NonNullList subItems = NonNullList.func_191196_a();
        item.func_150895_a(Reliquary.ITEM_GROUP, subItems);
        for (ItemStack subItem : subItems) {
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(getEntityRegistryName.apply(subItem));
            if (entityType == null) continue;
            String path = RegistryHelper.getRegistryName(item).func_110623_a();
            String itemDescriptionKey = String.format("jei.%s.description.%s", "xreliquary", path.replace('/', '.'));
            String entityName = entityType.func_212546_e().getString();
            registration.addIngredientInfo((Object)subItem, VanillaTypes.ITEM, new String[]{(String)getLocalization.apply(itemDescriptionKey, entityName)});
        }
    }

    private static void registerPotionAmmoItemsDescription(IRecipeRegistration registration, Item item) {
        NonNullList subItems = NonNullList.func_191196_a();
        NonNullList potionItems = NonNullList.func_191196_a();
        item.func_150895_a(Reliquary.ITEM_GROUP, subItems);
        for (ItemStack subItem : subItems) {
            if (XRPotionHelper.getPotionEffectsFromStack(subItem).isEmpty()) continue;
            potionItems.add((Object)subItem);
        }
        if (!potionItems.isEmpty()) {
            ItemDescriptionBuilder.addStacksIngredientInfo(registration, item, (List<ItemStack>)potionItems, "ammo_potion");
        }
        subItems = NonNullList.func_191196_a();
        NonNullList nonPotionItems = NonNullList.func_191196_a();
        item.func_150895_a(Reliquary.ITEM_GROUP, subItems);
        for (ItemStack subItem : subItems) {
            if (!XRPotionHelper.getPotionEffectsFromStack(subItem).isEmpty()) continue;
            nonPotionItems.add((Object)subItem);
        }
        if (!nonPotionItems.isEmpty()) {
            ItemDescriptionBuilder.addStacksIngredientInfo(registration, item, (List<ItemStack>)nonPotionItems, new String[0]);
        }
    }
}

