/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.gui.hud;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import xreliquary.client.gui.components.Box;
import xreliquary.client.gui.components.Component;
import xreliquary.client.gui.components.ItemStackPane;
import xreliquary.client.gui.hud.ChargePane;
import xreliquary.client.gui.hud.HUDPosition;
import xreliquary.util.InventoryHelper;

public class ChargeableItemInfoPane
extends Component {
    public static final String DYNAMIC_PANE = "dynamic";
    private final ItemStack mainItem;
    private Box mainPanel;
    private Map<String, Component> modePanes = Maps.newHashMap();
    private final HUDPosition hudPosition;
    private String lastMode;
    private final Function<ItemStack, String> getMode;

    public ChargeableItemInfoPane(ItemStack mainItem, HUDPosition hudPosition, Function<ItemStack, String> getMode, Map<String, Component> modePanes) {
        this(mainItem, getMode, hudPosition);
        this.modePanes = modePanes;
        String mode = modePanes.keySet().iterator().next();
        this.updateCurrentPane(modePanes.get(mode), mode);
    }

    public ChargeableItemInfoPane(Item mainItem, HUDPosition hudPosition, Function<ItemStack, String> getMode, Map<String, Component> modePanes) {
        this(new ItemStack((IItemProvider)mainItem), hudPosition, getMode, modePanes);
    }

    public ChargeableItemInfoPane(Item mainItem, HUDPosition hudPosition, ItemStack chargeItem, Function<ItemStack, Integer> getCount) {
        this(new ItemStack((IItemProvider)mainItem), is -> "single", hudPosition);
        this.updateCurrentPane(new ChargePane(mainItem, chargeItem, getCount), "single");
    }

    public ChargeableItemInfoPane(Item mainItem, HUDPosition hudPosition, ItemStack chargeItem, Function<ItemStack, Integer> getCount, int textColor) {
        this(new ItemStack((IItemProvider)mainItem), is -> "single", hudPosition);
        this.updateCurrentPane(new ChargePane(mainItem, chargeItem, getCount, textColor), "single");
    }

    private ChargeableItemInfoPane(ItemStack mainItem, Function<ItemStack, String> getMode, HUDPosition hudPosition) {
        this.mainItem = mainItem;
        this.getMode = getMode;
        this.hudPosition = hudPosition;
    }

    private void updateCurrentPane(Component modePane, String currentMode) {
        this.lastMode = currentMode;
        Box.Alignment alignment = ChargeableItemInfoPane.getMainStackAlignment(this.hudPosition);
        this.mainPanel = Box.createVertical(alignment, new ItemStackPane(this.mainItem), modePane);
    }

    @Override
    public int getHeightInternal() {
        return this.mainPanel.getHeight();
    }

    @Override
    public int getWidthInternal() {
        return this.mainPanel.getWidth();
    }

    @Override
    public int getPadding() {
        return 1;
    }

    @Override
    public boolean shouldRender() {
        return !InventoryHelper.getCorrectItemFromEitherHand((PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.mainItem.func_77973_b()).func_190926_b();
    }

    @Override
    public void renderInternal(MatrixStack matrixStack, int x, int y) {
        ItemStack mainStack = InventoryHelper.getCorrectItemFromEitherHand((PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.mainItem.func_77973_b());
        String mode = this.getMode.apply(mainStack);
        if (!this.lastMode.equals(mode)) {
            if (this.modePanes.containsKey(mode)) {
                this.updateCurrentPane(this.modePanes.get(mode), mode);
            } else if (this.modePanes.containsKey(DYNAMIC_PANE)) {
                this.updateCurrentPane(this.modePanes.get(DYNAMIC_PANE), DYNAMIC_PANE);
            }
        }
        this.mainPanel.render(matrixStack, x, y);
    }

    private static Box.Alignment getMainStackAlignment(HUDPosition position) {
        Box.Alignment alignment;
        Box.Alignment alignment2 = alignment = position == HUDPosition.TOP ? Box.Alignment.MIDDLE : Box.Alignment.LEFT;
        if (position.isRightSide()) {
            alignment = Box.Alignment.RIGHT;
        }
        return alignment;
    }
}

