/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import plantmegapack.PlantMegaPack;
import plantmegapack.common.PMPDecorator;
import plantmegapack.common.PMPDecoratorFeature;
import plantmegapack.common.PMPDecoratorSet;
import plantmegapack.data.PMPDataDecorator;
import plantmegapack.worldgen.PMPGenAquatic;
import plantmegapack.worldgen.PMPGenBase;
import plantmegapack.worldgen.PMPGenVillageCrop;
import plantmegapack.worldgen.PMPGenVillagePlant;
import plantmegapack.worldgen.PMPSpawnLocation;

public class PMPWorldGenerator
implements IWorldGenerator {
    private static final int chunkSize = 16;
    private ArrayList<PMPDataDecorator> arrayDecorators = new ArrayList(PMPDecorator.values().length);
    private PMPSpawnLocation locationData = new PMPSpawnLocation();

    public PMPWorldGenerator() {
        this.loadDecoratorData();
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                if (PlantMegaPack.settings.worldgenNetherRate <= 0) break;
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                if (PlantMegaPack.settings.worldgenOverworldRate <= 0) break;
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                if (PlantMegaPack.settings.worldgenEndRate <= 0) break;
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
        }
    }

    private void generateNether(World world, Random random, int chunkX, int chunkZ) {
    }

    private void generateSurface(World world, Random random, int chunkX, int chunkZ) {
        BiomeGenBase biome = world.getBiomeGenForCoordsBody(chunkX, chunkZ);
        if (PlantMegaPack.settings.contentAquatic && biome.field_76791_y.matches("Deep Ocean") && PlantMegaPack.settings.worldgenCoralReefs && random.nextInt(100) < 40) {
            int x = chunkX + random.nextInt(16);
            int z = chunkZ + random.nextInt(16);
            int y = world.func_72976_f(x, z);
            this.locationData.getSpawnLocationData(world, random, x, y, z);
            PMPGenAquatic.spawnCoralReef(world, random, this.locationData);
            return;
        }
        for (int count = 0; count < PlantMegaPack.settings.worldgenOverworldPasses; ++count) {
            int z;
            int y;
            int x;
            if (random.nextInt(100) >= PlantMegaPack.settings.worldgenOverworldRate || !this.locationData.getSpawnLocationData(world, random, x = chunkX + random.nextInt(16), y = world.func_72976_f(x, z = chunkZ + random.nextInt(16)), z)) continue;
            if (this.locationData.decoratorFeature == PMPDecoratorFeature.VILLAGE_CROP) {
                PMPGenVillageCrop.generate(world, random, this.locationData);
                continue;
            }
            if (this.locationData.decoratorFeature == PMPDecoratorFeature.VILLAGE_PLANT) {
                PMPGenVillagePlant.generate(world, random, this.locationData);
                continue;
            }
            PMPDataDecorator decorator = this.getDecorator(this.locationData.decorator);
            if (decorator == null || random.nextInt(100) >= decorator.generationRate) continue;
            PMPGenBase.spawnPlantCluster(world, random, this.locationData, decorator.getRandomPlant(random, this.locationData.decoratorArea));
        }
    }

    private void generateEnd(World world, Random random, int chunkX, int chunkZ) {
    }

    private void loadDecoratorData() {
        for (PMPDecorator spawnBiome : PMPDecorator.values()) {
            PMPDataDecorator decorator = new PMPDataDecorator(spawnBiome);
            if (decorator == null) continue;
            this.arrayDecorators.add(decorator);
        }
    }

    private PMPDataDecorator getDecorator(PMPDecorator decorator) {
        for (int index = 0; index < this.arrayDecorators.size(); ++index) {
            if (this.arrayDecorators.get((int)index).decorator != decorator) continue;
            return this.arrayDecorators.get(index);
        }
        return null;
    }

    public PMPDataDecorator getDecoratorByID(String ID) {
        for (int index = 0; index < this.arrayDecorators.size(); ++index) {
            if (!this.arrayDecorators.get((int)index).decorator.ID.matches(ID)) continue;
            return this.arrayDecorators.get(index);
        }
        return null;
    }

    public void resetAllDecoratorsInSet(PMPDecoratorSet decoratorSet) {
        for (int index = 0; index < this.arrayDecorators.size(); ++index) {
            PMPDataDecorator decoratorData = this.arrayDecorators.get(index);
            if (decoratorData == null || decoratorSet != decoratorData.decorator.decoratorSet) continue;
            decoratorData.clearAllDecoratorAreas();
            decoratorData.resetDecoratorDefaults(null);
            decoratorData.saveUserConfig();
        }
    }

    public int getDecoratorsCount() {
        return this.arrayDecorators.size();
    }
}

