/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import plantmegapack.PlantMegaPack;
import plantmegapack.block.PMPBlockPlant;
import plantmegapack.common.PMPPlantCategory;

public class PMPItemPlant
extends ItemBlock {
    private PMPBlockPlant blockPlant = null;

    public PMPItemPlant(Block blockPlant) {
        super(blockPlant);
        this.func_77655_b(blockPlant.func_149739_a().substring(5));
        this.func_77664_n();
        if (blockPlant instanceof PMPBlockPlant) {
            this.blockPlant = (PMPBlockPlant)blockPlant;
            if (this.blockPlant.hasFlowerColors()) {
                this.func_77656_e(0);
                this.func_77627_a(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        if (this.blockPlant == null) {
            return Blocks.field_150330_I.func_149691_a(0, 0);
        }
        if (this.blockPlant.hasFlowerColors()) {
            return this.blockPlant.func_149691_a(0, damage);
        }
        return this.blockPlant.func_149691_a(0, this.blockPlant.getInventoryIconIndex());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack itemStack) {
        return this.func_77617_a(itemStack.func_77960_j());
    }

    public int func_77647_b(int damageValue) {
        return damageValue;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (this.blockPlant != null && (this.blockPlant.plantData.attributes.category == PMPPlantCategory.FLOATING || this.blockPlant.plantData.attributes.category == PMPPlantCategory.CROP_AQUATIC || this.blockPlant.plantData.attributes.category == PMPPlantCategory.IMMERSED)) {
            MovingObjectPosition movingobjectposition = this.func_77621_a(world, entityPlayer, true);
            if (movingobjectposition == null) {
                return itemStack;
            }
            if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                int i = movingobjectposition.field_72311_b;
                int j = movingobjectposition.field_72312_c;
                int k = movingobjectposition.field_72309_d;
                if (!world.func_72962_a(entityPlayer, i, j, k)) {
                    return itemStack;
                }
                if (!entityPlayer.func_82247_a(i, j, k, movingobjectposition.field_72310_e, itemStack)) {
                    return itemStack;
                }
                if (world.func_147439_a(i, j, k).func_149688_o() == Material.field_151586_h && world.func_72805_g(i, j, k) == 0 && world.func_147437_c(i, j + 1, k)) {
                    Block block;
                    if (!(this.blockPlant.plantData.attributes.category != PMPPlantCategory.CROP_AQUATIC && this.blockPlant.plantData.attributes.category != PMPPlantCategory.IMMERSED || PlantMegaPack.soilBlocks.canPlantOnThisBlock(this.blockPlant.plantData.attributes.soilType, block = world.func_147439_a(i, j - 1, k)))) {
                        return itemStack;
                    }
                    world.func_147465_d(i, j + 1, k, (Block)this.blockPlant, itemStack.func_77960_j(), 3);
                    if (!entityPlayer.field_71075_bZ.field_75098_d) {
                        --itemStack.field_77994_a;
                    }
                }
            }
            return itemStack;
        }
        return super.func_77659_a(itemStack, world, entityPlayer);
    }

    public String func_77667_c(ItemStack itemStack) {
        if (this.blockPlant.hasFlowerColors()) {
            if (itemStack.func_77960_j() >= this.blockPlant.getSubBlocksCount()) {
                itemStack.func_77964_b(0);
            }
            return super.func_77667_c(itemStack) + this.blockPlant.colorMap.get((int)itemStack.func_77960_j()).ID;
        }
        return super.func_77667_c(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean flag) {
        if (this.blockPlant == null) {
            return;
        }
        if (PlantMegaPack.settings.tooltipLatinName && this.blockPlant.plantData.attributes.category != PMPPlantCategory.GROUNDCOVER) {
            list.add(new String("\u00a77\u00a7o" + this.blockPlant.plantData.getLatinName() + "\u00a7r"));
        }
        if (PlantMegaPack.settings.tooltipCategory) {
            list.add("\u00a7o\u00a7" + this.blockPlant.plantData.attributes.category.colorCode + StatCollector.func_74838_a((String)("plantCategory." + this.blockPlant.plantData.attributes.category.ID)) + "\u00a7r");
        }
        if (PlantMegaPack.settings.tooltipAttributes) {
            list.add("");
            if (this.blockPlant.plantData.attributes.category != PMPPlantCategory.CORAL && this.blockPlant.plantData.attributes.dyeColor >= 0) {
                this.addPlantDyeColor(itemStack, list);
            }
            if (this.blockPlant.plantData.attributes.hangingPlant.length() > 0) {
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipCrafting") + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.hangingPlant") + "\u00a7r");
            }
            this.addCategorySpecificCrafting(list);
            this.addPlantSpecificCrafting(list);
            if (this.blockPlant.plantData.attributes.foodPlant) {
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipResource") + ": \u00a7a" + StatCollector.func_74838_a((String)"text.tooltipFood") + "\u00a7r");
            }
            if (this.blockPlant.plantData.attributes.damagePoison) {
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipWarning") + ": \u00a7c" + StatCollector.func_74838_a((String)"text.tooltipPoison") + "\u00a7r");
            }
            if (this.blockPlant.plantData.attributes.damageThorns) {
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipWarning") + ": \u00a7e" + StatCollector.func_74838_a((String)"text.tooltipThorns") + "\u00a7r");
            }
        }
        if (PlantMegaPack.settings.tooltipGrowthStages && this.blockPlant.plantData.attributes.growthStages > 1) {
            if (this.blockPlant.plantData.attributes.category == PMPPlantCategory.BAMBOO) {
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipGrowthHeight") + ": \u00a72" + String.valueOf(this.blockPlant.plantData.attributes.growthMax) + "\u00a7r");
            } else {
                list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipGrowthStages") + ": \u00a72" + String.valueOf(this.blockPlant.plantData.attributes.growthStages) + "\u00a7r");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addPlantDyeColor(ItemStack itemStack, List list) {
        int color = this.blockPlant.plantData.attributes.dyeColor;
        String dyeColorID = "";
        String formatColor = "";
        if (this.blockPlant.hasFlowerColors()) {
            color = this.blockPlant.colorMap.get((int)itemStack.func_77960_j()).dyeColor;
        }
        switch (color) {
            case 1: {
                dyeColorID = "red";
                formatColor = "4";
                break;
            }
            case 2: {
                dyeColorID = "green";
                formatColor = "2";
                break;
            }
            case 5: {
                dyeColorID = "purple";
                formatColor = "5";
                break;
            }
            case 6: {
                dyeColorID = "cyan";
                formatColor = "3";
                break;
            }
            case 7: {
                dyeColorID = "lightGray";
                formatColor = "7";
                break;
            }
            case 8: {
                dyeColorID = "gray";
                formatColor = "8";
                break;
            }
            case 9: {
                dyeColorID = "pink";
                formatColor = "c";
                break;
            }
            case 10: {
                dyeColorID = "lime";
                formatColor = "a";
                break;
            }
            case 11: {
                dyeColorID = "yellow";
                formatColor = "e";
                break;
            }
            case 12: {
                dyeColorID = "lightBlue";
                formatColor = "b";
                break;
            }
            case 13: {
                dyeColorID = "magenta";
                formatColor = "d";
                break;
            }
            case 14: {
                dyeColorID = "orange";
                formatColor = "6";
            }
        }
        if (dyeColorID.length() > 0) {
            list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipCrafting") + ": \u00a7" + formatColor + StatCollector.func_74838_a((String)("text.dye." + dyeColorID)) + " \u00a79" + StatCollector.func_74838_a((String)"text.crafting.dye") + "\u00a7r");
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addCategorySpecificCrafting(List list) {
        String textCrafting = StatCollector.func_74838_a((String)"text.tooltipCrafting");
        if (this.blockPlant.plantData.attributes.category == PMPPlantCategory.BAMBOO) {
            list.add("\u00a78" + StatCollector.func_74838_a((String)"text.tooltipResource") + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.buildingBlocks") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.category == PMPPlantCategory.CACTUS) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"plantPowder.cactus") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.category == PMPPlantCategory.CORAL) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.coralFragment") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.category == PMPPlantCategory.EPIPHYTE) {
            if (this.blockPlant.plantData.attributes.ID.matches("epiphyteArtistsConk") || this.blockPlant.plantData.attributes.ID.matches("epiphyteSulphurShelf") || this.blockPlant.plantData.attributes.ID.matches("epiphyteTurkeyTail")) {
                list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.fermentedSpiderEye") + "\u00a7r");
                list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"plantPowder.mushroom") + "\u00a7r");
            }
        } else if (this.blockPlant.plantData.attributes.category == PMPPlantCategory.FERN) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"plantPowder.fern") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.category == PMPPlantCategory.FUNGUS) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.fermentedSpiderEye") + "\u00a7r");
            if (this.blockPlant.plantData.attributes.ID.matches("fungusDeathCap") || this.blockPlant.plantData.attributes.ID.matches("fungusWoollyGomphus")) {
                list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"plantPowder.mushroomPoison") + "\u00a7r");
            } else {
                list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.mushroomStew") + "\u00a7r");
                list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"plantPowder.mushroom") + "\u00a7r");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addPlantSpecificCrafting(List list) {
        String textCrafting = StatCollector.func_74838_a((String)"text.tooltipCrafting");
        if (this.blockPlant.plantData.attributes.ID.matches("flowerBlueStar")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"item.flowerBlueStarItem.name") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("desertBroomSnakeweed")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"item.flowerBroomSnakeweed.name") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("desertOcotillo")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"item.flowerOcotillo.name") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("flowerYellowToadflax")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"item.flowerYellowToadflaxItem.name") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("forestWildMint")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"item.leafWildMint.name") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("jungleTorchGinger")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"item.flowerTorchGinger.name") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("flowerCandelabraAloe")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"item.leafAloe.name") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("forestPinesap")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"item.salveFireResist.name") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("forestWolfsFootClubmoss")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.gunpowder") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("groundcoverLeavesBRN") || this.blockPlant.plantData.attributes.ID.matches("groundcoverLeavesGRN")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"plantPowder.leaf") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("groundcoverMoss")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"plantPowder.moss") + "\u00a7r");
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.mossyCobblestone") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("groundcoverTwig")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.stick") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("vineSpanishMoss")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.string") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("waterKelpGiantGRN") || this.blockPlant.plantData.attributes.ID.matches("waterKelpGiantYEL")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"item.wrapSeaweed.name") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("wetlandsCattails")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"text.crafting.cattailSpike") + "\u00a7r");
        } else if (this.blockPlant.plantData.attributes.ID.matches("wetlandsWaterHorsetail")) {
            list.add("\u00a78" + textCrafting + ": \u00a79" + StatCollector.func_74838_a((String)"item.salveStrength.name") + "\u00a7r");
        }
    }
}

