/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.gui;

import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.IIcon;
import plantmegapack.PlantMegaPack;
import plantmegapack.block.PMPBlockPlant;
import plantmegapack.common.PMPDecoratorArea;
import plantmegapack.data.PMPDataDecorator;
import plantmegapack.data.PMPDataPlantSpawnParams;
import plantmegapack.gui.PMPGuiButton;
import plantmegapack.gui.PMPGuiConfigAddPlant;
import plantmegapack.gui.PMPGuiConfigBase;
import plantmegapack.gui.PMPGuiSlider;
import plantmegapack.gui.PMPGuiStringList;
import plantmegapack.gui.PMPGuiStringListState;

@SideOnly(value=Side.CLIENT)
public class PMPGuiConfigDecoratorPlantList
extends PMPGuiConfigBase {
    private static final int LIST_HEIGHT = 92;
    private static final int LIST_WIDTH = 180;
    private PMPDataDecorator decorator;
    private PMPDecoratorArea decoratorArea;
    private PMPGuiStringList plantList;
    private ArrayList<String> arrayPlantNames = new ArrayList();
    private PMPGuiButton buttonAdd;
    private PMPGuiButton buttonRemove;
    private PMPGuiButton buttonDefault;
    private PMPGuiSlider sliderGenRate;
    private PMPGuiButton buttonOverwriteVanilla;
    private PMPGuiSlider sliderElevationVariance;
    private PMPGuiSlider sliderClusterAmount;
    private PMPGuiSlider sliderClusterSize;
    private IIcon plantIcon;
    private static PMPGuiStringListState plantListState = new PMPGuiStringListState();

    public PMPGuiConfigDecoratorPlantList(GuiScreen parent, PMPDataDecorator decorator, PMPDecoratorArea decoratorArea) {
        super(parent, "gui.screen.configDecoratorPlantList", 0);
        this.decorator = decorator;
        this.decoratorArea = decoratorArea;
        if (this.decorator != null && this.decoratorArea != null) {
            this.name = this.name + " - " + this.decorator.decorator.getLocalizedName() + " - " + this.decoratorArea.getLocalizedName();
        }
    }

    @Override
    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        int xPos = this.field_146294_l / 2 - 182;
        int yPos = 36;
        this.plantList = new PMPGuiStringList(this, 180, 92, yPos, yPos + 92, xPos, this.getFontRenderer().field_78288_b + 2);
        this.plantList.useListState(plantListState);
        this.buttonAdd = new PMPGuiButton(4, xPos, yPos += 96, 88, 20, LanguageRegistry.instance().getStringLocalization("gui.button.add") + "...");
        this.field_146292_n.add(this.buttonAdd);
        this.buttonRemove = new PMPGuiButton(5, xPos += 92, yPos, 88, 20, LanguageRegistry.instance().getStringLocalization("gui.button.remove"));
        this.field_146292_n.add(this.buttonRemove);
        this.buttonDefault = new PMPGuiButton(6, xPos -= 75, yPos += 24, 150, 20, LanguageRegistry.instance().getStringLocalization("gui.button.defaultList"));
        this.field_146292_n.add(this.buttonDefault);
        xPos = this.field_146294_l / 2 + 182 - 180;
        yPos = 84;
        this.sliderGenRate = new PMPGuiSlider(this, 7, xPos, yPos, 180, 20, "sliderGenRate", 1, 50, 100, 1);
        this.field_146292_n.add(this.sliderGenRate);
        this.sliderGenRate.setSliderMode(1);
        this.buttonOverwriteVanilla = new PMPGuiButton(8, xPos, yPos += 24, 88, 20, LanguageRegistry.instance().getStringLocalization("gui.button.overwriteVanilla"));
        this.field_146292_n.add(this.buttonOverwriteVanilla);
        this.buttonOverwriteVanilla.setButtonMode(1);
        this.sliderElevationVariance = new PMPGuiSlider(this, 9, xPos += 92, yPos, 88, 20, "gui.slider.elevationVariance", 0, 0, 16, 1);
        this.field_146292_n.add(this.sliderElevationVariance);
        xPos = this.field_146294_l / 2 + 182 - 180;
        this.sliderClusterAmount = new PMPGuiSlider(this, 10, xPos, yPos += 24, 180, 20, "gui.slider.clusterAmount", 1, 1, 64, 1);
        this.field_146292_n.add(this.sliderClusterAmount);
        this.sliderClusterSize = new PMPGuiSlider(this, 11, xPos, yPos += 24, 180, 20, "gui.slider.clusterSize", 1, 1, 8, 1);
        this.field_146292_n.add(this.sliderClusterSize);
        this.loadPlantNames();
        this.plantList.setTextArray(this.arrayPlantNames);
        this.listItemSelected(this.plantList, 0);
    }

    private void updateControls() {
        if (this.arrayPlantNames.size() > 0) {
            PMPDataPlantSpawnParams params = this.decorator.getPlantFromListByName(this.decoratorArea, this.plantList.getSelectedItemText());
            if (params != null) {
                this.sliderGenRate.setIntValue(params.generationWeight);
                this.sliderGenRate.updateDisplayString();
                this.sliderGenRate.field_146124_l = true;
                this.buttonOverwriteVanilla.setButtonState(params.overwriteVanilla);
                boolean bl = this.buttonOverwriteVanilla.field_146124_l = this.decoratorArea != PMPDecoratorArea.EPIPHYTE;
                if (this.decoratorArea == PMPDecoratorArea.EPIPHYTE || this.decoratorArea == PMPDecoratorArea.VINE || this.decoratorArea == PMPDecoratorArea.WATER_FLOATING || this.decoratorArea == PMPDecoratorArea.WATER_IMMERSED) {
                    this.sliderElevationVariance.setIntValue(0);
                    this.sliderElevationVariance.updateDisplayString();
                    this.sliderElevationVariance.field_146124_l = false;
                } else {
                    this.sliderElevationVariance.setIntValue(params.elevationVariance);
                    this.sliderElevationVariance.updateDisplayString();
                    this.sliderElevationVariance.field_146124_l = true;
                }
                this.buttonRemove.field_146124_l = true;
                this.sliderClusterAmount.setIntValue(params.clusterAmount);
                this.sliderClusterAmount.updateDisplayString();
                this.sliderClusterAmount.field_146124_l = this.decoratorArea != PMPDecoratorArea.EPIPHYTE;
                this.sliderClusterSize.setIntValue(params.clusterSize);
                this.sliderClusterSize.updateDisplayString();
                this.sliderClusterSize.field_146124_l = this.decoratorArea != PMPDecoratorArea.EPIPHYTE;
            }
        } else {
            this.sliderGenRate.setIntValue(50);
            this.sliderGenRate.updateDisplayString();
            this.sliderGenRate.field_146124_l = false;
            this.buttonOverwriteVanilla.setButtonState(false);
            this.buttonOverwriteVanilla.field_146124_l = false;
            this.buttonOverwriteVanilla.setButtonState(false);
            this.sliderElevationVariance.setIntValue(0);
            this.sliderElevationVariance.field_146124_l = false;
            this.buttonRemove.field_146124_l = false;
            this.sliderClusterAmount.setIntValue(1);
            this.sliderClusterAmount.updateDisplayString();
            this.sliderClusterAmount.field_146124_l = false;
            this.sliderClusterSize.setIntValue(1);
            this.sliderClusterSize.updateDisplayString();
            this.sliderClusterSize.field_146124_l = false;
        }
        if (this.arrayPlantNames.size() == 0) {
            this.plantIcon = null;
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            PMPDataPlantSpawnParams params = this.decorator.getPlantFromListByName(this.decoratorArea, this.plantList.getSelectedItemText());
            switch (button.field_146127_k) {
                case 2: {
                    plantListState.resetState();
                    this.decorator.saveUserConfig();
                    break;
                }
                case 4: {
                    plantListState.resetState();
                    this.field_146297_k.func_147108_a((GuiScreen)new PMPGuiConfigAddPlant((GuiScreen)this, this.decorator, this.decoratorArea));
                    return;
                }
                case 5: {
                    if (this.plantList.getSize() > 0) {
                        this.decorator.removePlantFromList(this.decoratorArea, params);
                        this.loadPlantNames();
                        plantListState.resetState();
                        this.plantList.resetSelectionScroll();
                        this.listItemSelected(this.plantList, 0);
                    }
                    return;
                }
                case 6: {
                    this.decorator.resetDecoratorArea(this.decoratorArea);
                    this.decorator.saveUserConfig();
                    this.loadPlantNames();
                    plantListState.resetState();
                    this.plantList.resetSelectionScroll();
                    this.listItemSelected(this.plantList, 0);
                    return;
                }
                case 8: {
                    params.overwriteVanilla = !params.overwriteVanilla;
                    this.updateControls();
                    return;
                }
            }
        }
        super.func_146284_a(button);
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        super.func_146286_b(par1, par2, par3);
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.plantList.drawScreen(par1, par2, par3);
        this.drawIconTexture(this.plantIcon, this.field_146294_l / 2 + 167 - 150, 36, true, false);
        super.func_73863_a(par1, par2, par3);
    }

    @Override
    public void listItemSelected(PMPGuiStringList list, int index) {
        if (this.arrayPlantNames.size() > 0) {
            PMPBlockPlant plantBlock = PlantMegaPack.blocks.getPlantBlock(this.arrayPlantNames.get(this.plantList.getSelectedItemIndex()));
            if (plantBlock != null) {
                this.plantIcon = plantBlock.func_149691_a(0, plantBlock.getInventoryIconIndex());
            }
        } else {
            this.plantIcon = null;
        }
        this.updateControls();
    }

    @Override
    public void listItemActivate(PMPGuiStringList list) {
    }

    @Override
    public void updateIntSetting(String name, int value) {
        PMPDataPlantSpawnParams params = this.decorator.getPlantFromListByName(this.decoratorArea, this.plantList.getSelectedItemText());
        if (params != null) {
            if (name.matches("sliderGenRate")) {
                params.generationWeight = this.sliderGenRate.getIntValue();
            } else if (name.matches("gui.slider.clusterAmount")) {
                params.clusterAmount = this.sliderClusterAmount.getIntValue();
            } else if (name.matches("gui.slider.clusterSize")) {
                params.clusterSize = this.sliderClusterSize.getIntValue();
            } else if (name.matches("gui.slider.elevationVariance")) {
                params.elevationVariance = this.sliderElevationVariance.getIntValue();
            }
        }
    }

    private void loadPlantNames() {
        ArrayList<PMPDataPlantSpawnParams> list = this.decorator.getPlantList(this.decoratorArea);
        this.arrayPlantNames.clear();
        if (list != null && list.size() > 0) {
            for (int index = 0; index < list.size(); ++index) {
                this.arrayPlantNames.add(list.get((int)index).plantName);
            }
            this.plantList.setTextArray(this.arrayPlantNames);
            this.plantList.resetSelectionScroll();
        }
    }
}

