/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.gui;

import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import plantmegapack.gui.PMPGuiButton;
import plantmegapack.gui.PMPGuiStringList;

@SideOnly(value=Side.CLIENT)
public abstract class PMPGuiConfigBase
extends GuiScreen {
    public static final ResourceLocation imageLogo = new ResourceLocation("plantmegapack:textures/gui/logoPMP.png");
    public static final ResourceLocation ledGRNOff = new ResourceLocation("plantmegapack:textures/gui/ledGRN0.png");
    public static final ResourceLocation ledGRNOn = new ResourceLocation("plantmegapack:textures/gui/ledGRN1.png");
    public static final ResourceLocation ledREDOff = new ResourceLocation("plantmegapack:textures/gui/ledRED0.png");
    public static final ResourceLocation ledREDOn = new ResourceLocation("plantmegapack:textures/gui/ledRED1.png");
    public static final ResourceLocation ledMIX0 = new ResourceLocation("plantmegapack:textures/gui/ledMIX0.png");
    public static final ResourceLocation ledMIX1 = new ResourceLocation("plantmegapack:textures/gui/ledMIX1.png");
    public static final ResourceLocation ledMIX2 = new ResourceLocation("plantmegapack:textures/gui/ledMIX2.png");
    protected static final int BORDER = 6;
    protected static final int BUTTON_HEIGHT = 20;
    protected static final int BUTTON_WIDTH_LARGE = 180;
    protected static final int BUTTON_WIDTH_MED = 150;
    protected static final int BUTTON_WIDTH_SMALL = 88;
    protected static final int BUTTON_SPACING = 4;
    protected static final int LED_COLOR_GREEN = 0;
    protected static final int LED_COLOR_RED = 1;
    protected static final int LED_HEIGHT = 20;
    protected static final int LED_SPACING = 0;
    protected static final int LED_WIDTH = 6;
    protected static final int LOGO_HEIGHT = 16;
    protected static final int LOGO_WIDTH = 128;
    protected static final int START_Y = 36;
    protected PMPGuiButton buttonDefault;
    protected PMPGuiButton buttonDone;
    protected String name;
    protected GuiScreen parentGuiScreen;
    private int buttonLayout;

    public PMPGuiConfigBase(GuiScreen parentGuiScreen, String screenName, int buttonLayout) {
        this.parentGuiScreen = parentGuiScreen;
        this.name = LanguageRegistry.instance().getStringLocalization(screenName);
        this.buttonLayout = buttonLayout >= -1 && buttonLayout <= 1 ? buttonLayout : 0;
    }

    public void func_73866_w_() {
        int yPos = this.field_146295_m - 27;
        if (this.buttonLayout >= 0) {
            if (this.buttonLayout == 0) {
                int xPos = this.field_146294_l / 2 - 90;
                this.buttonDone = new PMPGuiButton(2, xPos, this.field_146295_m - 27, 180, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
                this.field_146292_n.add(this.buttonDone);
            } else if (this.buttonLayout == 1) {
                int xPos = this.field_146294_l / 2 - 121;
                this.buttonDefault = new PMPGuiButton(1, xPos, yPos, 88, 20, LanguageRegistry.instance().getStringLocalization("gui.button.default"));
                this.buttonDone = new PMPGuiButton(2, xPos += 92, yPos, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
                this.field_146292_n.add(this.buttonDefault);
                this.field_146292_n.add(this.buttonDone);
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        this.drawLogoImage();
        this.drawTitleText();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 1: {
                    this.field_146297_k.func_147108_a((GuiScreen)this);
                    return;
                }
                case 2: {
                    this.field_146297_k.func_147108_a(this.parentGuiScreen);
                    return;
                }
            }
        }
    }

    public void drawLED(int x, int y, int color, boolean indicatorOn) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (color) {
            case 0: {
                this.field_146297_k.field_71446_o.func_110577_a(indicatorOn ? ledGRNOn : ledGRNOff);
                break;
            }
            case 1: {
                this.field_146297_k.field_71446_o.func_110577_a(indicatorOn ? ledREDOn : ledREDOff);
                break;
            }
            default: {
                return;
            }
        }
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)(y + 20), (double)this.field_73735_i, 0.0, 1.0);
        tess.func_78374_a((double)(x + 6), (double)(y + 20), (double)this.field_73735_i, 1.0, 1.0);
        tess.func_78374_a((double)(x + 6), (double)y, (double)this.field_73735_i, 1.0, 0.0);
        tess.func_78374_a((double)x, (double)y, (double)this.field_73735_i, 0.0, 0.0);
        tess.func_78381_a();
    }

    protected void drawLogoImage() {
        if (imageLogo != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(imageLogo);
            int x = (this.field_146294_l - 128) / 2;
            int y = 3;
            Tessellator tess = Tessellator.field_78398_a;
            tess.func_78382_b();
            tess.func_78374_a((double)x, (double)(y + 16), (double)this.field_73735_i, 0.0, 1.0);
            tess.func_78374_a((double)(x + 128), (double)(y + 16), (double)this.field_73735_i, 1.0, 1.0);
            tess.func_78374_a((double)(x + 128), (double)y, (double)this.field_73735_i, 1.0, 0.0);
            tess.func_78374_a((double)x, (double)y, (double)this.field_73735_i, 0.0, 0.0);
            tess.func_78381_a();
        }
    }

    protected void drawTitleText() {
        this.func_73732_a(this.field_146289_q, this.name, this.field_146294_l / 2, 20, 9502624);
    }

    protected void drawIconTexture(IIcon icon, int xPos, int yPos, boolean doubleSize, boolean isItem) {
        if (icon != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.field_78398_a;
            this.field_146297_k.func_147117_R();
            if (isItem) {
                this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110576_c);
            } else {
                this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            }
            tessellator.func_78375_b(0.0f, 0.0f, 0.0f);
            double iconMinU = icon.func_94209_e();
            double iconMinV = icon.func_94206_g();
            double iconMaxU = icon.func_94212_f();
            double iconMaxV = icon.func_94210_h();
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)xPos, (double)(yPos + (doubleSize ? 32 : 20)), (double)this.field_73735_i, iconMinU, iconMaxV);
            tessellator.func_78374_a((double)(xPos + (doubleSize ? 32 : 20)), (double)(yPos + (doubleSize ? 32 : 20)), (double)this.field_73735_i, iconMaxU, iconMaxV);
            tessellator.func_78374_a((double)(xPos + (doubleSize ? 32 : 20)), (double)yPos, (double)this.field_73735_i, iconMaxU, iconMinV);
            tessellator.func_78374_a((double)xPos, (double)yPos, (double)this.field_73735_i, iconMinU, iconMinV);
            tessellator.func_78381_a();
        }
    }

    protected FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public abstract void listItemSelected(PMPGuiStringList var1, int var2);

    public abstract void listItemActivate(PMPGuiStringList var1);

    public abstract void updateIntSetting(String var1, int var2);
}

