/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import plantmegapack.PlantMegaPack;
import plantmegapack.bin.PMPRenderers;
import plantmegapack.common.PMPTab;
import plantmegapack.item.PMPItemWallBracket;

public class PMPBlockWallBracket
extends Block {
    @SideOnly(value=Side.CLIENT)
    protected IIcon modelTexture;
    private int renderType;

    public PMPBlockWallBracket(String blockName, int renderTP) {
        super(Material.field_151575_d);
        this.func_149711_c(0.2f);
        this.func_149663_c(blockName);
        this.func_149647_a(PlantMegaPack.creativeTabs.getCreativeTab(PMPTab.build));
        this.renderType = renderTP < 0 || renderTP > 1 ? 0 : renderTP;
        GameRegistry.registerBlock((Block)this, PMPItemWallBracket.class, (String)blockName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister icon) {
        String name = this.func_149739_a().substring(5);
        this.field_149761_L = icon.func_94245_a("plantmegapack:" + name + "0");
        this.modelTexture = icon.func_94245_a("plantmegapack:" + name + "1");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metaData) {
        if (metaData == 1) {
            return this.modelTexture;
        }
        return this.field_149761_L;
    }

    public int func_149645_b() {
        if (this.renderType == 0) {
            return PMPRenderers.renderWallBracketID;
        }
        if (this.renderType == 1) {
            return PMPRenderers.renderWallBracketMetalID;
        }
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metaData) {
        int j1 = metaData;
        if ((j1 == 0 || side == 2) && this.canAttachToBlock(world, x, y, z + 1)) {
            j1 = 2;
        }
        if ((j1 == 0 || side == 3) && this.canAttachToBlock(world, x, y, z - 1)) {
            j1 = 3;
        }
        if ((j1 == 0 || side == 4) && this.canAttachToBlock(world, x + 1, y, z)) {
            j1 = 4;
        }
        if ((j1 == 0 || side == 5) && this.canAttachToBlock(world, x - 1, y, z)) {
            j1 = 5;
        }
        return j1;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        boolean result = true;
        int metaData = world.func_72805_g(x, y, z);
        switch (metaData) {
            case 2: {
                result = this.canAttachToBlock(world, x, y, z + 1);
                break;
            }
            case 3: {
                result = this.canAttachToBlock(world, x, y, z - 1);
                break;
            }
            case 4: {
                result = this.canAttachToBlock(world, x + 1, y, z);
                break;
            }
            case 5: {
                result = this.canAttachToBlock(world, x - 1, y, z);
                break;
            }
        }
        return result;
    }

    private boolean canAttachToBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.func_149747_d((IBlockAccess)world, x, y, z, 0);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return this.canAttachToBlock(world, x - 1, y, z) || this.canAttachToBlock(world, x + 1, y, z) || this.canAttachToBlock(world, x, y, z - 1) || this.canAttachToBlock(world, x, y, z + 1);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if (this.renderType == 1) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        int metaData = world.func_72805_g(x, y, z);
        switch (metaData) {
            case 2: {
                this.func_149676_a(0.25f, 0.0f, 0.43f, 0.75f, 0.5f, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(0.25f, 0.0f, 0.0f, 0.75f, 0.5f, 0.57f);
                break;
            }
            case 4: {
                this.func_149676_a(0.43f, 0.0f, 0.25f, 1.0f, 0.5f, 0.75f);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, 0.0f, 0.25f, 0.57f, 0.5f, 0.75f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

