/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import plantmegapack.PlantMegaPack;
import plantmegapack.bin.PMPRenderers;
import plantmegapack.common.PMPFlowerColor;
import plantmegapack.common.PMPPlantCategory;
import plantmegapack.common.PMPPlantGrowthType;
import plantmegapack.common.PMPPlantRenderType;
import plantmegapack.common.PMPPlantSoilType;
import plantmegapack.data.PMPDataPlant;
import plantmegapack.item.PMPItemPlant;
import plantmegapack.worldgen.PMPGenBase;

public class PMPBlockPlant
extends BlockBush
implements IPlantable,
IShearable {
    public PMPDataPlant plantData = null;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] textures;
    public ArrayList<PMPFlowerColor> colorMap = null;
    public static int renderPass;

    public PMPBlockPlant(PMPDataPlant plantData) {
        super(plantData.attributes.category == PMPPlantCategory.CORAL || plantData.attributes.category == PMPPlantCategory.FRESHWATER || plantData.attributes.category == PMPPlantCategory.SALTWATER ? Material.field_151586_h : Material.field_151585_k);
        this.plantData = plantData;
        renderPass = 1;
        this.func_149663_c(this.plantData.attributes.ID);
        this.func_149675_a(true);
        switch (this.plantData.attributes.breakSound) {
            case GRASS: {
                this.func_149672_a(Block.field_149779_h);
                break;
            }
            case GRAVEL: {
                this.func_149672_a(Block.field_149767_g);
                break;
            }
            case WOOD: {
                this.func_149672_a(Block.field_149766_f);
                break;
            }
            default: {
                this.func_149672_a(Block.field_149779_h);
            }
        }
        this.func_149647_a(PlantMegaPack.creativeTabs.getCreativeTab(plantData.attributes.category.creativeTab));
        GameRegistry.registerBlock((Block)this, PMPItemPlant.class, (String)plantData.attributes.ID);
        OreDictionary.registerOre((String)plantData.attributes.ID, (Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        block17: {
            int iconsToLoad;
            int growthStages;
            block25: {
                block26: {
                    block24: {
                        String iconName;
                        block23: {
                            block22: {
                                block19: {
                                    block21: {
                                        block20: {
                                            block18: {
                                                block16: {
                                                    iconsToLoad = growthStages = this.plantData.attributes.growthStages;
                                                    iconName = this.func_149739_a().substring(5);
                                                    if (this.plantData.attributes.category != PMPPlantCategory.BERRYBUSH) break block16;
                                                    this.textures = new IIcon[growthStages];
                                                    this.textures[0] = ir.func_94245_a("plantmegapack:berrybushBare");
                                                    for (int count = 1; count < growthStages; ++count) {
                                                        this.textures[count] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID + String.valueOf(count));
                                                    }
                                                    break block17;
                                                }
                                                if (this.plantData.attributes.category != PMPPlantCategory.EPIPHYTE) break block18;
                                                if (this.plantData.attributes.renderSubtype == 2) {
                                                    this.textures = new IIcon[3];
                                                    for (int count = 0; count < 3; ++count) {
                                                        this.textures[count] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID + String.valueOf(count));
                                                    }
                                                } else if (this.plantData.attributes.growthStages > 1) {
                                                    this.textures = new IIcon[iconsToLoad];
                                                    for (int count = 0; count < iconsToLoad; ++count) {
                                                        this.textures[count] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID + String.valueOf(count));
                                                    }
                                                } else {
                                                    this.textures = new IIcon[1];
                                                    this.textures[0] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID);
                                                }
                                                break block17;
                                            }
                                            if (this.plantData.attributes.category != PMPPlantCategory.FLOATING) break block19;
                                            if (this.plantData.attributes.renderType != PMPPlantRenderType.FLOATING_FLAT) break block20;
                                            this.textures = new IIcon[1];
                                            this.textures[0] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID + "0");
                                            break block17;
                                        }
                                        if (this.plantData.attributes.renderType != PMPPlantRenderType.FLOATING_FLOWER) break block21;
                                        this.textures = new IIcon[this.colorMap.size() + 1];
                                        this.textures[this.colorMap.size()] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID + "0");
                                        for (int count = 0; count < this.colorMap.size(); ++count) {
                                            this.textures[count] = ir.func_94245_a("plantmegapack:" + iconName + this.colorMap.get((int)count).ID);
                                        }
                                        break block17;
                                    }
                                    if (this.plantData.attributes.renderType != PMPPlantRenderType.FLOATING_PLANT) break block17;
                                    this.textures = new IIcon[2];
                                    this.textures[0] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID + "0");
                                    this.textures[1] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID + "1");
                                    break block17;
                                }
                                if (this.plantData.attributes.category != PMPPlantCategory.FLOWER_MULTI) break block22;
                                this.textures = new IIcon[this.colorMap.size()];
                                for (int count = 0; count < this.colorMap.size(); ++count) {
                                    this.textures[count] = ir.func_94245_a("plantmegapack:" + iconName + this.colorMap.get((int)count).ID);
                                }
                                break block17;
                            }
                            if (this.plantData.attributes.category != PMPPlantCategory.GROUNDCOVER) break block23;
                            this.textures = new IIcon[1];
                            this.textures[0] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID);
                            break block17;
                        }
                        if (!this.isImmersedPlant()) break block24;
                        iconsToLoad = this.plantData.attributes.category == PMPPlantCategory.CROP_AQUATIC ? 10 : (this.plantData.attributes.growthType == PMPPlantGrowthType.NORMAL ? 6 : 9);
                        this.textures = new IIcon[iconsToLoad];
                        for (int count = 0; count < iconsToLoad; ++count) {
                            this.textures[count] = ir.func_94245_a("plantmegapack:" + iconName + String.valueOf(count));
                        }
                        break block17;
                    }
                    if (this.plantData.attributes.category != PMPPlantCategory.VINE) break block25;
                    if (this.plantData.attributes.renderType != PMPPlantRenderType.VINE_FLOWER && this.plantData.attributes.renderType != PMPPlantRenderType.VINE_NORMAL) break block26;
                    iconsToLoad = 3;
                    this.textures = new IIcon[iconsToLoad];
                    for (int count = 0; count < iconsToLoad; ++count) {
                        this.textures[count] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID + String.valueOf(count));
                    }
                    break block17;
                }
                if (this.plantData.attributes.renderType != PMPPlantRenderType.VINE_RANDOM) break block17;
                iconsToLoad = 5;
                this.textures = new IIcon[iconsToLoad];
                for (int count = 0; count < iconsToLoad; ++count) {
                    this.textures[count] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID + String.valueOf(count));
                }
                break block17;
            }
            if (growthStages == 1) {
                this.textures = new IIcon[1];
                this.textures[0] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID + "0");
            } else {
                if (this.plantData.attributes.growthType == PMPPlantGrowthType.DOUBLE) {
                    iconsToLoad = growthStages * 2 - 2;
                }
                this.textures = new IIcon[iconsToLoad];
                for (int count = 0; count < iconsToLoad; ++count) {
                    this.textures[count] = ir.func_94245_a("plantmegapack:" + this.plantData.attributes.ID + String.valueOf(count));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metaData) {
        if (this.plantData.attributes.category == PMPPlantCategory.EPIPHYTE) {
            if (this.plantData.attributes.renderSubtype == 2 && metaData < this.textures.length) {
                return this.textures[metaData];
            }
            return this.textures[0];
        }
        if (this.plantData.attributes.category == PMPPlantCategory.FLOATING) {
            if (side == 1) {
                if (this.plantData.attributes.renderType == PMPPlantRenderType.FLOATING_FLOWER) {
                    return this.textures[this.colorMap.size()];
                }
                return this.textures[metaData];
            }
            if (metaData < 0 || metaData > this.textures.length - 1) {
                return this.textures[0];
            }
            return this.textures[metaData];
        }
        if (this.isImmersedPlant()) {
            if (metaData < this.textures.length) {
                return this.textures[metaData];
            }
            return null;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.FLOWER_MULTI) {
            if (metaData < 0 || metaData > this.textures.length - 1) {
                return this.textures[0];
            }
            return this.textures[metaData];
        }
        if (this.plantData.attributes.category == PMPPlantCategory.VINE) {
            if (side >= 0) {
                return this.textures[0];
            }
            if (side == -1) {
                return metaData < this.textures.length ? this.textures[metaData] : this.textures[0];
            }
        }
        if (this.textures.length == 0) {
            return Blocks.field_150330_I.func_149691_a(side, metaData);
        }
        return metaData < this.textures.length ? this.textures[metaData] : this.textures[0];
    }

    private boolean canPlantGrowHere(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metaData = world.func_72805_g(x, y, z);
        if (this.plantData.attributes.category == PMPPlantCategory.EPIPHYTE) {
            block = world.func_147439_a(x, y, z + 1);
            if (PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.WOOD, block)) {
                return true;
            }
            block = world.func_147439_a(x, y, z - 1);
            if (PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.WOOD, block)) {
                return true;
            }
            block = world.func_147439_a(x + 1, y, z);
            if (PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.WOOD, block)) {
                return true;
            }
            block = world.func_147439_a(x - 1, y, z);
            if (PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.WOOD, block)) {
                return true;
            }
        } else if (this.plantData.attributes.category == PMPPlantCategory.FLOATING || this.isImmersedPlant()) {
            return this.canBlockSustainPlant((IBlockAccess)world, x, y - 1, z);
        }
        int i1 = metaData;
        if (this.plantData.attributes.category == PMPPlantCategory.VINE) {
            if (metaData > 0) {
                for (int j1 = 0; j1 <= 3; ++j1) {
                    int k1 = 1 << j1;
                    if ((metaData & k1) == 0 || this.canVineAttachHere(world.func_147439_a(x + Direction.field_71583_a[j1], y, z + Direction.field_71581_b[j1])) || world.func_147439_a(x, y + 1, z) == this && (world.func_72805_g(x, y + 1, z) & k1) != 0) continue;
                    i1 &= ~k1;
                }
            }
            if (i1 == 0 && !this.canVineAttachHere(world.func_147439_a(x, y + 1, z))) {
                return false;
            }
            if (i1 != metaData) {
                world.func_72921_c(x, y, z, i1, 3);
            }
            return true;
        }
        if (this.plantData.attributes.growthType == PMPPlantGrowthType.SEAWEED) {
            return this.canBlockSustainPlant((IBlockAccess)world, x, y - 1, z) && (world.func_147439_a(x, y + 1, z) == Blocks.field_150355_j || world.func_147439_a(x, y + 1, z) == this);
        }
        if (this.plantData.attributes.category == PMPPlantCategory.CORAL || this.plantData.attributes.category == PMPPlantCategory.FRESHWATER || this.plantData.attributes.category == PMPPlantCategory.SALTWATER) {
            block = world.func_147439_a(x, y + 1, z);
            return block.func_149688_o() == Material.field_151586_h;
        }
        if (this.plantData.attributes.growthType == PMPPlantGrowthType.DOUBLE && (metaData == 3 || metaData == 5 || metaData == 7)) {
            block = world.func_147439_a(x, y - 1, z);
            return block == this;
        }
        return world.func_147439_a(x, y - 1, z).canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public boolean canBlockSustainPlant(IBlockAccess world, int x, int y, int z) {
        return this.canSustainPlant(world, x, y, z, ForgeDirection.UP, this);
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        Block block = world.func_147439_a(x, y, z);
        int metaData = world.func_72805_g(x, y, z);
        if (this.plantData.attributes.category == PMPPlantCategory.FLOATING) {
            return block.func_149688_o() == Material.field_151586_h && metaData == 0;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.VINE) {
            return true;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.BEACH) {
            return PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.DIRT, block) || PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.SAND, block);
        }
        if (this.plantData.attributes.category == PMPPlantCategory.GRASS) {
            return PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.DIRT, block) || PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.GRAVEL, block) || PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.SAND, block);
        }
        if (this.plantData.attributes.category == PMPPlantCategory.GROUNDCOVER) {
            return PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.CROP, block) || PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.DIRT, block) || PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.GRAVEL, block) || PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.SAND, block) || PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.STONE, block);
        }
        if (this.isImmersedPlant()) {
            if (world.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h) {
                block = world.func_147439_a(x, y - 1, z);
                return PlantMegaPack.soilBlocks.canPlantOnThisBlock(this.plantData.attributes.soilType, block);
            }
            return false;
        }
        if (this.plantData.attributes.growthType == PMPPlantGrowthType.SEAWEED) {
            return PlantMegaPack.soilBlocks.canPlantOnThisBlock(this.plantData.attributes.soilType, block) || world.func_147439_a(x, y, z) == this;
        }
        switch (this.plantData.attributes.growthType) {
            case DOUBLE: {
                if (block != this) break;
                return metaData == 2 || metaData == 4 || metaData == 6;
            }
            case EPIPHYTE: {
                return true;
            }
            case NORMAL: {
                break;
            }
            case SEAWEED: {
                if (block != this) break;
                return true;
            }
            case STALK: {
                if (block != this) break;
                return true;
            }
        }
        return PlantMegaPack.soilBlocks.canPlantOnThisBlock(this.plantData.attributes.soilType, block);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (this.plantData.attributes.category == PMPPlantCategory.BAMBOO && !PlantMegaPack.settings.plantBambooFallsWhenBroken) {
            return true;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.EPIPHYTE) {
            int metaData = world.func_72805_g(x, y, z);
            switch (metaData) {
                case 2: {
                    block = world.func_147439_a(x, y, z + 1);
                    break;
                }
                case 3: {
                    block = world.func_147439_a(x, y, z - 1);
                    break;
                }
                case 4: {
                    block = world.func_147439_a(x + 1, y, z);
                    break;
                }
                case 5: {
                    block = world.func_147439_a(x - 1, y, z);
                    break;
                }
                default: {
                    return false;
                }
            }
            return block.func_149688_o() == Material.field_151575_d;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.FLOATING) {
            return block.func_149688_o() == Material.field_151586_h && world.func_72805_g(x, y - 1, z) == 0;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.VINE) {
            return true;
        }
        if (this.plantData.attributes.growthType == PMPPlantGrowthType.SEAWEED) {
            return this.canPlantGrowHere(world, x, y, z);
        }
        return this.func_149742_c(world, x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (PlantMegaPack.settings.contentAquatic && (this.plantData.attributes.category == PMPPlantCategory.CORAL || this.plantData.attributes.category == PMPPlantCategory.FRESHWATER || this.plantData.attributes.category == PMPPlantCategory.SALTWATER)) {
            return block.func_149688_o() == Material.field_151586_h && this.canPlantGrowHere(world, x, y, z);
        }
        if (this.plantData.attributes.category == PMPPlantCategory.EPIPHYTE) {
            return PMPGenBase.isAdjacentToLogBlock(world, x, y, z, false) > 0;
        }
        if (this.isImmersedPlant()) {
            return this.canPlantGrowHere(world, x, y, z);
        }
        if (this.plantData.attributes.category == PMPPlantCategory.VINE) {
            return super.func_149742_c(world, x, y, z);
        }
        if (PMPGenBase.canReplaceBlockWithPlant(world, x, y, z, true)) {
            return this.canPlantGrowHere(world, x, y, z);
        }
        return false;
    }

    public int func_149692_a(int metaData) {
        return metaData;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        if (this.plantData.attributes.category == PMPPlantCategory.FLOATING) {
            if (entity == null || !(entity instanceof EntityBoat)) {
                super.func_149743_a(world, x, y, z, mask, list, entity);
            }
        } else {
            super.func_149743_a(world, x, y, z, mask, list, entity);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int metaData = world.func_72805_g(x, y, z);
        float pixel = 0.0625f;
        if (this.plantData.attributes.category == PMPPlantCategory.BAMBOO) {
            return AxisAlignedBB.func_72330_a((double)((float)x + 0.2f), (double)y, (double)((float)z + 0.2f), (double)((float)x + 0.8f), (double)((float)y + 1.0f), (double)((float)z + 0.8f));
        }
        if (this.plantData.attributes.category == PMPPlantCategory.EPIPHYTE && PlantMegaPack.settings.plantSolidShelfEpiphytes && this.plantData.attributes.renderType == PMPPlantRenderType.EPIPHYTE_HORIZONTAL) {
            switch (metaData) {
                case 2: {
                    return AxisAlignedBB.func_72330_a((double)((float)x + (0.5f - (float)this.plantData.attributes.hitX1 * pixel)), (double)((float)y + 0.312f), (double)((float)z + (1.0f - (float)this.plantData.attributes.hitY1 * pixel)), (double)((float)x + (0.5f + (float)this.plantData.attributes.hitX1 * pixel)), (double)((float)y + 0.688f), (double)((float)z + (0.5f + (float)this.plantData.attributes.hitY1 * pixel)));
                }
                case 3: {
                    return AxisAlignedBB.func_72330_a((double)((float)x + (0.5f - (float)this.plantData.attributes.hitX1 * pixel)), (double)((float)y + 0.312f), (double)((float)z + 0.0f), (double)((float)x + (0.5f + (float)this.plantData.attributes.hitX1 * pixel)), (double)((float)y + 0.688f), (double)((float)z + (float)this.plantData.attributes.hitY1 * pixel));
                }
                case 4: {
                    return AxisAlignedBB.func_72330_a((double)((float)x + (1.0f - (float)this.plantData.attributes.hitY1 * pixel)), (double)((float)y + 0.312f), (double)((float)z + (0.5f - (float)this.plantData.attributes.hitX1 * pixel)), (double)((float)x + 1.0f), (double)((float)y + 0.688f), (double)((float)z + (0.5f + (float)this.plantData.attributes.hitX1 * pixel)));
                }
                case 5: {
                    return AxisAlignedBB.func_72330_a((double)((float)x + 0.0f), (double)((float)y + 0.312f), (double)((float)z + (0.5f - (float)this.plantData.attributes.hitX1 * pixel)), (double)((float)x + (float)this.plantData.attributes.hitY1 * pixel), (double)((float)y + 0.688f), (double)((float)z + (0.5f + (float)this.plantData.attributes.hitX1 * pixel)));
                }
            }
        }
        return null;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        if (this.hasFlowerColors()) {
            return world.func_72805_g(x, y, z);
        }
        return 0;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metaData, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.plantData.attributes.category == PMPPlantCategory.BAMBOO) {
            ret.add(new ItemStack((Block)this, 1, 0));
            return ret;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.BERRYBUSH) {
            ret.add(new ItemStack((Block)this, this.plantData.dropAlways, 0));
            if (world.field_73012_v.nextInt(100) < this.plantData.dropRandomChance) {
                ret.add(new ItemStack((Block)this, this.plantData.dropRandomAmount, 0));
            }
            if (this.isFullyGrown(metaData)) {
                ret.add(this.getBerryItemStack(metaData, 1));
                if (world.field_73012_v.nextInt(100) < this.plantData.dropRandomChance) {
                    ret.add(this.getBerryItemStack(metaData, this.plantData.dropRandomAmount));
                }
            }
        } else if (this.plantData.attributes.ID.matches("cactusPricklyPear")) {
            ret.add(new ItemStack((Block)this, this.plantData.dropAlways, 0));
            if (this.isFullyGrown(metaData)) {
                ret.add(new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodPricklyPearFruit"), 1, 0));
                if (world.field_73012_v.nextInt(100) < this.plantData.dropRandomChance) {
                    ret.add(new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodPricklyPearFruit"), this.plantData.dropRandomAmount, 0));
                }
            }
        } else if (this.plantData.attributes.category == PMPPlantCategory.CROP_AQUATIC) {
            boolean isRicePlant;
            boolean bl = isRicePlant = this.plantData.attributes.ID.matches("cropRice") || this.plantData.attributes.ID.matches("cropWildRice");
            if (isRicePlant) {
                ret.add(this.getFoodItemStack(this.plantData.attributes.ID, this.plantData.dropAlways));
            } else {
                ret.add(new ItemStack((Block)this, this.plantData.dropAlways, 0));
            }
            if (this.isFullyGrown(metaData)) {
                ItemStack tempItemStack = this.getFoodItemStack(this.plantData.attributes.ID, 1);
                if (tempItemStack != null) {
                    ret.add(tempItemStack);
                }
                if (!isRicePlant && world.field_73012_v.nextInt(100) < this.plantData.dropRandomChance) {
                    ret.add(new ItemStack((Block)this, Math.max(this.plantData.dropRandomAmount, 2), 0));
                }
                if (world.field_73012_v.nextInt(100) < this.plantData.dropRandomChance && (tempItemStack = this.getFoodItemStack(this.plantData.attributes.ID, this.plantData.dropRandomAmount)) != null) {
                    ret.add(tempItemStack);
                }
            }
        } else if (this.plantData.attributes.category == PMPPlantCategory.CROP_LAND) {
            ret.add(this.getSeedItemStack(this.plantData.attributes.ID, Math.max(1, this.plantData.dropAlways)));
            if (this.isFullyGrown(metaData)) {
                ret.add(this.getFoodItemStack(this.plantData.attributes.ID, 1));
                if (world.field_73012_v.nextInt(100) < this.plantData.dropRandomChance) {
                    ret.add(this.getFoodItemStack(this.plantData.attributes.ID, this.plantData.dropRandomAmount));
                }
                if (world.field_73012_v.nextInt(100) < this.plantData.dropRandomChance) {
                    ret.add(this.getSeedItemStack(this.plantData.attributes.ID, this.plantData.dropRandomAmount));
                }
            }
        } else if (this.plantData.attributes.ID.matches("epiphyteHarlequinMistletoe")) {
            ret.add(new ItemStack((Block)this, this.plantData.dropAlways, 0));
            if (world.field_73012_v.nextInt(100) < this.plantData.dropRandomChance) {
                ret.add(new ItemStack((Item)PlantMegaPack.items.getFoodItem("berriesHarlequinMistletoe"), this.plantData.dropRandomAmount, 0));
            }
        } else if (this.plantData.attributes.ID.matches("flowerQuinoa")) {
            ret.add(new ItemStack((Block)this, this.plantData.dropAlways, 0));
            if (this.isFullyGrown(metaData)) {
                ret.add(new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodQuinoaSeeds"), 1, 0));
                if (world.field_73012_v.nextInt(100) < this.plantData.dropRandomChance) {
                    ret.add(new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodQuinoaSeeds"), this.plantData.dropRandomAmount, 0));
                }
            }
        } else if (this.plantData.attributes.ID.matches("oceanMozuku")) {
            ret.add(new ItemStack((Block)this, this.plantData.dropAlways, 0));
            if (world.field_73012_v.nextInt(100) < this.plantData.dropRandomChance) {
                ret.add(new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodMozukuSeaweed"), this.plantData.dropRandomAmount, 0));
            }
        } else if (this.plantData.attributes.category != PMPPlantCategory.FLOATING && this.plantData.attributes.category != PMPPlantCategory.VINE) {
            if (this.hasFlowerColors()) {
                ret.add(new ItemStack((Block)this, this.plantData.dropAlways, metaData));
                if (world.field_73012_v.nextInt(100) < this.plantData.dropRandomChance) {
                    ret.add(new ItemStack((Block)this, this.plantData.dropRandomAmount, metaData));
                }
            } else {
                ret.add(new ItemStack((Block)this, this.plantData.dropAlways, 0));
                if (world.field_73012_v.nextInt(100) < this.plantData.dropRandomChance) {
                    ret.add(new ItemStack((Block)this, this.plantData.dropRandomAmount, 0));
                }
            }
        }
        return ret;
    }

    public String getLatinName() {
        return LanguageRegistry.instance().getStringLocalization(this.func_149739_a() + ".snam");
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        if (this.plantData.attributes.category == PMPPlantCategory.CROP_LAND) {
            return this.getSeedItemStack(this.plantData.attributes.ID, 1);
        }
        if (this.hasFlowerColors()) {
            return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
        }
        return new ItemStack((Block)this, 1, 0);
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        if (this.plantData.attributes.category == PMPPlantCategory.BAMBOO && block != blockBelow) {
            return 4;
        }
        return world.func_72805_g(x, y, z);
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        switch (this.plantData.attributes.category) {
            case CAVE: {
                return EnumPlantType.Cave;
            }
            case CROP_AQUATIC: 
            case IMMERSED: {
                return EnumPlantType.Plains;
            }
            case FRESHWATER: 
            case SALTWATER: {
                return EnumPlantType.Water;
            }
            case CROP_LAND: {
                return EnumPlantType.Crop;
            }
            case CACTUS: {
                return EnumPlantType.Desert;
            }
            case NETHER: {
                return EnumPlantType.Nether;
            }
        }
        return EnumPlantType.Plains;
    }

    public int func_149645_b() {
        return PMPRenderers.getRendererFromRenderType(this.plantData.attributes.renderType);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        if (this.hasFlowerColors()) {
            for (int count = 0; count < this.colorMap.size(); ++count) {
                subItems.add(new ItemStack((Block)this, 1, count));
            }
        } else {
            super.func_149666_a(item, tab, subItems);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return this.plantData.attributes.category == PMPPlantCategory.GRASS || this.plantData.attributes.category == PMPPlantCategory.GROUNDCOVER;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int metaData = world.func_72805_g(x, y, z);
        if (this.plantData.attributes.category == PMPPlantCategory.BERRYBUSH && this.isFullyGrown(metaData)) {
            int plantDrops = this.plantData.dropAlways;
            int randomChance = world.field_73012_v.nextInt(100);
            if (randomChance < this.plantData.dropRandomChance * 100) {
                plantDrops += world.field_73012_v.nextInt(this.plantData.dropRandomAmount);
            }
            this.func_149642_a(world, x, y, z, this.getBerryItemStack(metaData, plantDrops));
            world.func_72921_c(x, y, z, 0, 3);
            return true;
        }
        return false;
    }

    public void func_149664_b(World world, int x, int y, int z, int metaData) {
        if (this.plantData.attributes.soilType == PMPPlantSoilType.AQUATIC) {
            if (this.isImmersedPlant()) {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
            } else {
                world.func_147449_b(x, y, z, Blocks.field_150355_j);
            }
        } else if (this.plantData.attributes.growthType == PMPPlantGrowthType.DOUBLE) {
            switch (metaData) {
                case 2: 
                case 4: 
                case 6: {
                    if (world.func_147439_a(x, y + 1, z) != this) break;
                    if (this.plantData.attributes.category == PMPPlantCategory.CORAL || this.plantData.attributes.category == PMPPlantCategory.FRESHWATER || this.plantData.attributes.category == PMPPlantCategory.SALTWATER) {
                        world.func_147449_b(x, y + 1, z, Blocks.field_150355_j);
                        break;
                    }
                    world.func_147468_f(x, y + 1, z);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    if (world.func_147439_a(x, y - 1, z) != this) break;
                    if (this.plantData.attributes.category == PMPPlantCategory.CORAL || this.plantData.attributes.category == PMPPlantCategory.FRESHWATER || this.plantData.attributes.category == PMPPlantCategory.SALTWATER) {
                        world.func_147449_b(x, y - 1, z, Blocks.field_150355_j);
                        break;
                    }
                    world.func_147468_f(x, y - 1, z);
                    break;
                }
            }
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        if (entity == null) {
            return;
        }
        if (this.plantData.attributes.renderType == PMPPlantRenderType.FLAT) {
            int direction = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 8.0f / 360.0f) + 0.5)) & 3;
            world.func_72921_c(x, y, z, direction, 3);
            return;
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metaData) {
        if (this.plantData.attributes.category == PMPPlantCategory.BAMBOO) {
            return 4;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.EPIPHYTE) {
            int j1 = world.func_72805_g(x, y, z);
            Block block = world.func_147439_a(x, y, z + 1);
            if ((j1 == 0 || side == 2) && PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.WOOD, block)) {
                j1 = 2;
            }
            block = world.func_147439_a(x, y, z - 1);
            if ((j1 == 0 || side == 3) && PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.WOOD, block)) {
                j1 = 3;
            }
            block = world.func_147439_a(x + 1, y, z);
            if ((j1 == 0 || side == 4) && PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.WOOD, block)) {
                j1 = 4;
            }
            block = world.func_147439_a(x - 1, y, z);
            if ((j1 == 0 || side == 5) && PlantMegaPack.soilBlocks.canPlantOnThisBlock(PMPPlantSoilType.WOOD, block)) {
                j1 = 5;
            }
            return j1;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.VINE) {
            return Blocks.field_150395_bd.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, metaData);
        }
        return metaData;
    }

    public void func_149725_f(World world, int x, int y, int z, int metaData) {
        Block blockBelow;
        Block block;
        if (this.plantData.attributes.category == PMPPlantCategory.BAMBOO && (block = world.func_147439_a(x, y, z)) == (blockBelow = world.func_147439_a(x, y - 1, z))) {
            world.func_72921_c(x, y - 1, z, 4, 3);
            if (this.plantData.attributes.renderSubtype == 1) {
                this.updateBambooFromTop(world, x, y - 1, z);
            }
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity instanceof EntityPlayer || entity instanceof EntityPlayerMP) {
            if (this.plantData.attributes.damagePoison) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 5));
            }
            if (this.plantData.attributes.damageThorns) {
                ((EntityLivingBase)entity).func_70097_a(DamageSource.field_76367_g, 1.0f);
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            if (this.plantData.attributes.category == PMPPlantCategory.VINE) {
                if (!this.func_150094_e(world, x, y, z)) {
                    this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                    world.func_147468_f(x, y, z);
                }
            } else if (world.func_147439_a(x, y, z) == this && !this.func_149718_j(world, x, y, z)) {
                if (this.hasFlowerColors()) {
                    this.func_149642_a(world, x, y, z, new ItemStack(Item.func_150898_a((Block)this), 1, world.func_72805_g(x, y, z)));
                } else if (!this.isTopPlantBlock(world, x, y, z)) {
                    this.func_149642_a(world, x, y, z, new ItemStack(Item.func_150898_a((Block)this), 1, 0));
                }
                if (this.plantData.attributes.category == PMPPlantCategory.CORAL || this.plantData.attributes.category == PMPPlantCategory.FRESHWATER || this.plantData.attributes.category == PMPPlantCategory.SALTWATER) {
                    world.func_147449_b(x, y, z, Blocks.field_150355_j);
                } else {
                    world.func_147468_f(x, y, z);
                }
            }
        }
    }

    public void func_149714_e(World world, int x, int y, int z, int metaData) {
        Block block;
        if (this.plantData.attributes.category == PMPPlantCategory.BAMBOO && (block = world.func_147439_a(x, y - 1, z)) == this) {
            switch (this.plantData.attributes.renderSubtype) {
                case 0: 
                case 1: {
                    this.updateBambooFromTop(world, x, y, z);
                    break;
                }
                case 2: {
                    world.func_72921_c(x, y - 1, z, world.field_73012_v.nextInt(4), 3);
                }
            }
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float bottom;
        int metaData = world.func_72805_g(x, y, z);
        float pixel = 0.0625f;
        float f = bottom = this.isImmersedPlant() ? -1.0f : 0.0f;
        if (this.plantData.attributes.category == PMPPlantCategory.BAMBOO) {
            switch (metaData) {
                case 0: {
                    this.func_149676_a(0.26f, 0.0f, 0.26f, 0.74f, 1.0f, 0.74f);
                    return;
                }
                case 1: {
                    this.func_149676_a(0.22f, 0.0f, 0.22f, 0.78f, 1.0f, 0.78f);
                    return;
                }
                case 2: {
                    this.func_149676_a(0.18f, 0.0f, 0.18f, 0.82f, 1.0f, 0.82f);
                    return;
                }
                case 3: {
                    this.func_149676_a(0.14f, 0.0f, 0.14f, 0.86f, 1.0f, 0.86f);
                    return;
                }
            }
            this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 1.0f, 0.9f);
            return;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.EPIPHYTE) {
            if (this.plantData.attributes.renderType == PMPPlantRenderType.EPIPHYTE_HORIZONTAL) {
                switch (metaData) {
                    case 2: {
                        this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX1 * pixel, 0.312f, 1.0f - (float)this.plantData.attributes.hitY1 * pixel, 0.5f + (float)this.plantData.attributes.hitX1 * pixel, 0.688f, 0.5f + (float)this.plantData.attributes.hitY1 * pixel);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX1 * pixel, 0.312f, 0.0f, 0.5f + (float)this.plantData.attributes.hitX1 * pixel, 0.688f, (float)this.plantData.attributes.hitY1 * pixel);
                        break;
                    }
                    case 4: {
                        this.func_149676_a(1.0f - (float)this.plantData.attributes.hitY1 * pixel, 0.312f, 0.5f - (float)this.plantData.attributes.hitX1 * pixel, 1.0f, 0.688f, 0.5f + (float)this.plantData.attributes.hitX1 * pixel);
                        break;
                    }
                    case 5: {
                        this.func_149676_a(0.0f, 0.312f, 0.5f - (float)this.plantData.attributes.hitX1 * pixel, (float)this.plantData.attributes.hitY1 * pixel, 0.688f, 0.5f + (float)this.plantData.attributes.hitX1 * pixel);
                    }
                }
            } else if (this.plantData.attributes.renderType == PMPPlantRenderType.EPIPHYTE_VERTICAL) {
                switch (metaData) {
                    case 2: {
                        this.func_149676_a(0.125f, 0.125f, 0.125f, 0.875f, 0.875f, 1.0f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.125f, 0.125f, 0.0f, 0.875f, 0.875f, 0.875f);
                        break;
                    }
                    case 4: {
                        this.func_149676_a(0.125f, 0.125f, 0.125f, 1.0f, 0.875f, 0.875f);
                        break;
                    }
                    case 5: {
                        this.func_149676_a(0.0f, 0.125f, 0.125f, 0.875f, 0.875f, 0.875f);
                    }
                }
            } else {
                this.func_149676_a(0.062f, 0.062f, 0.062f, 0.938f, 0.938f, 0.938f);
            }
            return;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.GROUNDCOVER || this.plantData.attributes.renderType == PMPPlantRenderType.FLOATING_FLAT) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.015625f, 1.0f);
            return;
        }
        if (this.plantData.attributes.growthType == PMPPlantGrowthType.DOUBLE) {
            if (this.isImmersedPlant()) {
                switch (metaData) {
                    case 0: {
                        this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX1 * pixel, bottom, 0.5f - (float)this.plantData.attributes.hitX1 * pixel, 0.5f + (float)this.plantData.attributes.hitX1 * pixel, (float)this.plantData.attributes.hitY1 * pixel, 0.5f + (float)this.plantData.attributes.hitX1 * pixel);
                        return;
                    }
                    case 1: {
                        this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX2 * pixel, bottom, 0.5f - (float)this.plantData.attributes.hitX2 * pixel, 0.5f + (float)this.plantData.attributes.hitX2 * pixel, (float)this.plantData.attributes.hitY2 * pixel, 0.5f + (float)this.plantData.attributes.hitX2 * pixel);
                        return;
                    }
                    case 2: {
                        this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX3 * pixel, bottom, 0.5f - (float)this.plantData.attributes.hitX3 * pixel, 0.5f + (float)this.plantData.attributes.hitX3 * pixel, 1.0f, 0.5f + (float)this.plantData.attributes.hitX3 * pixel);
                        return;
                    }
                    case 3: {
                        this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX4 * pixel, bottom, 0.5f - (float)this.plantData.attributes.hitX4 * pixel, 0.5f + (float)this.plantData.attributes.hitX4 * pixel, 1.0f, 0.5f + (float)this.plantData.attributes.hitX4 * pixel);
                        return;
                    }
                    case 4: {
                        this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX5 * pixel, bottom, 0.5f - (float)this.plantData.attributes.hitX5 * pixel, 0.5f + (float)this.plantData.attributes.hitX5 * pixel, 1.0f, 0.5f + (float)this.plantData.attributes.hitX5 * pixel);
                        return;
                    }
                }
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                return;
            }
            switch (metaData) {
                case 0: {
                    this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX1 * pixel, 0.0f, 0.5f - (float)this.plantData.attributes.hitX1 * pixel, 0.5f + (float)this.plantData.attributes.hitX1 * pixel, (float)this.plantData.attributes.hitY1 * pixel, 0.5f + (float)this.plantData.attributes.hitX1 * pixel);
                    return;
                }
                case 1: {
                    this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX2 * pixel, 0.0f, 0.5f - (float)this.plantData.attributes.hitX2 * pixel, 0.5f + (float)this.plantData.attributes.hitX2 * pixel, (float)this.plantData.attributes.hitY2 * pixel, 0.5f + (float)this.plantData.attributes.hitX2 * pixel);
                    return;
                }
                case 2: {
                    this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX3 * pixel, 0.0f, 0.5f - (float)this.plantData.attributes.hitX3 * pixel, 0.5f + (float)this.plantData.attributes.hitX3 * pixel, 1.0f + (float)this.plantData.attributes.hitY3 * pixel, 0.5f + (float)this.plantData.attributes.hitX3 * pixel);
                    return;
                }
                case 3: {
                    this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX3 * pixel, -1.0f, 0.5f - (float)this.plantData.attributes.hitX3 * pixel, 0.5f + (float)this.plantData.attributes.hitX3 * pixel, (float)this.plantData.attributes.hitY3 * pixel, 0.5f + (float)this.plantData.attributes.hitX3 * pixel);
                    return;
                }
                case 4: {
                    this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX4 * pixel, 0.0f, 0.5f - (float)this.plantData.attributes.hitX4 * pixel, 0.5f + (float)this.plantData.attributes.hitX4 * pixel, 1.0f + (float)this.plantData.attributes.hitY4 * pixel, 0.5f + (float)this.plantData.attributes.hitX4 * pixel);
                    return;
                }
                case 5: {
                    this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX4 * pixel, -1.0f, 0.5f - (float)this.plantData.attributes.hitX4 * pixel, 0.5f + (float)this.plantData.attributes.hitX4 * pixel, (float)this.plantData.attributes.hitY4 * pixel, 0.5f + (float)this.plantData.attributes.hitX4 * pixel);
                    return;
                }
                case 6: {
                    this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX5 * pixel, 0.0f, 0.5f - (float)this.plantData.attributes.hitX5 * pixel, 0.5f + (float)this.plantData.attributes.hitX5 * pixel, 1.0f + (float)this.plantData.attributes.hitY5 * pixel, 0.5f + (float)this.plantData.attributes.hitX5 * pixel);
                    return;
                }
                case 7: {
                    this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX5 * pixel, -1.0f, 0.5f - (float)this.plantData.attributes.hitX5 * pixel, 0.5f + (float)this.plantData.attributes.hitX5 * pixel, (float)this.plantData.attributes.hitY5 * pixel, 0.5f + (float)this.plantData.attributes.hitX5 * pixel);
                    return;
                }
            }
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.VINE) {
            boolean flag;
            int l = world.func_72805_g(x, y, z);
            float f1 = 1.0f;
            float f2 = 1.0f;
            float f3 = 1.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            boolean bl = flag = l > 0;
            if ((l & 2) != 0) {
                f4 = Math.max(f4, 0.0625f);
                f1 = 0.0f;
                f2 = 0.0f;
                f5 = 1.0f;
                f3 = 0.0f;
                f6 = 1.0f;
                flag = true;
            }
            if ((l & 8) != 0) {
                f1 = Math.min(f1, 0.9375f);
                f4 = 1.0f;
                f2 = 0.0f;
                f5 = 1.0f;
                f3 = 0.0f;
                f6 = 1.0f;
                flag = true;
            }
            if ((l & 4) != 0) {
                f6 = Math.max(f6, 0.0625f);
                f3 = 0.0f;
                f1 = 0.0f;
                f4 = 1.0f;
                f2 = 0.0f;
                f5 = 1.0f;
                flag = true;
            }
            if ((l & 1) != 0) {
                f3 = Math.min(f3, 0.9375f);
                f6 = 1.0f;
                f1 = 0.0f;
                f4 = 1.0f;
                f2 = 0.0f;
                f5 = 1.0f;
                flag = true;
            }
            if (!flag && this.canVineAttachHere(world.func_147439_a(x, y + 1, z))) {
                f2 = Math.min(f2, 0.9375f);
                f5 = 1.0f;
                f1 = 0.0f;
                f4 = 1.0f;
                f3 = 0.0f;
                f6 = 1.0f;
            }
            this.func_149676_a(f1, f2, f3, f4, f5, f6);
            return;
        }
        if (this.plantData.attributes.growthStages > 1) {
            if (metaData == 0) {
                this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX1 * pixel, bottom, 0.5f - (float)this.plantData.attributes.hitX1 * pixel, 0.5f + (float)this.plantData.attributes.hitX1 * pixel, (float)this.plantData.attributes.hitY1 * pixel, 0.5f + (float)this.plantData.attributes.hitX1 * pixel);
                return;
            }
            if (metaData == 1) {
                this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX2 * pixel, bottom, 0.5f - (float)this.plantData.attributes.hitX2 * pixel, 0.5f + (float)this.plantData.attributes.hitX2 * pixel, (float)this.plantData.attributes.hitY2 * pixel, 0.5f + (float)this.plantData.attributes.hitX2 * pixel);
                return;
            }
            if (metaData == 2) {
                this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX3 * pixel, bottom, 0.5f - (float)this.plantData.attributes.hitX3 * pixel, 0.5f + (float)this.plantData.attributes.hitX3 * pixel, (float)this.plantData.attributes.hitY3 * pixel, 0.5f + (float)this.plantData.attributes.hitX3 * pixel);
                return;
            }
            if (metaData == 3) {
                this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX4 * pixel, bottom, 0.5f - (float)this.plantData.attributes.hitX4 * pixel, 0.5f + (float)this.plantData.attributes.hitX4 * pixel, (float)this.plantData.attributes.hitY4 * pixel, 0.5f + (float)this.plantData.attributes.hitX4 * pixel);
                return;
            }
            if (metaData == 4) {
                this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX5 * pixel, bottom, 0.5f - (float)this.plantData.attributes.hitX5 * pixel, 0.5f + (float)this.plantData.attributes.hitX5 * pixel, (float)this.plantData.attributes.hitY5 * pixel, 0.5f + (float)this.plantData.attributes.hitX5 * pixel);
                return;
            }
        }
        this.func_149676_a(0.5f - (float)this.plantData.attributes.hitX1 * pixel, bottom, 0.5f - (float)this.plantData.attributes.hitX1 * pixel, 0.5f + (float)this.plantData.attributes.hitX1 * pixel, (float)this.plantData.attributes.hitY1 * pixel, 0.5f + (float)this.plantData.attributes.hitX1 * pixel);
    }

    protected boolean func_149854_a(Block block) {
        if (block == null) {
            return false;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.FLOATING || this.isImmersedPlant()) {
            return block.func_149688_o() == Material.field_151586_h;
        }
        return PlantMegaPack.soilBlocks.canPlantOnThisBlock(this.plantData.attributes.soilType, block);
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        if (this.plantData.attributes.category == PMPPlantCategory.VINE) {
            switch (side) {
                case 1: {
                    return this.canVineAttachHere(world.func_147439_a(x, y + 1, z));
                }
                case 2: {
                    return this.canVineAttachHere(world.func_147439_a(x, y, z + 1));
                }
                case 3: {
                    return this.canVineAttachHere(world.func_147439_a(x, y, z - 1));
                }
                case 4: {
                    return this.canVineAttachHere(world.func_147439_a(x + 1, y, z));
                }
                case 5: {
                    return this.canVineAttachHere(world.func_147439_a(x - 1, y, z));
                }
            }
            return false;
        }
        return super.func_149707_d(world, x, y, z, side);
    }

    private boolean canVineAttachHere(Block block) {
        return block.func_149686_d() && block.func_149688_o().func_76230_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return super.func_149635_D();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int data) {
        return super.func_149741_i(data);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return super.func_149720_d(world, x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (this.plantData.attributes.category == PMPPlantCategory.FLOATING || this.plantData.attributes.category == PMPPlantCategory.FLOWER_MULTI) {
            return;
        }
        if (this.plantData.attributes.category == PMPPlantCategory.BAMBOO) {
            Block blockBelow = world.func_147439_a(x, y - 1, z);
            if (this != blockBelow) {
                this.growStalkPlantFromBottom(world, x, y, z);
            }
        } else if (this.plantData.attributes.growthType == PMPPlantGrowthType.SEAWEED) {
            Block blockAbove = world.func_147439_a(x, y + 1, z);
            Block blockAbove2 = world.func_147439_a(x, y + 2, z);
            if (blockAbove.func_149688_o() == Material.field_151586_h && blockAbove2.func_149688_o() == Material.field_151586_h && this.plantData.growthRate > 0 && random.nextInt(100) < this.plantData.growthRate) {
                world.func_147465_d(x, y + 1, z, (Block)this, 0, 2);
            }
        } else if (this.plantData.attributes.category == PMPPlantCategory.VINE) {
            this.updateVineTick(world, x, y, z, random);
        } else if (world.func_147439_a(x, y, z) == this && !this.func_149718_j(world, x, y, z)) {
            this.func_149855_e(world, x, y, z);
        } else if (this.plantData.growthRate > 0 && random.nextInt(100) < this.plantData.growthRate) {
            this.growPlant(world, x, y, z);
        }
    }

    private void updateVineTick(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K && world.field_73012_v.nextInt(4) == 0) {
            int k1;
            int j1;
            int i1;
            int b0 = 4;
            int l = 5;
            boolean flag = false;
            block0: for (i1 = x - b0; i1 <= x + b0; ++i1) {
                for (j1 = z - b0; j1 <= z + b0; ++j1) {
                    for (k1 = y - 1; k1 <= y + 1; ++k1) {
                        if (world.func_147439_a(i1, k1, j1) != this || --l > 0) continue;
                        flag = true;
                        break block0;
                    }
                }
            }
            i1 = world.func_72805_g(x, y, z);
            j1 = world.field_73012_v.nextInt(6);
            k1 = Direction.field_71579_d[j1];
            if (j1 == 1 && y < 255 && world.func_147437_c(x, y + 1, z)) {
                if (flag) {
                    return;
                }
                int j2 = world.field_73012_v.nextInt(16) & i1;
                if (j2 > 0) {
                    for (int l1 = 0; l1 <= 3; ++l1) {
                        if (this.canVineAttachHere(world.func_147439_a(x + Direction.field_71583_a[l1], y + 1, z + Direction.field_71581_b[l1]))) continue;
                        j2 &= ~(1 << l1);
                    }
                    if (j2 > 0) {
                        world.func_147465_d(x, y + 1, z, (Block)this, j2, 2);
                    }
                }
            } else if (j1 >= 2 && j1 <= 5 && (i1 & 1 << k1) == 0) {
                if (flag) {
                    return;
                }
                Block block = world.func_147439_a(x + Direction.field_71583_a[k1], y, z + Direction.field_71581_b[k1]);
                if (block.func_149688_o() == Material.field_151579_a) {
                    int l1 = k1 + 1 & 3;
                    int i2 = k1 + 3 & 3;
                    if ((i1 & 1 << l1) != 0 && this.canVineAttachHere(world.func_147439_a(x + Direction.field_71583_a[k1] + Direction.field_71583_a[l1], y, z + Direction.field_71581_b[k1] + Direction.field_71581_b[l1]))) {
                        world.func_147465_d(x + Direction.field_71583_a[k1], y, z + Direction.field_71581_b[k1], (Block)this, 1 << l1, 2);
                    } else if ((i1 & 1 << i2) != 0 && this.canVineAttachHere(world.func_147439_a(x + Direction.field_71583_a[k1] + Direction.field_71583_a[i2], y, z + Direction.field_71581_b[k1] + Direction.field_71581_b[i2]))) {
                        world.func_147465_d(x + Direction.field_71583_a[k1], y, z + Direction.field_71581_b[k1], (Block)this, 1 << i2, 2);
                    } else if ((i1 & 1 << l1) != 0 && world.func_147437_c(x + Direction.field_71583_a[k1] + Direction.field_71583_a[l1], y, z + Direction.field_71581_b[k1] + Direction.field_71581_b[l1]) && this.canVineAttachHere(world.func_147439_a(x + Direction.field_71583_a[l1], y, z + Direction.field_71581_b[l1]))) {
                        world.func_147465_d(x + Direction.field_71583_a[k1] + Direction.field_71583_a[l1], y, z + Direction.field_71581_b[k1] + Direction.field_71581_b[l1], (Block)this, 1 << (k1 + 2 & 3), 2);
                    } else if ((i1 & 1 << i2) != 0 && world.func_147437_c(x + Direction.field_71583_a[k1] + Direction.field_71583_a[i2], y, z + Direction.field_71581_b[k1] + Direction.field_71581_b[i2]) && this.canVineAttachHere(world.func_147439_a(x + Direction.field_71583_a[i2], y, z + Direction.field_71581_b[i2]))) {
                        world.func_147465_d(x + Direction.field_71583_a[k1] + Direction.field_71583_a[i2], y, z + Direction.field_71581_b[k1] + Direction.field_71581_b[i2], (Block)this, 1 << (k1 + 2 & 3), 2);
                    } else if (this.canVineAttachHere(world.func_147439_a(x + Direction.field_71583_a[k1], y + 1, z + Direction.field_71581_b[k1]))) {
                        world.func_147465_d(x + Direction.field_71583_a[k1], y, z + Direction.field_71581_b[k1], (Block)this, 0, 2);
                    }
                } else if (block.func_149688_o().func_76218_k() && block.func_149686_d()) {
                    world.func_72921_c(x, y, z, i1 | 1 << k1, 3);
                }
            } else if (y > 1) {
                Block block = world.func_147439_a(x, y - 1, z);
                if (block.func_149688_o() == Material.field_151579_a) {
                    int l1 = world.field_73012_v.nextInt(16) & i1;
                    if (l1 > 0) {
                        world.func_147465_d(x, y - 1, z, (Block)this, l1, 2);
                    }
                } else if (block == this) {
                    int l1 = world.field_73012_v.nextInt(16) & i1;
                    int i2 = world.func_72805_g(x, y - 1, z);
                    if (i2 != (i2 | l1)) {
                        world.func_72921_c(x, y - 1, z, i2 | l1, 3);
                    }
                }
            }
        }
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return this.plantData.attributes.category == PMPPlantCategory.VINE;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return this.plantData.attributes.category == PMPPlantCategory.FLOATING || this.plantData.attributes.category == PMPPlantCategory.VINE;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (ret == null) {
            return null;
        }
        if (this.hasFlowerColors()) {
            ret.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z)));
        } else {
            ret.add(new ItemStack((Block)this, 1));
        }
        return ret;
    }

    public boolean growPlant(World world, int x, int y, int z) {
        int growthStage;
        block19: {
            block18: {
                Block block = world.func_147439_a(x, y, z);
                if (block == null || !(block instanceof PMPBlockPlant)) {
                    return false;
                }
                if (this.plantData.attributes.category == PMPPlantCategory.FLOATING || this.plantData.attributes.category == PMPPlantCategory.FLOWER_MULTI || this.plantData.attributes.category == PMPPlantCategory.EPIPHYTE) {
                    return false;
                }
                growthStage = world.func_72805_g(x, y, z);
                if (this.isFullyGrown(world.func_72805_g(x, y, z))) {
                    return false;
                }
                if (this.plantData.attributes.growthType != PMPPlantGrowthType.DOUBLE || this.isImmersedPlant()) break block18;
                switch (growthStage) {
                    case 0: {
                        world.func_72921_c(x, y, z, 1, 2);
                        return true;
                    }
                    case 1: {
                        if (world.func_147437_c(x, y + 1, z) && this.plantData.attributes.growthStages > 2) {
                            world.func_72921_c(x, y, z, 2, 2);
                            world.func_147465_d(x, y + 1, z, block, 3, 2);
                            return true;
                        }
                        break block19;
                    }
                    case 2: {
                        if (world.func_147439_a(x, y + 1, z) == block && this.plantData.attributes.growthStages > 3) {
                            world.func_72921_c(x, y, z, 4, 2);
                            world.func_72921_c(x, y + 1, z, 5, 2);
                            return true;
                        }
                        break block19;
                    }
                    case 3: {
                        if (world.func_147439_a(x, y - 1, z) == block && this.plantData.attributes.growthStages > 3) {
                            world.func_72921_c(x, y, z, 5, 2);
                            world.func_72921_c(x, y - 1, z, 4, 2);
                            return true;
                        }
                        break block19;
                    }
                    case 4: {
                        if (world.func_147439_a(x, y + 1, z) == block && this.plantData.attributes.growthStages > 4) {
                            world.func_72921_c(x, y, z, 6, 2);
                            world.func_72921_c(x, y + 1, z, 7, 2);
                            return true;
                        }
                        break block19;
                    }
                    case 5: {
                        if (world.func_147439_a(x, y - 1, z) == block && this.plantData.attributes.growthStages > 4) {
                            world.func_72921_c(x, y, z, 7, 2);
                            world.func_72921_c(x, y - 1, z, 6, 2);
                            return true;
                        }
                        break block19;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (this.plantData.attributes.category == PMPPlantCategory.BAMBOO) {
                return this.growStalkPlantFromBottom(world, x, y, z);
            }
        }
        if (++growthStage < this.plantData.attributes.growthStages) {
            world.func_72921_c(x, y, z, growthStage, 2);
            return true;
        }
        return false;
    }

    public int getInventoryIconIndex() {
        return this.plantData.attributes.invIconIndex;
    }

    public boolean hasFlowerColors() {
        return this.plantData.attributes.renderType == PMPPlantRenderType.FLOATING_FLOWER || this.plantData.attributes.category == PMPPlantCategory.FLOWER_MULTI;
    }

    public boolean isFullyGrown(int metaData) {
        if (this.plantData.attributes.category == PMPPlantCategory.FLOATING || this.plantData.attributes.category == PMPPlantCategory.FLOWER_MULTI || this.plantData.attributes.category == PMPPlantCategory.GROUNDCOVER || this.plantData.attributes.category == PMPPlantCategory.VINE || this.plantData.attributes.category == PMPPlantCategory.EPIPHYTE) {
            return true;
        }
        if (this.plantData.attributes.growthType == PMPPlantGrowthType.SEAWEED || this.plantData.attributes.growthType == PMPPlantGrowthType.STALK) {
            return false;
        }
        if (this.plantData.attributes.growthType == PMPPlantGrowthType.DOUBLE && !this.isImmersedPlant()) {
            if ((metaData == 4 || metaData == 5) && this.plantData.attributes.growthStages == 4) {
                return true;
            }
            return (metaData == 6 || metaData == 7) && this.plantData.attributes.growthStages == 5;
        }
        return metaData == this.plantData.attributes.growthStages - 1;
    }

    public boolean isImmersedPlant() {
        return this.plantData.attributes.category == PMPPlantCategory.CROP_AQUATIC || this.plantData.attributes.category == PMPPlantCategory.IMMERSED;
    }

    public boolean isSubmergedPlant() {
        return this.plantData.attributes.category == PMPPlantCategory.CORAL || this.plantData.attributes.category == PMPPlantCategory.FRESHWATER || this.plantData.attributes.category == PMPPlantCategory.SALTWATER;
    }

    public boolean isTopPlantBlock(World world, int x, int y, int z) {
        if (this.plantData.attributes.growthType == PMPPlantGrowthType.SEAWEED || this.plantData.attributes.growthType == PMPPlantGrowthType.STALK || this.plantData.attributes.category == PMPPlantCategory.VINE) {
            return this != world.func_147439_a(x, y + 1, z);
        }
        int metaData = world.func_72805_g(x, y, z);
        if (this.plantData.attributes.growthType == PMPPlantGrowthType.DOUBLE && !this.isImmersedPlant()) {
            return metaData == 3 || metaData == 5 || metaData == 7;
        }
        return true;
    }

    private boolean growStalkPlantFromBottom(World world, int x, int y, int z) {
        int currentHeight = this.getPlantHeightFromBase(world, x, y, z);
        if (!world.func_147437_c(x, y + currentHeight, z) || currentHeight >= this.plantData.attributes.growthMax) {
            return false;
        }
        world.func_147465_d(x, y + currentHeight, z, (Block)this, 4, 2);
        this.updateBambooFromTop(world, x, y + currentHeight, z);
        return true;
    }

    public void updateBambooFromTop(World world, int x, int y, int z) {
        int currentHeight = y;
        int count = this.getPlantHeightFromTop(world, x, y, z);
        int icon = 4;
        while (count > 0) {
            --count;
            --currentHeight;
            if (icon > 0) {
                switch (this.plantData.attributes.renderSubtype) {
                    default: {
                        --icon;
                        break;
                    }
                    case 1: {
                        if (count > 3) {
                            icon = 3;
                            break;
                        }
                        --icon;
                        break;
                    }
                    case 2: {
                        icon = 1 + world.field_73012_v.nextInt(3);
                    }
                }
            }
            world.func_72921_c(x, currentHeight, z, icon, 3);
        }
    }

    public int getPlantHeightFromBase(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Block blockAbove = world.func_147439_a(x, y + 1, z);
        int height = 1;
        while (block == blockAbove) {
            blockAbove = world.func_147439_a(x, y + ++height, z);
        }
        return height;
    }

    public int getPlantHeightFromTop(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        int height = 1;
        while (block == blockBelow) {
            blockBelow = world.func_147439_a(x, y - ++height, z);
        }
        return height;
    }

    public int getSubBlocksCount() {
        int count = 0;
        if (this.plantData.attributes.category == PMPPlantCategory.FLOATING) {
            for (int index = 0; index < this.plantData.attributes.plantData.length(); ++index) {
                if (this.plantData.attributes.plantData.charAt(index) != '1') continue;
                ++count;
            }
            if (count < 0 || count > 15) {
                count = 0;
            }
        } else if (this.plantData.attributes.category == PMPPlantCategory.FLOWER_MULTI) {
            for (int index = 0; index < this.plantData.attributes.plantData.length(); ++index) {
                if (this.plantData.attributes.plantData.charAt(index) != '1') continue;
                ++count;
            }
            if (count < 0 || count > 15) {
                count = 0;
            }
        }
        return count;
    }

    private boolean func_150093_a(Block block) {
        return block.func_149686_d() && block.func_149688_o().func_76230_c();
    }

    private boolean func_150094_e(World world, int x, int y, int z) {
        int l;
        int i1 = l = world.func_72805_g(x, y, z);
        if (l > 0) {
            for (int j1 = 0; j1 <= 3; ++j1) {
                int k1 = 1 << j1;
                if ((l & k1) == 0 || this.func_150093_a(world.func_147439_a(x + Direction.field_71583_a[j1], y, z + Direction.field_71581_b[j1])) || world.func_147439_a(x, y + 1, z) == this && (world.func_72805_g(x, y + 1, z) & k1) != 0) continue;
                i1 &= ~k1;
            }
        }
        if (i1 == 0 && !this.func_150093_a(world.func_147439_a(x, y + 1, z))) {
            return false;
        }
        if (i1 != l) {
            world.func_72921_c(x, y, z, i1, 2);
        }
        return true;
    }

    private ItemStack getBerryItemStack(int metaData, int quantity) {
        String blockName = this.func_149739_a().substring(5);
        ItemStack berries = null;
        if (this.isFullyGrown(metaData)) {
            if (blockName.matches("berrybushBeauty")) {
                berries = new ItemStack((Item)PlantMegaPack.items.getFoodItem("berriesBeauty"), quantity, 0);
            } else if (blockName.matches("berrybushBlack")) {
                berries = new ItemStack((Item)PlantMegaPack.items.getFoodItem("berriesBlack"), quantity, 0);
            } else if (blockName.matches("berrybushBlue")) {
                berries = new ItemStack((Item)PlantMegaPack.items.getFoodItem("berriesBlue"), quantity, 0);
            } else if (blockName.matches("berrybushElder")) {
                berries = new ItemStack((Item)PlantMegaPack.items.getFoodItem("berriesElder"), quantity, 0);
            } else if (blockName.matches("berrybushGoose")) {
                berries = new ItemStack((Item)PlantMegaPack.items.getFoodItem("berriesGoose"), quantity, 0);
            } else if (blockName.matches("berrybushHuckle")) {
                berries = new ItemStack((Item)PlantMegaPack.items.getFoodItem("berriesHuckle"), quantity, 0);
            } else if (blockName.matches("berrybushOrange")) {
                berries = new ItemStack((Item)PlantMegaPack.items.getFoodItem("berriesOrange"), quantity, 0);
            } else if (blockName.matches("berrybushSnow")) {
                berries = new ItemStack((Item)PlantMegaPack.items.getFoodItem("berriesSnow"), quantity, 0);
            } else if (blockName.matches("berrybushStraw")) {
                berries = new ItemStack((Item)PlantMegaPack.items.getFoodItem("berriesStraw"), quantity, 0);
            }
        }
        return berries;
    }

    private ItemStack getFoodItemStack(String name, int quantity) {
        if (name.matches("cropBeet")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodBeet"), quantity, 0);
        }
        if (name.matches("cropBellPepperOrange")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodBellPepperOrange"), quantity, 0);
        }
        if (name.matches("cropBellPepperRed")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodBellPepperRed"), quantity, 0);
        }
        if (name.matches("cropBellPepperYellow")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodBellPepperYellow"), quantity, 0);
        }
        if (name.matches("cropBroccoli")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodBroccoli"), quantity, 0);
        }
        if (name.matches("cropCassava")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodCassavaRoot"), quantity, 0);
        }
        if (name.matches("cropCelery")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodCelery"), quantity, 0);
        }
        if (name.matches("cropCorn")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodCorn"), quantity, 0);
        }
        if (name.matches("cropCucumber")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodCucumber"), quantity, 0);
        }
        if (name.matches("cropEggplant")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodEggplant"), quantity, 0);
        }
        if (name.matches("cropGreenBeans")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodGreenBeans"), quantity, 0);
        }
        if (name.matches("cropLeek")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodLeek"), quantity, 0);
        }
        if (name.matches("cropLettuce")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodLettuce"), quantity, 0);
        }
        if (name.matches("cropOnion")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodOnion"), quantity, 0);
        }
        if (name.matches("cropPeanut")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodPeanuts"), quantity, 0);
        }
        if (name.matches("cropRice")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodRice"), quantity, 0);
        }
        if (name.matches("cropSorrel")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodSorrel"), quantity, 0);
        }
        if (name.matches("cropSpinach")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodSpinach"), quantity, 0);
        }
        if (name.matches("cropTomato")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodTomato"), quantity, 0);
        }
        if (name.matches("cropCentella")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodCentellaLeaves"), quantity, 0);
        }
        if (name.matches("cropLaksaLeaf")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodLaksaLeaves"), quantity, 0);
        }
        if (name.matches("cropRice")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodRice"), quantity, 0);
        }
        if (name.matches("cropSacredLotus")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodSacredLotusRoot"), quantity, 0);
        }
        if (name.matches("cropTaro")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodTaroRoot"), quantity, 0);
        }
        if (name.matches("cropWasabi")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodWasabiStem"), quantity, 0);
        }
        if (name.matches("cropWatercress")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodWatercress"), quantity, 0);
        }
        if (name.matches("cropWaterSpinach")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodSpinach"), quantity, 0);
        }
        if (name.matches("cropWildRice")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodWildRice"), quantity, 0);
        }
        return null;
    }

    private ItemStack getSeedItemStack(String name, int quantity) {
        if (name.matches("cropBeet")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedBeet"), quantity, 0);
        }
        if (name.matches("cropBellPepperOrange")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedBellPepperOrange"), quantity, 0);
        }
        if (name.matches("cropBellPepperRed")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedBellPepperRed"), quantity, 0);
        }
        if (name.matches("cropBellPepperYellow")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedBellPepperYellow"), quantity, 0);
        }
        if (name.matches("cropBroccoli")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedBroccoli"), quantity, 0);
        }
        if (name.matches("cropCassava")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedCassava"), quantity, 0);
        }
        if (name.matches("cropCelery")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedCelery"), quantity, 0);
        }
        if (name.matches("cropCorn")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedCorn"), quantity, 0);
        }
        if (name.matches("cropCucumber")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedCucumber"), quantity, 0);
        }
        if (name.matches("cropEggplant")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedEggplant"), quantity, 0);
        }
        if (name.matches("cropGreenBeans")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedGreenBean"), quantity, 0);
        }
        if (name.matches("cropLeek")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedLeek"), quantity, 0);
        }
        if (name.matches("cropLettuce")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedLettuce"), quantity, 0);
        }
        if (name.matches("cropOnion")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedOnion"), quantity, 0);
        }
        if (name.matches("cropPeanut")) {
            return new ItemStack((Item)PlantMegaPack.items.getFoodItem("foodPeanuts"), quantity, 0);
        }
        if (name.matches("cropSorrel")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedSorrel"), quantity, 0);
        }
        if (name.matches("cropSpinach")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedSpinach"), quantity, 0);
        }
        if (name.matches("cropTomato")) {
            return new ItemStack((Item)PlantMegaPack.items.getCropSeed("seedTomato"), quantity, 0);
        }
        return null;
    }
}

