/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.bin;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.BlockClay;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import plantmegapack.PlantMegaPack;
import plantmegapack.common.PMPPlantSoilType;

public class PMPSoilBlocks {
    private File optionsFile;
    private ArrayList<String> listAquatic = new ArrayList();
    private ArrayList<String> listClay = new ArrayList();
    private ArrayList<String> listCrop = new ArrayList();
    private ArrayList<String> listDirt = new ArrayList();
    private ArrayList<String> listGravel = new ArrayList();
    private ArrayList<String> listNether = new ArrayList();
    private ArrayList<String> listSand = new ArrayList();
    private ArrayList<String> listStone = new ArrayList();
    private ArrayList<String> listWood = new ArrayList();

    public PMPSoilBlocks(String configPath) {
        this.optionsFile = new File(configPath + "soilblocks.cfg");
        if (!this.loadConfiguration()) {
            this.resetDefaults();
        }
    }

    public void addSoilBlock(PMPPlantSoilType soilType, String blockName) {
        switch (soilType) {
            case AQUATIC: {
                this.listAquatic.add(blockName);
                this.sortList(PMPPlantSoilType.AQUATIC);
                break;
            }
            case CLAY: {
                this.listClay.add(blockName);
                this.sortList(PMPPlantSoilType.CLAY);
                break;
            }
            case CROP: {
                this.listCrop.add(blockName);
                this.sortList(PMPPlantSoilType.CROP);
                break;
            }
            case DIRT: {
                this.listDirt.add(blockName);
                this.sortList(PMPPlantSoilType.DIRT);
                break;
            }
            case GRAVEL: {
                this.listGravel.add(blockName);
                this.sortList(PMPPlantSoilType.GRAVEL);
                break;
            }
            case NETHER: {
                this.listNether.add(blockName);
                this.sortList(PMPPlantSoilType.NETHER);
                break;
            }
            case SAND: {
                this.listSand.add(blockName);
                this.sortList(PMPPlantSoilType.SAND);
                break;
            }
            case STONE: {
                this.listStone.add(blockName);
                this.sortList(PMPPlantSoilType.STONE);
                break;
            }
            case WOOD: {
                this.listWood.add(blockName);
                this.sortList(PMPPlantSoilType.WOOD);
                break;
            }
        }
    }

    public ArrayList<String> getSoilBlocksList(PMPPlantSoilType soilType) {
        switch (soilType) {
            case AQUATIC: {
                return this.listAquatic;
            }
            case CLAY: {
                return this.listClay;
            }
            case CROP: {
                return this.listCrop;
            }
            case DIRT: {
                return this.listDirt;
            }
            case GRAVEL: {
                return this.listGravel;
            }
            case NETHER: {
                return this.listNether;
            }
            case SAND: {
                return this.listSand;
            }
            case STONE: {
                return this.listStone;
            }
            case WOOD: {
                return this.listWood;
            }
        }
        return null;
    }

    public void resetDefaults() {
        this.resetList(PMPPlantSoilType.AQUATIC);
        this.resetList(PMPPlantSoilType.CLAY);
        this.resetList(PMPPlantSoilType.CROP);
        this.resetList(PMPPlantSoilType.DIRT);
        this.resetList(PMPPlantSoilType.GRAVEL);
        this.resetList(PMPPlantSoilType.NETHER);
        this.resetList(PMPPlantSoilType.SAND);
        this.resetList(PMPPlantSoilType.STONE);
        this.resetList(PMPPlantSoilType.WOOD);
    }

    public void resetList(PMPPlantSoilType soilType) {
        ArrayList<String> list = this.getSoilBlocksList(soilType);
        if (list != null) {
            list.clear();
            switch (soilType) {
                case AQUATIC: {
                    break;
                }
                case CLAY: {
                    break;
                }
                case CROP: {
                    break;
                }
                case DIRT: {
                    break;
                }
                case GRAVEL: {
                    break;
                }
                case NETHER: {
                    break;
                }
                case SAND: {
                    break;
                }
                case STONE: {
                    break;
                }
                case WOOD: {
                    break;
                }
            }
        }
    }

    private void sortList(PMPPlantSoilType soilType) {
        switch (soilType) {
            case AQUATIC: {
                Collections.sort(this.listAquatic);
                break;
            }
            case CLAY: {
                Collections.sort(this.listClay);
                break;
            }
            case CROP: {
                Collections.sort(this.listCrop);
                break;
            }
            case DIRT: {
                Collections.sort(this.listDirt);
                break;
            }
            case GRAVEL: {
                Collections.sort(this.listGravel);
                break;
            }
            case NETHER: {
                Collections.sort(this.listNether);
                break;
            }
            case SAND: {
                Collections.sort(this.listSand);
                break;
            }
            case STONE: {
                Collections.sort(this.listStone);
                break;
            }
            case WOOD: {
                Collections.sort(this.listWood);
                break;
            }
        }
    }

    public boolean loadConfiguration() {
        try {
            if (!this.optionsFile.exists()) {
                this.resetDefaults();
                return this.saveFile();
            }
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.optionsFile));
            String line = "";
            while ((line = bufferedreader.readLine()) != null) {
                try {
                    if (line.length() <= 0 || line.startsWith("#")) continue;
                    String[] astring = line.split(":");
                    if (astring[0].equals("aquatic")) {
                        this.listAquatic.add(astring[1]);
                        continue;
                    }
                    if (astring[0].equals("clay")) {
                        this.listClay.add(astring[1]);
                        continue;
                    }
                    if (astring[0].equals("crop")) {
                        this.listCrop.add(astring[1]);
                        continue;
                    }
                    if (astring[0].equals("dirt")) {
                        this.listDirt.add(astring[1]);
                        continue;
                    }
                    if (astring[0].equals("gravel")) {
                        this.listGravel.add(astring[1]);
                        continue;
                    }
                    if (astring[0].equals("nether")) {
                        this.listNether.add(astring[1]);
                        continue;
                    }
                    if (astring[0].equals("sand")) {
                        this.listSand.add(astring[1]);
                        continue;
                    }
                    if (astring[0].equals("stone")) {
                        this.listStone.add(astring[1]);
                        continue;
                    }
                    if (!astring[0].equals("wood")) continue;
                    this.listWood.add(astring[1]);
                }
                catch (Exception exception) {
                    PlantMegaPack.instance.logOutput("Skipping bad entry");
                }
            }
            bufferedreader.close();
        }
        catch (Exception exception1) {
            PlantMegaPack.instance.logOutput("Failed to load config file: soilblocks.cfg");
            return false;
        }
        PlantMegaPack.instance.logOutput("Config file loaded: soilblocks.cfg");
        return true;
    }

    public boolean saveConfiguration() {
        if (FMLClientHandler.instance().isLoading()) {
            return false;
        }
        return this.saveFile();
    }

    private boolean saveFile() {
        try {
            this.sortList(PMPPlantSoilType.AQUATIC);
            this.sortList(PMPPlantSoilType.CLAY);
            this.sortList(PMPPlantSoilType.CROP);
            this.sortList(PMPPlantSoilType.DIRT);
            this.sortList(PMPPlantSoilType.GRAVEL);
            this.sortList(PMPPlantSoilType.NETHER);
            this.sortList(PMPPlantSoilType.SAND);
            this.sortList(PMPPlantSoilType.STONE);
            this.sortList(PMPPlantSoilType.WOOD);
            if (!this.optionsFile.exists()) {
                this.optionsFile.createNewFile();
                this.optionsFile.setWritable(true);
                PlantMegaPack.instance.logOutput("Create new config file: soilblocks.cfg");
            }
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            for (String name : this.listAquatic) {
                printwriter.println("aquatic:" + name);
            }
            for (String name : this.listClay) {
                printwriter.println("clay:" + name);
            }
            for (String name : this.listCrop) {
                printwriter.println("crop:" + name);
            }
            for (String name : this.listDirt) {
                printwriter.println("dirt:" + name);
            }
            for (String name : this.listGravel) {
                printwriter.println("gravel:" + name);
            }
            for (String name : this.listNether) {
                printwriter.println("nether:" + name);
            }
            for (String name : this.listSand) {
                printwriter.println("sand:" + name);
            }
            for (String name : this.listStone) {
                printwriter.println("stone:" + name);
            }
            for (String name : this.listWood) {
                printwriter.println("wood:" + name);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            PlantMegaPack.instance.logOutput("Failed to save config file: soilblocks.cfg");
            return false;
        }
        PlantMegaPack.instance.logOutput("Config file saved: soilblocks.cfg");
        return true;
    }

    public boolean canPlantOnThisBlock(PMPPlantSoilType soilType, Block block) {
        switch (soilType) {
            case AQUATIC: {
                if (block != Blocks.field_150435_aG && !(block instanceof BlockClay) && block.func_149688_o() != Material.field_151571_B && block != Blocks.field_150346_d && !(block instanceof BlockDirt) && block != Blocks.field_150351_n && !(block instanceof BlockGravel) && block != Blocks.field_150354_m && !(block instanceof BlockSand) && block.func_149688_o() != Material.field_151595_p) break;
                return true;
            }
            case BEACH: {
                if (block != Blocks.field_150346_d && !(block instanceof BlockDirt) && block != Blocks.field_150351_n && !(block instanceof BlockGravel) && block != Blocks.field_150354_m && !(block instanceof BlockSand) && block.func_149688_o() != Material.field_151595_p) break;
                return true;
            }
            case CLAY: {
                if (block != Blocks.field_150435_aG && !(block instanceof BlockClay) && block.func_149688_o() != Material.field_151571_B && !this.isJaquadroBlock(block)) break;
                return true;
            }
            case CROP: {
                return block == Blocks.field_150458_ak || block instanceof BlockFarmland || this.isJaquadroBlock(block);
            }
            case DIRT: {
                if (block != Blocks.field_150346_d && !(block instanceof BlockDirt) && block != Blocks.field_150458_ak && !(block instanceof BlockFarmland) && !this.isGrassBlock(block) && block != Blocks.field_150391_bh && !(block instanceof BlockMycelium) && !this.isJaquadroBlock(block)) break;
                return true;
            }
            case GRAVEL: {
                if (block != Blocks.field_150351_n && !(block instanceof BlockGravel) && !this.isJaquadroBlock(block)) break;
                return true;
            }
            case NETHER: {
                if (block != Blocks.field_150424_aL && !(block instanceof BlockNetherrack) && block != Blocks.field_150425_aM && !(block instanceof BlockSoulSand)) break;
                return true;
            }
            case SAND: {
                if (block != Blocks.field_150354_m && !(block instanceof BlockSand) && block.func_149688_o() != Material.field_151595_p && !this.isJaquadroBlock(block)) break;
                return true;
            }
            case STONE: {
                if (block != Blocks.field_150377_bs && block != Blocks.field_150341_Y && block != Blocks.field_150348_b && !(block instanceof BlockStone) && block.func_149688_o() != Material.field_151576_e && !this.isJaquadroBlock(block)) break;
                return true;
            }
            case WOOD: {
                return block == Blocks.field_150364_r || block == Blocks.field_150363_s || block instanceof BlockLog || block.func_149688_o() == Material.field_151575_d;
            }
        }
        return block.func_149688_o() == Material.field_151578_c;
    }

    public boolean isGrassBlock(Block block) {
        return block == Blocks.field_150349_c || block instanceof BlockGrass || block.func_149688_o() == Material.field_151577_b;
    }

    private boolean isJaquadroBlock(Block block) {
        if (block == null) {
            return false;
        }
        try {
            String unlocalizedName = block.func_149739_a();
            if (unlocalizedName == null || unlocalizedName.isEmpty()) {
                return false;
            }
            return unlocalizedName.matches("tile.garden_soil") || unlocalizedName.matches("tile.garden_farmland") || unlocalizedName.matches("tile.largePot") || unlocalizedName.matches("tile.largePotColored");
        }
        catch (Exception e) {
            return false;
        }
    }
}

