/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.bin;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import plantmegapack.PlantMegaPack;
import plantmegapack.common.PMPCoralFragment;
import plantmegapack.common.PMPCropSeed;
import plantmegapack.common.PMPFood;
import plantmegapack.common.PMPFoodType;
import plantmegapack.common.PMPModInfo;
import plantmegapack.common.PMPPlantItem;
import plantmegapack.common.PMPPlantPowder;
import plantmegapack.common.PMPSalve;
import plantmegapack.common.PMPTab;
import plantmegapack.item.PMPItemCoralFragment;
import plantmegapack.item.PMPItemCropSeed;
import plantmegapack.item.PMPItemFood;
import plantmegapack.item.PMPItemPlantItem;
import plantmegapack.item.PMPItemPowder;
import plantmegapack.item.PMPItemSalve;

public class PMPItems {
    private Map<String, PMPItemCropSeed> cropSeeds = new HashMap<String, PMPItemCropSeed>();
    private Map<String, PMPItemFood> foodItems = new HashMap<String, PMPItemFood>();
    private Map<String, PMPItemCoralFragment> coralFragments = new HashMap<String, PMPItemCoralFragment>();
    private Map<String, PMPItemPowder> powders = new HashMap<String, PMPItemPowder>();
    private Map<String, PMPItemSalve> salves = new HashMap<String, PMPItemSalve>();
    private Map<String, PMPItemPlantItem> plantItems = new HashMap<String, PMPItemPlantItem>();

    public PMPItems() {
        if (PlantMegaPack.settings.contentCrops) {
            for (Enum enum_ : PMPCropSeed.values()) {
                this.cropSeeds.put(((PMPCropSeed)enum_).unlocalizedName, new PMPItemCropSeed((Block)PlantMegaPack.blocks.getPlantBlock(((PMPCropSeed)enum_).parentBlock), ((PMPCropSeed)enum_).unlocalizedName));
                PMPModInfo.addToRegisteredItems(1);
            }
        } else {
            PlantMegaPack.instance.logOutput("Crop seed items disabled");
        }
        for (Enum enum_ : PMPFood.values()) {
            if (((PMPFood)enum_).foodType == PMPFoodType.aquatic && !PlantMegaPack.settings.contentAquatic || ((PMPFood)enum_).foodType == PMPFoodType.crop && !PlantMegaPack.settings.contentCrops) continue;
            this.foodItems.put(((PMPFood)enum_).unlocalizedName, new PMPItemFood((PMPFood)enum_));
            PMPModInfo.addToRegisteredItems(1);
        }
        if (PlantMegaPack.settings.contentAquatic) {
            for (Enum enum_ : PMPCoralFragment.values()) {
                this.coralFragments.put(((PMPCoralFragment)enum_).unlocalizedName, new PMPItemCoralFragment((PMPCoralFragment)enum_));
                PMPModInfo.addToRegisteredItems(1);
            }
        }
        for (Enum enum_ : PMPPlantPowder.values()) {
            if (!PlantMegaPack.settings.contentAquatic && ((PMPPlantPowder)enum_).tab == PMPTab.aquatic || !PlantMegaPack.settings.contentCrops && ((PMPPlantPowder)enum_).tab == PMPTab.crops) continue;
            this.powders.put(((PMPPlantPowder)enum_).unlocalizedName, new PMPItemPowder((PMPPlantPowder)enum_));
            PMPModInfo.addToRegisteredItems(1);
        }
        for (Enum enum_ : PMPSalve.values()) {
            this.salves.put(((PMPSalve)enum_).unlocalizedName, new PMPItemSalve((PMPSalve)enum_));
            PMPModInfo.addToRegisteredItems(1);
        }
        for (Enum enum_ : PMPPlantItem.values()) {
            this.plantItems.put(((PMPPlantItem)enum_).unlocalizedName, new PMPItemPlantItem((PMPPlantItem)enum_));
            PMPModInfo.addToRegisteredItems(1);
        }
        PMPModInfo.addToRegisteredChestItems(this.addItemsToSpawnedChests());
    }

    public PMPItemCoralFragment getCoralFragment(String unlocalizedName) {
        return this.coralFragments == null ? null : this.coralFragments.get(unlocalizedName);
    }

    public PMPItemCropSeed getCropSeed(String unlocalizedName) {
        return this.cropSeeds == null ? null : this.cropSeeds.get(unlocalizedName);
    }

    public PMPItemCropSeed getCropSeedFromPlantBlock(String unlocalizedName) {
        if (this.cropSeeds == null) {
            return null;
        }
        for (PMPCropSeed seed : PMPCropSeed.values()) {
            if (!unlocalizedName.matches(seed.parentBlock)) continue;
            return this.cropSeeds.get(seed.unlocalizedName);
        }
        return null;
    }

    public PMPItemFood getFoodItem(String unlocalizedName) {
        return this.foodItems == null ? null : this.foodItems.get(unlocalizedName);
    }

    public PMPItemPowder getPlantPowder(String unlocalizedName) {
        return this.powders == null ? null : this.powders.get(unlocalizedName);
    }

    public PMPItemSalve getSalve(String unlocalizedName) {
        return this.salves == null ? null : this.salves.get(unlocalizedName);
    }

    public PMPItemPlantItem getPlantItem(String unlocalizedName) {
        return this.plantItems == null ? null : this.plantItems.get(unlocalizedName);
    }

    private int addItemsToSpawnedChests() {
        int chestItems = 0;
        ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.plantItems.get("leafAloe")), 1, 1, 2));
        ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.plantItems.get("leafAloe")), 1, 1, 2));
        ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.plantItems.get("leafAloe")), 1, 1, 2));
        chestItems += 3;
        ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.foodItems.get("berriesHarlequinMistletoe")), 1, 1, 2));
        ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.foodItems.get("foodPricklyPearFruit")), 1, 1, 2));
        chestItems += 2;
        if (PlantMegaPack.settings.contentCrops && PlantMegaPack.settings.contentChestSeeds) {
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedBeet")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedBellPepperYellow")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedCelery")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedCorn")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedCucumber")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedLettuce")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedOnion")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedSpinach")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedTomato")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.foodItems.get("foodPeanuts")), 1, 2, 2));
            chestItems += 10;
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedBeet")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedBellPepperYellow")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedCelery")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedCorn")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedCucumber")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedLettuce")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedOnion")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedSpinach")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedTomato")), 1, 2, 2));
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.foodItems.get("foodPeanuts")), 1, 2, 2));
            chestItems += 10;
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedBeet")), 1, 2, 3));
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedBellPepperYellow")), 1, 2, 3));
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedCelery")), 1, 2, 3));
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedCorn")), 1, 2, 3));
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedCucumber")), 1, 2, 3));
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedLettuce")), 1, 2, 3));
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedOnion")), 1, 2, 3));
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedSpinach")), 1, 2, 3));
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.cropSeeds.get("seedTomato")), 1, 2, 3));
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack((Item)this.foodItems.get("foodPeanuts")), 1, 2, 2));
            chestItems += 10;
        }
        return chestItems;
    }
}

